/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2015 Samsung Electronics
 * Copyright 2020 Google Inc
 * Copyright 2025 Linaro Ltd.
 */

#ifndef __LINUX_MFD_S2MPG11_H
#define __LINUX_MFD_S2MPG11_H

/* Common registers (type 0x000) */
enum s2mpg11_common_reg {
	S2MPG11_COMMON_CHIPID,
	S2MPG11_COMMON_INT,
	S2MPG11_COMMON_INT_MASK,
	S2MPG11_COMMON_SPD_CTRL1 = 0x0a,
	S2MPG11_COMMON_SPD_CTRL2,
	S2MPG11_COMMON_SPD_CTRL3,
	S2MPG11_COMMON_MON1SEL = 0x1a,
	S2MPG11_COMMON_MON2SEL,
	S2MPG11_COMMON_MONR,
	S2MPG11_COMMON_DEBUG_CTRL1,
	S2MPG11_COMMON_DEBUG_CTRL2,
	S2MPG11_COMMON_DEBUG_CTRL3,
	S2MPG11_COMMON_DEBUG_CTRL4,
	S2MPG11_COMMON_DEBUG_CTRL5,
	S2MPG11_COMMON_DEBUG_CTRL6,
	S2MPG11_COMMON_TEST_MODE1,
	S2MPG11_COMMON_SPD_DEBUG1,
	S2MPG11_COMMON_SPD_DEBUG2,
	S2MPG11_COMMON_SPD_DEBUG3,
	S2MPG11_COMMON_SPD_DEBUG4,
};

/* For S2MPG11_COMMON_INT and S2MPG11_COMMON_INT_MASK */
#define S2MPG11_COMMON_INT_SRC       GENMASK(2, 0)
#define S2MPG11_COMMON_INT_SRC_PMIC  BIT(0)

/* PMIC registers (type 0x100) */
enum s2mpg11_pmic_reg {
	S2MPG11_PMIC_INT1,
	S2MPG11_PMIC_INT2,
	S2MPG11_PMIC_INT3,
	S2MPG11_PMIC_INT4,
	S2MPG11_PMIC_INT5,
	S2MPG11_PMIC_INT6,
	S2MPG11_PMIC_INT1M,
	S2MPG11_PMIC_INT2M,
	S2MPG11_PMIC_INT3M,
	S2MPG11_PMIC_INT4M,
	S2MPG11_PMIC_INT5M,
	S2MPG11_PMIC_INT6M,
	S2MPG11_PMIC_STATUS1,
	S2MPG11_PMIC_OFFSRC,
	S2MPG11_PMIC_COMMON_CTRL1,
	S2MPG11_PMIC_COMMON_CTRL2,
	S2MPG11_PMIC_COMMON_CTRL3,
	S2MPG11_PMIC_MIMICKING_CTRL,
	S2MPG11_PMIC_B1S_CTRL,
	S2MPG11_PMIC_B1S_OUT1,
	S2MPG11_PMIC_B1S_OUT2,
	S2MPG11_PMIC_B2S_CTRL,
	S2MPG11_PMIC_B2S_OUT1,
	S2MPG11_PMIC_B2S_OUT2,
	S2MPG11_PMIC_B3S_CTRL,
	S2MPG11_PMIC_B3S_OUT1,
	S2MPG11_PMIC_B3S_OUT2,
	S2MPG11_PMIC_B4S_CTRL,
	S2MPG11_PMIC_B4S_OUT,
	S2MPG11_PMIC_B5S_CTRL,
	S2MPG11_PMIC_B5S_OUT,
	S2MPG11_PMIC_B6S_CTRL,
	S2MPG11_PMIC_B6S_OUT1,
	S2MPG11_PMIC_B6S_OUT2,
	S2MPG11_PMIC_B7S_CTRL,
	S2MPG11_PMIC_B7S_OUT1,
	S2MPG11_PMIC_B7S_OUT2,
	S2MPG11_PMIC_B8S_CTRL,
	S2MPG11_PMIC_B8S_OUT1,
	S2MPG11_PMIC_B8S_OUT2,
	S2MPG11_PMIC_B9S_CTRL,
	S2MPG11_PMIC_B9S_OUT1,
	S2MPG11_PMIC_B9S_OUT2,
	S2MPG11_PMIC_B10S_CTRL,
	S2MPG11_PMIC_B10S_OUT,
	S2MPG11_PMIC_BUCKD_CTRL,
	S2MPG11_PMIC_BUCKD_OUT,
	S2MPG11_PMIC_BUCKA_CTRL,
	S2MPG11_PMIC_BUCKA_OUT,
	S2MPG11_PMIC_BB_CTRL,
	S2MPG11_PMIC_BB_OUT1,
	S2MPG11_PMIC_BB_OUT2,
	S2MPG11_PMIC_BUCK1S_USONIC,
	S2MPG11_PMIC_BUCK2S_USONIC,
	S2MPG11_PMIC_BUCK3S_USONIC,
	S2MPG11_PMIC_BUCK4S_USONIC,
	S2MPG11_PMIC_BUCK5S_USONIC,
	S2MPG11_PMIC_BUCK6S_USONIC,
	S2MPG11_PMIC_BUCK7S_USONIC,
	S2MPG11_PMIC_BUCK8S_USONIC,
	S2MPG11_PMIC_BUCK9S_USONIC,
	S2MPG11_PMIC_BUCK10S_USONIC,
	S2MPG11_PMIC_BUCKD_USONIC,
	S2MPG11_PMIC_BUCKA_USONIC,
	S2MPG11_PMIC_BB_USONIC,
	S2MPG11_PMIC_L1S_CTRL1,
	S2MPG11_PMIC_L1S_CTRL2,
	S2MPG11_PMIC_L2S_CTRL1,
	S2MPG11_PMIC_L2S_CTRL2,
	S2MPG11_PMIC_L3S_CTRL,
	S2MPG11_PMIC_L4S_CTRL,
	S2MPG11_PMIC_L5S_CTRL,
	S2MPG11_PMIC_L6S_CTRL,
	S2MPG11_PMIC_L7S_CTRL,
	S2MPG11_PMIC_L8S_CTRL,
	S2MPG11_PMIC_L9S_CTRL,
	S2MPG11_PMIC_L10S_CTRL,
	S2MPG11_PMIC_L11S_CTRL,
	S2MPG11_PMIC_L12S_CTRL,
	S2MPG11_PMIC_L13S_CTRL,
	S2MPG11_PMIC_L14S_CTRL,
	S2MPG11_PMIC_L15S_CTRL,
	S2MPG11_PMIC_LDO_CTRL1,
	S2MPG11_PMIC_LDO_DSCH1,
	S2MPG11_PMIC_LDO_DSCH2,
	S2MPG11_PMIC_DVS_RAMP1,
	S2MPG11_PMIC_DVS_RAMP2,
	S2MPG11_PMIC_DVS_RAMP3,
	S2MPG11_PMIC_DVS_RAMP4,
	S2MPG11_PMIC_DVS_RAMP5,
	S2MPG11_PMIC_DVS_RAMP6,
	/* Nothing @ 0x5a */
	S2MPG11_PMIC_DVS_SYNC_CTRL1 = 0x5c,
	S2MPG11_PMIC_DVS_SYNC_CTRL2,
	S2MPG11_PMIC_OFF_CTRL1,
	S2MPG11_PMIC_OFF_CTRL2,
	S2MPG11_PMIC_OFF_CTRL3,
	S2MPG11_PMIC_SEQ_CTRL1,
	S2MPG11_PMIC_SEQ_CTRL2,
	S2MPG11_PMIC_SEQ_CTRL3,
	S2MPG11_PMIC_SEQ_CTRL4,
	S2MPG11_PMIC_SEQ_CTRL5,
	S2MPG11_PMIC_SEQ_CTRL6,
	S2MPG11_PMIC_SEQ_CTRL7,
	S2MPG11_PMIC_SEQ_CTRL8,
	S2MPG11_PMIC_SEQ_CTRL9,
	S2MPG11_PMIC_SEQ_CTRL10,
	S2MPG11_PMIC_SEQ_CTRL11,
	S2MPG11_PMIC_SEQ_CTRL12,
	S2MPG11_PMIC_SEQ_CTRL13,
	S2MPG11_PMIC_SEQ_CTRL14,
	S2MPG11_PMIC_SEQ_CTRL15,
	S2MPG11_PMIC_SEQ_CTRL16,
	S2MPG11_PMIC_SEQ_CTRL17,
	S2MPG11_PMIC_SEQ_CTRL18,
	S2MPG11_PMIC_SEQ_CTRL19,
	S2MPG11_PMIC_SEQ_CTRL20,
	S2MPG11_PMIC_SEQ_CTRL21,
	S2MPG11_PMIC_SEQ_CTRL22,
	S2MPG11_PMIC_SEQ_CTRL23,
	S2MPG11_PMIC_SEQ_CTRL24,
	S2MPG11_PMIC_SEQ_CTRL25,
	S2MPG11_PMIC_SEQ_CTRL26,
	S2MPG11_PMIC_SEQ_CTRL27,
	S2MPG11_PMIC_OFF_SEQ_CTRL1,
	S2MPG11_PMIC_OFF_SEQ_CTRL2,
	S2MPG11_PMIC_OFF_SEQ_CTRL3,
	S2MPG11_PMIC_OFF_SEQ_CTRL4,
	S2MPG11_PMIC_OFF_SEQ_CTRL5,
	S2MPG11_PMIC_OFF_SEQ_CTRL6,
	S2MPG11_PMIC_OFF_SEQ_CTRL7,
	S2MPG11_PMIC_OFF_SEQ_CTRL8,
	S2MPG11_PMIC_OFF_SEQ_CTRL9,
	S2MPG11_PMIC_OFF_SEQ_CTRL10,
	S2MPG11_PMIC_OFF_SEQ_CTRL11,
	S2MPG11_PMIC_OFF_SEQ_CTRL12,
	S2MPG11_PMIC_OFF_SEQ_CTRL13,
	S2MPG11_PMIC_OFF_SEQ_CTRL14,
	S2MPG11_PMIC_OFF_SEQ_CTRL15,
	S2MPG11_PMIC_OFF_SEQ_CTRL16,
	S2MPG11_PMIC_OFF_SEQ_CTRL17,
	S2MPG11_PMIC_PCTRLSEL1,
	S2MPG11_PMIC_PCTRLSEL2,
	S2MPG11_PMIC_PCTRLSEL3,
	S2MPG11_PMIC_PCTRLSEL4,
	S2MPG11_PMIC_PCTRLSEL5,
	S2MPG11_PMIC_PCTRLSEL6,
	S2MPG11_PMIC_DCTRLSEL1,
	S2MPG11_PMIC_DCTRLSEL2,
	S2MPG11_PMIC_DCTRLSEL3,
	S2MPG11_PMIC_DCTRLSEL4,
	S2MPG11_PMIC_DCTRLSEL5,
	S2MPG11_PMIC_GPIO_CTRL1,
	S2MPG11_PMIC_GPIO_CTRL2,
	S2MPG11_PMIC_GPIO_CTRL3,
	S2MPG11_PMIC_GPIO_CTRL4,
	S2MPG11_PMIC_GPIO_CTRL5,
	S2MPG11_PMIC_GPIO_CTRL6,
	S2MPG11_PMIC_GPIO_CTRL7,
	S2MPG11_PMIC_B2S_OCP_WARN,
	S2MPG11_PMIC_B2S_OCP_WARN_X,
	S2MPG11_PMIC_B2S_OCP_WARN_Y,
	S2MPG11_PMIC_B2S_OCP_WARN_Z,
	S2MPG11_PMIC_B2S_SOFT_OCP_WARN,
	S2MPG11_PMIC_B2S_SOFT_OCP_WARN_X,
	S2MPG11_PMIC_B2S_SOFT_OCP_WARN_Y,
	S2MPG11_PMIC_B2S_SOFT_OCP_WARN_Z,
	S2MPG11_PMIC_BUCK_OCP_EN1,
	S2MPG11_PMIC_BUCK_OCP_EN2,
	S2MPG11_PMIC_BUCK_OCP_PD_EN1,
	S2MPG11_PMIC_BUCK_OCP_PD_EN2,
	S2MPG11_PMIC_BUCK_OCP_CTRL1,
	S2MPG11_PMIC_BUCK_OCP_CTRL2,
	S2MPG11_PMIC_BUCK_OCP_CTRL3,
	S2MPG11_PMIC_BUCK_OCP_CTRL4,
	S2MPG11_PMIC_BUCK_OCP_CTRL5,
	S2MPG11_PMIC_BUCK_OCP_CTRL6,
	S2MPG11_PMIC_BUCK_OCP_CTRL7,
	S2MPG11_PMIC_PIF_CTRL,
	S2MPG11_PMIC_BUCK_HR_MODE1,
	S2MPG11_PMIC_BUCK_HR_MODE2,
	S2MPG11_PMIC_FAULTOUT_CTRL,
	S2MPG11_PMIC_LDO_SENSE1,
	S2MPG11_PMIC_LDO_SENSE2,
};

/* For S2MPG11_PMIC_PCTRLSELx */
#define S2MPG11_PCTRLSEL_PWREN           0x1 /* PWREN pin */
#define S2MPG11_PCTRLSEL_PWREN_TRG       0x2 /* PWREN_TRG bit in MIMICKING_CTRL */
#define S2MPG11_PCTRLSEL_PWREN_MIF       0x3 /* PWREN_MIF pin */
#define S2MPG11_PCTRLSEL_PWREN_MIF_TRG   0x4 /* PWREN_MIF_TRG bit in MIMICKING_CTRL */
#define S2MPG11_PCTRLSEL_AP_ACTIVE_N     0x5 /* ~AP_ACTIVE_N pin */
#define S2MPG11_PCTRLSEL_AP_ACTIVE_N_TRG 0x6 /* ~AP_ACTIVE_N_TRG bit in MIMICKING_CTRL */
#define S2MPG11_PCTRLSEL_G3D_EN          0x7 /* G3D_EN pin */
#define S2MPG11_PCTRLSEL_G3D_EN2         0x8 /* G3D_EN & ~AP_ACTIVE_N pins */
#define S2MPG11_PCTRLSEL_AOC_VDD         0x9 /* AOC_VDD pin */
#define S2MPG11_PCTRLSEL_AOC_RET         0xa /* AOC_RET pin */
#define S2MPG11_PCTRLSEL_UFS_EN          0xb /* UFS_EN pin */
#define S2MPG11_PCTRLSEL_LDO13S_EN       0xc /* VLDO13S_EN pin */

/* Meter registers (type 0xa00) */
enum s2mpg11_meter_reg {
	S2MPG11_METER_CTRL1,
	S2MPG11_METER_CTRL2,
	S2MPG11_METER_CTRL3,
	S2MPG11_METER_CTRL4,
	S2MPG11_METER_CTRL5,
	S2MPG11_METER_BUCKEN1,
	S2MPG11_METER_BUCKEN2,
	S2MPG11_METER_MUXSEL0,
	S2MPG11_METER_MUXSEL1,
	S2MPG11_METER_MUXSEL2,
	S2MPG11_METER_MUXSEL3,
	S2MPG11_METER_MUXSEL4,
	S2MPG11_METER_MUXSEL5,
	S2MPG11_METER_MUXSEL6,
	S2MPG11_METER_MUXSEL7,
	S2MPG11_METER_LPF_C0_0,
	S2MPG11_METER_LPF_C0_1,
	S2MPG11_METER_LPF_C0_2,
	S2MPG11_METER_LPF_C0_3,
	S2MPG11_METER_LPF_C0_4,
	S2MPG11_METER_LPF_C0_5,
	S2MPG11_METER_LPF_C0_6,
	S2MPG11_METER_LPF_C0_7,
	S2MPG11_METER_NTC_LPF_C0_0,
	S2MPG11_METER_NTC_LPF_C0_1,
	S2MPG11_METER_NTC_LPF_C0_2,
	S2MPG11_METER_NTC_LPF_C0_3,
	S2MPG11_METER_NTC_LPF_C0_4,
	S2MPG11_METER_NTC_LPF_C0_5,
	S2MPG11_METER_NTC_LPF_C0_6,
	S2MPG11_METER_NTC_LPF_C0_7,
	S2MPG11_METER_PWR_WARN0,
	S2MPG11_METER_PWR_WARN1,
	S2MPG11_METER_PWR_WARN2,
	S2MPG11_METER_PWR_WARN3,
	S2MPG11_METER_PWR_WARN4,
	S2MPG11_METER_PWR_WARN5,
	S2MPG11_METER_PWR_WARN6,
	S2MPG11_METER_PWR_WARN7,
	S2MPG11_METER_NTC_L_WARN0,
	S2MPG11_METER_NTC_L_WARN1,
	S2MPG11_METER_NTC_L_WARN2,
	S2MPG11_METER_NTC_L_WARN3,
	S2MPG11_METER_NTC_L_WARN4,
	S2MPG11_METER_NTC_L_WARN5,
	S2MPG11_METER_NTC_L_WARN6,
	S2MPG11_METER_NTC_L_WARN7,
	S2MPG11_METER_NTC_H_WARN0,
	S2MPG11_METER_NTC_H_WARN1,
	S2MPG11_METER_NTC_H_WARN2,
	S2MPG11_METER_NTC_H_WARN3,
	S2MPG11_METER_NTC_H_WARN4,
	S2MPG11_METER_NTC_H_WARN5,
	S2MPG11_METER_NTC_H_WARN6,
	S2MPG11_METER_NTC_H_WARN7,
	S2MPG11_METER_PWR_HYS1,
	S2MPG11_METER_PWR_HYS2,
	S2MPG11_METER_PWR_HYS3,
	S2MPG11_METER_PWR_HYS4,
	S2MPG11_METER_NTC_HYS1,
	S2MPG11_METER_NTC_HYS2,
	S2MPG11_METER_NTC_HYS3,
	S2MPG11_METER_NTC_HYS4,
	/* Nothing @ 0x3f */
	S2MPG11_METER_ACC_DATA_CH0_1 = 0x40,
	S2MPG11_METER_ACC_DATA_CH0_2,
	S2MPG11_METER_ACC_DATA_CH0_3,
	S2MPG11_METER_ACC_DATA_CH0_4,
	S2MPG11_METER_ACC_DATA_CH0_5,
	S2MPG11_METER_ACC_DATA_CH0_6,
	S2MPG11_METER_ACC_DATA_CH1_1,
	S2MPG11_METER_ACC_DATA_CH1_2,
	S2MPG11_METER_ACC_DATA_CH1_3,
	S2MPG11_METER_ACC_DATA_CH1_4,
	S2MPG11_METER_ACC_DATA_CH1_5,
	S2MPG11_METER_ACC_DATA_CH1_6,
	S2MPG11_METER_ACC_DATA_CH2_1,
	S2MPG11_METER_ACC_DATA_CH2_2,
	S2MPG11_METER_ACC_DATA_CH2_3,
	S2MPG11_METER_ACC_DATA_CH2_4,
	S2MPG11_METER_ACC_DATA_CH2_5,
	S2MPG11_METER_ACC_DATA_CH2_6,
	S2MPG11_METER_ACC_DATA_CH3_1,
	S2MPG11_METER_ACC_DATA_CH3_2,
	S2MPG11_METER_ACC_DATA_CH3_3,
	S2MPG11_METER_ACC_DATA_CH3_4,
	S2MPG11_METER_ACC_DATA_CH3_5,
	S2MPG11_METER_ACC_DATA_CH3_6,
	S2MPG11_METER_ACC_DATA_CH4_1,
	S2MPG11_METER_ACC_DATA_CH4_2,
	S2MPG11_METER_ACC_DATA_CH4_3,
	S2MPG11_METER_ACC_DATA_CH4_4,
	S2MPG11_METER_ACC_DATA_CH4_5,
	S2MPG11_METER_ACC_DATA_CH4_6,
	S2MPG11_METER_ACC_DATA_CH5_1,
	S2MPG11_METER_ACC_DATA_CH5_2,
	S2MPG11_METER_ACC_DATA_CH5_3,
	S2MPG11_METER_ACC_DATA_CH5_4,
	S2MPG11_METER_ACC_DATA_CH5_5,
	S2MPG11_METER_ACC_DATA_CH5_6,
	S2MPG11_METER_ACC_DATA_CH6_1,
	S2MPG11_METER_ACC_DATA_CH6_2,
	S2MPG11_METER_ACC_DATA_CH6_3,
	S2MPG11_METER_ACC_DATA_CH6_4,
	S2MPG11_METER_ACC_DATA_CH6_5,
	S2MPG11_METER_ACC_DATA_CH6_6,
	S2MPG11_METER_ACC_DATA_CH7_1,
	S2MPG11_METER_ACC_DATA_CH7_2,
	S2MPG11_METER_ACC_DATA_CH7_3,
	S2MPG11_METER_ACC_DATA_CH7_4,
	S2MPG11_METER_ACC_DATA_CH7_5,
	S2MPG11_METER_ACC_DATA_CH7_6,
	S2MPG11_METER_ACC_COUNT_1,
	S2MPG11_METER_ACC_COUNT_2,
	S2MPG11_METER_ACC_COUNT_3,
	S2MPG11_METER_LPF_DATA_CH0_1,
	S2MPG11_METER_LPF_DATA_CH0_2,
	S2MPG11_METER_LPF_DATA_CH0_3,
	S2MPG11_METER_LPF_DATA_CH1_1,
	S2MPG11_METER_LPF_DATA_CH1_2,
	S2MPG11_METER_LPF_DATA_CH1_3,
	S2MPG11_METER_LPF_DATA_CH2_1,
	S2MPG11_METER_LPF_DATA_CH2_2,
	S2MPG11_METER_LPF_DATA_CH2_3,
	S2MPG11_METER_LPF_DATA_CH3_1,
	S2MPG11_METER_LPF_DATA_CH3_2,
	S2MPG11_METER_LPF_DATA_CH3_3,
	S2MPG11_METER_LPF_DATA_CH4_1,
	S2MPG11_METER_LPF_DATA_CH4_2,
	S2MPG11_METER_LPF_DATA_CH4_3,
	S2MPG11_METER_LPF_DATA_CH5_1,
	S2MPG11_METER_LPF_DATA_CH5_2,
	S2MPG11_METER_LPF_DATA_CH5_3,
	S2MPG11_METER_LPF_DATA_CH6_1,
	S2MPG11_METER_LPF_DATA_CH6_2,
	S2MPG11_METER_LPF_DATA_CH6_3,
	S2MPG11_METER_LPF_DATA_CH7_1,
	S2MPG11_METER_LPF_DATA_CH7_2,
	S2MPG11_METER_LPF_DATA_CH7_3,
	/* Nothing @ 0x8b 0x8c */
	S2MPG11_METER_LPF_DATA_NTC0_1 = 0x8d,
	S2MPG11_METER_LPF_DATA_NTC0_2,
	S2MPG11_METER_LPF_DATA_NTC1_1,
	S2MPG11_METER_LPF_DATA_NTC1_2,
	S2MPG11_METER_LPF_DATA_NTC2_1,
	S2MPG11_METER_LPF_DATA_NTC2_2,
	S2MPG11_METER_LPF_DATA_NTC3_1,
	S2MPG11_METER_LPF_DATA_NTC3_2,
	S2MPG11_METER_LPF_DATA_NTC4_1,
	S2MPG11_METER_LPF_DATA_NTC4_2,
	S2MPG11_METER_LPF_DATA_NTC5_1,
	S2MPG11_METER_LPF_DATA_NTC5_2,
	S2MPG11_METER_LPF_DATA_NTC6_1,
	S2MPG11_METER_LPF_DATA_NTC6_2,
	S2MPG11_METER_LPF_DATA_NTC7_1,
	S2MPG11_METER_LPF_DATA_NTC7_2,
};

/* S2MPG11 regulator IDs */
enum s2mpg11_regulators {
	S2MPG11_BUCKBOOST,
	S2MPG11_BUCK1,
	S2MPG11_BUCK2,
	S2MPG11_BUCK3,
	S2MPG11_BUCK4,
	S2MPG11_BUCK5,
	S2MPG11_BUCK6,
	S2MPG11_BUCK7,
	S2MPG11_BUCK8,
	S2MPG11_BUCK9,
	S2MPG11_BUCK10,
	S2MPG11_BUCKD,
	S2MPG11_BUCKA,
	S2MPG11_LDO1,
	S2MPG11_LDO2,
	S2MPG11_LDO3,
	S2MPG11_LDO4,
	S2MPG11_LDO5,
	S2MPG11_LDO6,
	S2MPG11_LDO7,
	S2MPG11_LDO8,
	S2MPG11_LDO9,
	S2MPG11_LDO10,
	S2MPG11_LDO11,
	S2MPG11_LDO12,
	S2MPG11_LDO13,
	S2MPG11_LDO14,
	S2MPG11_LDO15,
	S2MPG11_REGULATOR_MAX,
};

#endif /* __LINUX_MFD_S2MPG11_H */
