# (c) Copyright 2013-2014. CodeWeavers, Inc.

import htmltextview
import cxutils
import cxlog

class CXHtmlTextView(htmltextview.HtmlTextView):
    __gtype_name__ = 'CXHtmlTextView'

    def __init__(self):
        htmltextview.HtmlTextView.__init__(self)

    def do_url_clicked(self, url, _type):
        cxutils.launch_url(url)

    def display_html_safe(self, html):
        self.get_buffer().set_text("")
        try:
            self.display_html(html)
        except Exception as exception: # pylint: disable=W0703
            cxlog.warn("unable to display the HTML snippet below: %s\n\n%s" % (exception, cxlog.debug_str(html)))
            self.get_buffer().set_text(cxutils.html_to_text(html))
