import { Node } from 'estree';
import { walk } from 'estree-walker';
import { TemplateNode } from 'svelte/types/compiler/interfaces';
export interface SvelteNode {
    start: number;
    end: number;
    type: string;
    parent?: SvelteNode;
    [key: string]: any;
}
export interface AwaitBlock extends SvelteNode {
    type: 'AwaitBlock';
    expression: SvelteNode & Node;
    value: (SvelteNode & Node) | null;
    error: (SvelteNode & Node) | null;
    pending: AwaitSubBlock;
    then: AwaitSubBlock;
    catch: AwaitSubBlock;
}
export interface AwaitSubBlock extends SvelteNode {
    skip: boolean;
    children: SvelteNode[];
}
export interface EachBlock extends SvelteNode {
    type: 'EachBlock';
    expression: SvelteNode & Node;
    context: SvelteNode & Node;
    key?: SvelteNode & Node;
    else?: SvelteNode;
    children: SvelteNode[];
}
/**
 * Returns true if given node is a component or html element, or if the offset is at the end of the node
 * and its parent is a component or html element.
 */
export declare function isInTag(node: SvelteNode | null | undefined, offset: number): boolean;
/**
 * Returns when given node represents an HTML Attribute.
 * Example: The `class` in `<div class=".."`.
 * Note: This method returns `false` for shorthands like `<div {foo}`.
 */
export declare function isAttributeName(node: SvelteNode | null | undefined, only?: 'Element' | 'InlineComponent'): boolean;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `{foo}` in `<div {foo}`
 */
export declare function isAttributeShorthand(node: SvelteNode | null | undefined, only?: 'Element' | 'InlineComponent'): boolean;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `on:click={foo}` in `<div on:click={foo}`
 */
export declare function isEventHandler(node: SvelteNode | null | undefined, only?: 'Element' | 'InlineComponent'): boolean;
export declare function isElseBlockWithElseIf(node: SvelteNode | null | undefined): boolean;
export declare function hasElseBlock(node: SvelteNode): node is SvelteNode & {
    else: SvelteNode;
};
export declare function findElseBlockTagStart(documentText: string, elseBlock: SvelteNode): number;
export declare function findIfBlockEndTagStart(documentText: string, ifBlock: SvelteNode): number;
type ESTreeWaker = Parameters<typeof walk>[1];
type ESTreeEnterFunc = NonNullable<ESTreeWaker['enter']>;
type ESTreeLeaveFunc = NonNullable<ESTreeWaker['leave']>;
export interface SvelteNodeWalker {
    enter?: (this: {
        skip: () => void;
        remove: () => void;
        replace: (node: SvelteNode) => void;
    }, node: SvelteNode, parent: SvelteNode, key: Parameters<ESTreeEnterFunc>[2], index: Parameters<ESTreeEnterFunc>[3]) => void;
    leave?: (this: {
        skip: () => void;
        remove: () => void;
        replace: (node: SvelteNode) => void;
    }, node: SvelteNode, parent: SvelteNode, key: Parameters<ESTreeLeaveFunc>[2], index: Parameters<ESTreeLeaveFunc>[3]) => void;
}
export declare function walkSvelteAst(htmlAst: TemplateNode, walker: SvelteNodeWalker): void;
export declare function isAwaitBlock(node: SvelteNode): node is AwaitBlock;
export declare function isEachBlock(node: SvelteNode): node is EachBlock;
export {};
