export declare class Constants {
    /**
     * 🐙 CALAMARES: La directory di configurazione dell'installer GUI
     */
    static readonly CALAMARES_DIR = "etc/calamares";
    /**
     * ⚙️ CONFIG_DIR: La cartella principale di configurazione
     * Solitamente: /etc/penguins-eggs.d
     */
    static readonly CONFIG_DIR = "/etc/penguins-eggs.d";
    /**
     * 🚫 EXCLUDE LISTS DIRECTORY
     * Dove si trovano i partials (homes.list, var.list, etc)
     */
    static readonly EXCLUDES_DIR: string;
    /**
     * 📄 FILE DI CONFIGURAZIONE
     */
    static readonly FILES: {
        DERIVATIVES: string;
        EXCLUDE_LIST: string;
        KRILL: string;
        MAIN: string;
    };
    /**
     * 📜 LOG_DIR: Dove scriviamo i log
     */
    static readonly LOG_DIR = "/var/log/penguins-eggs";
    /**
     * 🏠 NEST: Il nido dove avviene la magia (Work Directory)
     * Solitamente: /home/eggs
     */
    static readonly NEST = "/home/eggs";
    /**
     * Helper per ottenere il path completo di una lista di esclusione specifica
     */
    static getExcludePath(filename: string): string;
}
