/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http3.Http3ClientConnectionHandler;
import org.jspecify.annotations.Nullable;
import reactor.netty.Connection;
import reactor.netty.http.client.Http2Pool;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;

final class Http3Pool
extends Http2Pool {
    Http3Pool(PoolConfig<Connection> poolConfig, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ConnectionProvider.AllocationStrategy<?> allocationStrategy) {
        super(poolConfig, allocationStrategy);
    }

    @Override
    void closeChannel(Channel channel) {
        channel.close();
        channel.parent().close();
    }

    @Override
    Slot createSlot(Connection connection) {
        return new Slot(this, connection);
    }

    @Override
    void destroyPoolableInternal(Http2Pool.Http2PooledRef ref) {
        if (this.poolConfig.evictInBackgroundInterval().isZero()) {
            if (!ref.poolable().channel().isActive()) {
                ref.slot.invalidate();
                this.removeSlot(ref.slot);
            } else if (ref.slot.goAwayReceived()) {
                ref.slot.invalidate();
                this.removeSlot(ref.slot);
            } else if (this.testEvictionPredicate(ref.slot)) {
                this.closeChannel(ref.slot.connection.channel());
                ref.slot.invalidate();
                this.removeSlot(ref.slot);
            }
        }
    }

    static final class Slot
    extends Http2Pool.Slot {
        volatile @Nullable ChannelHandlerContext http3ClientConnectionHandlerCtx;

        Slot(Http2Pool pool, Connection connection) {
            super(pool, connection);
        }

        @Override
        void initMaxConcurrentStreams() {
            this.maxConcurrentStreams = this.pool.maxConcurrentStreams;
        }

        @Override
        boolean canOpenStream() {
            return true;
        }

        @Override
        boolean goAwayReceived() {
            ChannelHandlerContext connectionHandlerCtx = this.http3ClientConnectionHandlerCtx();
            return connectionHandlerCtx != null && ((Http3ClientConnectionHandler)connectionHandlerCtx.handler()).isGoAwayReceived();
        }

        @Nullable ChannelHandlerContext http3ClientConnectionHandlerCtx() {
            ChannelHandlerContext ctx = this.http3ClientConnectionHandlerCtx;
            if (ctx != null && this.connection.channel().eventLoop().inEventLoop() && !ctx.isRemoved()) {
                return ctx;
            }
            this.http3ClientConnectionHandlerCtx = ctx = this.connection.channel().pipeline().context(Http3ClientConnectionHandler.class);
            return ctx;
        }
    }
}

