# -*- coding:binary -*-

require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::HTTP::Nifi::Processor do
  subject do
    mod = ::Msf::Module.new
    mod.extend described_class
    mod
  end

  let(:valid_code) do
    200
  end

  describe '#nifi Processor start_processor' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.start_processor('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = ''
        res
      end

      expect { subject.start_processor('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'returns nil when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = ''
        res
      end

      expect(subject.start_processor('a', 'a')).to be_nil
    end
  end

  describe '#nifi Processor stop_processor' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.stop_processor('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = ''
        res
      end

      expect { subject.stop_processor('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'returns nil when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = ''
        res
      end

      expect(subject.stop_processor('a', 'a')).to be_nil
    end
  end

  describe '#nifi Processor create_processor' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.create_processor('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = ''
        res
      end

      expect { subject.create_processor('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'returns UUID when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 201
        res.body = '{"id":"628de124-3d0f-11ee-be56-0242ac120002"}'
        res
      end

      expect(subject.create_processor('a', 'a')).to eq('628de124-3d0f-11ee-be56-0242ac120002')
    end
  end

  describe '#nifi Processor get_processor_field' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.get_processor_field('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = ''
        res
      end

      expect { subject.get_processor_field('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Processor::ProcessorError)
    end

    it 'returns UUID when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 200
        res.body = '{"id":"628de124-3d0f-11ee-be56-0242ac120002"}'
        res
      end

      expect(subject.get_processor_field('a', 'a')).to eq('628de124-3d0f-11ee-be56-0242ac120002')
    end
  end
end
