/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.broker.saml.SAMLDataMarshaller;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.common.util.StackUtil;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.protocol.saml.ArtifactResolver;
import org.keycloak.protocol.saml.ArtifactResolverProcessingException;
import org.keycloak.protocol.saml.IDPMetadataDescriptor;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.protocol.saml.profile.ecp.SamlEcpProfileService;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.protocol.saml.util.ArtifactBindingUtils;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAML2NameIDBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLRequestWriter;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.keycloak.saml.validators.DestinationValidator;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.SamlAuthnRequestContext;
import org.keycloak.services.clientpolicy.context.SamlLogoutRequestContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.transaction.AsyncResponseTransaction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SamlService
extends AuthorizationEndpointBase {
    protected static final Logger logger = Logger.getLogger(SamlService.class);
    public static final String ARTIFACT_RESOLUTION_SERVICE_PATH = "resolve";
    private final DestinationValidator destinationValidator;

    public SamlService(KeycloakSession session, EventBuilder event, DestinationValidator destinationValidator) {
        super(session, event);
        this.destinationValidator = destinationValidator;
    }

    protected Response newBrowserAuthentication(AuthenticationSessionModel authSession, boolean isPassive, boolean redirectToAuthentication) {
        SamlProtocol samlProtocol = new SamlProtocol().setEventBuilder(this.event).setHttpHeaders(this.headers).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri());
        return this.newBrowserAuthentication(authSession, isPassive, redirectToAuthentication, samlProtocol);
    }

    protected Response newBrowserAuthentication(AuthenticationSessionModel authSession, boolean isPassive, boolean redirectToAuthentication, SamlProtocol samlProtocol) {
        return this.handleBrowserAuthenticationRequest(authSession, samlProtocol, isPassive, redirectToAuthentication);
    }

    public RedirectBindingProtocol newRedirectBindingProtocol() {
        return new RedirectBindingProtocol();
    }

    public PostBindingProtocol newPostBindingProtocol() {
        return new PostBindingProtocol();
    }

    @GET
    public void redirectBinding(@Suspended AsyncResponse asyncResponse, @QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState, @QueryParam(value="SAMLart") String artifact) {
        logger.debug((Object)"SAML GET");
        CacheControlUtil.noBackButtonCacheControlHeader(this.session);
        new RedirectBindingProtocol().execute(asyncResponse, samlRequest, samlResponse, relayState, artifact);
    }

    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void postBinding(@Suspended AsyncResponse asyncResponse, @FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState, @FormParam(value="SAMLart") String artifact) {
        logger.debug((Object)"SAML POST");
        PostBindingProtocol postBindingProtocol = new PostBindingProtocol();
        postBindingProtocol.redirectToAuthentication = true;
        postBindingProtocol.execute(asyncResponse, samlRequest, samlResponse, relayState, artifact);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    @NoCache
    public String getDescriptor() throws Exception {
        return SamlService.getIDPMetadataDescriptor((UriInfo)this.session.getContext().getUri(), this.session, this.realm);
    }

    public static String getIDPMetadataDescriptor(UriInfo uriInfo, KeycloakSession session, RealmModel realm) {
        try {
            List keys = session.keys().getKeysStream(realm, KeyUse.SIG, "RS256").sorted(SamlService::compareKeys).collect(Collectors.toList());
            List<Element> signingKeys = keys.stream().map(key -> {
                try {
                    return IDPMetadataDescriptor.buildKeyInfoElement(key.getKid(), PemUtils.encodeCertificate((Certificate)key.getCertificate()));
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            return IDPMetadataDescriptor.getIDPDescriptor(keys.isEmpty() ? null : (KeyWrapper)keys.iterator().next(), (SignatureAlgorithm)realm.getAttribute("saml.signature.algorithm", SignatureAlgorithm.class, null), RealmsResource.protocolUrl(uriInfo).build(new Object[]{realm.getName(), "saml"}), RealmsResource.protocolUrl(uriInfo).build(new Object[]{realm.getName(), "saml"}), RealmsResource.protocolUrl(uriInfo).build(new Object[]{realm.getName(), "saml"}), RealmsResource.protocolUrl(uriInfo).path(ARTIFACT_RESOLUTION_SERVICE_PATH).build(new Object[]{realm.getName(), "saml"}), RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString(), true, signingKeys, realm.getAttribute("saml.descriptor.cache.seconds", (Long)null));
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot generate IdP metadata", (Throwable)ex);
            return "";
        }
    }

    public static int compareKeys(KeyWrapper o1, KeyWrapper o2) {
        return o1.getStatus() == o2.getStatus() ? (int)(o2.getProviderPriority() - o1.getProviderPriority()) : (o1.getStatus() == KeyStatus.PASSIVE ? 1 : -1);
    }

    private boolean isClientProtocolCorrect(ClientModel clientModel) {
        return "saml".equals(clientModel.getProtocol());
    }

    @GET
    @Path(value="clients/{client}")
    @Produces(value={"text/html; charset=utf-8"})
    public Response idpInitiatedSSO(@PathParam(value="client") String clientUrlName, @QueryParam(value="RelayState") String relayState) {
        this.event.event(EventType.LOGIN);
        CacheControlUtil.noBackButtonCacheControlHeader(this.session);
        ClientModel client = this.session.clients().searchClientsByAttributes(this.realm, Collections.singletonMap("saml_idp_initiated_sso_url_name", clientUrlName), Integer.valueOf(0), Integer.valueOf(1)).findFirst().orElse(null);
        if (client == null) {
            this.event.error("client_not_found");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
        }
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "clientDisabledMessage", new Object[0]);
        }
        if (!this.isClientProtocolCorrect(client)) {
            this.event.error("invalid_client");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "Wrong client protocol.", new Object[0]);
        }
        this.session.getContext().setClient(client);
        AuthenticationSessionModel authSession = this.getOrCreateLoginSessionForIdpInitiatedSso(this.session, this.realm, client, relayState);
        if (authSession == null) {
            logger.error((Object)"SAML assertion consumer url not set up");
            this.event.error("invalid_redirect_uri");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidRedirectUriMessage", new Object[0]);
        }
        return this.newBrowserAuthentication(authSession, false, false);
    }

    private String[] getUrlAndBindingForIdpInitiatedSso(ClientModel client) {
        String postUrl = client.getAttribute("saml_assertion_consumer_url_post");
        String getUrl = client.getAttribute("saml_assertion_consumer_url_redirect");
        if (postUrl != null && !postUrl.trim().isEmpty()) {
            return new String[]{postUrl.trim(), "post"};
        }
        if (client.getManagementUrl() != null && !client.getManagementUrl().trim().isEmpty()) {
            return new String[]{client.getManagementUrl().trim(), "post"};
        }
        if (getUrl != null && !getUrl.trim().isEmpty()) {
            return new String[]{getUrl.trim(), "get"};
        }
        return null;
    }

    public AuthenticationSessionModel getOrCreateLoginSessionForIdpInitiatedSso(KeycloakSession session, RealmModel realm, ClientModel client, String relayState) {
        String[] bindingProperties = this.getUrlAndBindingForIdpInitiatedSso(client);
        if (bindingProperties == null) {
            return null;
        }
        String redirect = bindingProperties[0];
        String bindingType = bindingProperties[1];
        AuthenticationSessionModel authSession = this.createAuthenticationSession(client, null);
        authSession.setProtocol("saml");
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setClientNote("saml_binding", bindingType);
        authSession.setClientNote("saml_idp_initiated_login", "true");
        authSession.setRedirectUri(redirect);
        if (relayState == null) {
            relayState = client.getAttribute("saml_idp_initiated_sso_relay_state");
        }
        if (relayState != null && !relayState.trim().equals("")) {
            authSession.setClientNote("RelayState", relayState);
        }
        return authSession;
    }

    @POST
    @Path(value="resolve")
    @NoCache
    @Consumes(value={"application/soap+xml", "text/xml"})
    public Response artifactResolutionService(InputStream inputStream) {
        Document soapBodyContents = Soap.extractSoapMessage(inputStream);
        ArtifactResolveType artifactResolveType = null;
        SAMLDocumentHolder samlDocumentHolder = null;
        try {
            samlDocumentHolder = SAML2Request.getSAML2ObjectFromDocument((Document)soapBodyContents);
            if (samlDocumentHolder.getSamlObject() instanceof ArtifactResolveType) {
                logger.debug((Object)"Received artifact resolve message");
                artifactResolveType = (ArtifactResolveType)samlDocumentHolder.getSamlObject();
            }
        }
        catch (Exception e) {
            logger.errorf("Artifact resolution endpoint obtained request that contained no ArtifactResolve message: %s", (Object)DocumentUtil.asString((Document)soapBodyContents));
            return Soap.createFault().reason("").detail("").build();
        }
        if (artifactResolveType == null) {
            logger.errorf("Artifact resolution endpoint obtained request that contained no ArtifactResolve message: %s", (Object)DocumentUtil.asString((Document)soapBodyContents));
            return Soap.createFault().reason("").detail("").build();
        }
        try {
            return this.artifactResolve(artifactResolveType, samlDocumentHolder);
        }
        catch (Exception e) {
            try {
                return this.emptyArtifactResponseMessage(artifactResolveType, null, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.getUri());
            }
            catch (ConfigurationException | ProcessingException configurationException) {
                String reason = "An error occurred while trying to return the artifactResponse";
                String detail = e.getMessage();
                if (detail == null) {
                    detail = "";
                }
                logger.errorf("Failure during ArtifactResolve reason: %s, detail: %s", (Object)reason, (Object)detail);
                return Soap.createFault().reason(reason).detail(detail).build();
            }
        }
    }

    @POST
    @NoCache
    @Consumes(value={"application/soap+xml", "text/xml"})
    public Response soapBinding(InputStream inputStream) {
        SamlEcpProfileService bindingService = new SamlEcpProfileService(this.session, this.event, this.destinationValidator);
        return bindingService.authenticate(inputStream);
    }

    private ClientModel getAndCheckClientModel(String clientSessionId, String clientId) throws ProcessingException {
        ClientModel client = this.session.clients().getClientById(this.realm, clientSessionId);
        if (client == null) {
            throw new ProcessingException("client_not_found");
        }
        if (!client.isEnabled()) {
            throw new ProcessingException("client_disabled");
        }
        if (client.isBearerOnly()) {
            throw new ProcessingException("not_allowed");
        }
        if (!client.isStandardFlowEnabled()) {
            throw new ProcessingException("not_allowed");
        }
        if (!client.getClientId().equals(clientId)) {
            logger.errorf("Resolve message with wrong issuer. Artifact was issued for client %s, however ArtifactResolveMessage came from client %s.", (Object)client.getClientId(), (Object)clientId);
            throw new ProcessingException("invalid_artifact");
        }
        return client;
    }

    private SingleUseObjectProvider getSingleUseStore() {
        return this.session.singleUseObjects();
    }

    public Response artifactResolve(ArtifactResolveType artifactResolveMessage, SAMLDocumentHolder artifactResolveHolder) throws ParsingException, ConfigurationException, ProcessingException {
        String artifactResponseString;
        logger.debugf("Received artifactResolve message for artifact %s\nMessage: \n%s", (Object)artifactResolveMessage.getArtifact(), (Object)DocumentUtil.getDocumentAsString((Document)artifactResolveHolder.getSamlDocument()));
        String artifact = artifactResolveMessage.getArtifact();
        if (artifact == null) {
            logger.errorf("Artifact to resolve was null", new Object[0]);
            return this.emptyArtifactResponseMessage(artifactResolveMessage, null, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.getUri());
        }
        ArtifactResolver artifactResolver = this.getArtifactResolver(artifact);
        if (artifactResolver == null) {
            logger.errorf("Cannot find ArtifactResolver for artifact %s", (Object)artifact);
            return this.emptyArtifactResponseMessage(artifactResolveMessage, null, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.getUri());
        }
        Map sessionMapping = this.getSingleUseStore().get(artifact);
        if (sessionMapping == null) {
            logger.errorf("No data stored for artifact %s", (Object)artifact);
            return this.emptyArtifactResponseMessage(artifactResolveMessage, null);
        }
        UserSessionModel userSessionModel = this.session.sessions().getUserSession(this.realm, (String)sessionMapping.get("userSessionId"));
        if (userSessionModel == null) {
            logger.errorf("UserSession with id: %s, that corresponds to artifact: %s does not exist.", sessionMapping.get("userSessionId"), (Object)artifact);
            return this.emptyArtifactResponseMessage(artifactResolveMessage, null);
        }
        AuthenticatedClientSessionModel clientSessionModel = userSessionModel.getAuthenticatedClientSessionByClient((String)sessionMapping.get("clientSessionId"));
        if (clientSessionModel == null) {
            logger.errorf("ClientSession with id: %s, that corresponds to artifact: %s and UserSession: %s does not exist.", sessionMapping.get("clientSessionId"), (Object)artifact, sessionMapping.get("userSessionId"));
            return this.emptyArtifactResponseMessage(artifactResolveMessage, null);
        }
        ClientModel clientModel = this.getAndCheckClientModel((String)sessionMapping.get("clientSessionId"), artifactResolveMessage.getIssuer().getValue());
        SamlClient samlClient = new SamlClient(clientModel);
        if (samlClient.requiresClientSignature()) {
            try {
                SamlProtocolUtils.verifyDocumentSignature(this.session, clientModel, artifactResolveHolder.getSamlDocument());
            }
            catch (VerificationException e) {
                logger.error((Object)"request validation failed", (Throwable)e);
                return this.emptyArtifactResponseMessage(artifactResolveMessage, clientModel);
            }
        }
        try {
            artifactResponseString = artifactResolver.resolveArtifact(clientSessionModel, artifact);
        }
        catch (ArtifactResolverProcessingException e) {
            logger.errorf((Throwable)e, "Failed to resolve artifact: %s.", (Object)artifact);
            return this.emptyArtifactResponseMessage(artifactResolveMessage, clientModel);
        }
        if (this.getSingleUseStore().remove(artifact) == null) {
            logger.debugf("Artifact %s was already removed", (Object)artifact);
        }
        Document artifactResponseDocument = null;
        ArtifactResponseType artifactResponseType = null;
        try {
            SAMLDataMarshaller marshaller = new SAMLDataMarshaller();
            artifactResponseType = marshaller.deserialize(artifactResponseString, ArtifactResponseType.class);
            artifactResponseDocument = SamlProtocolUtils.convert(artifactResponseType);
        }
        catch (ConfigurationException | ParsingException | ProcessingException e) {
            logger.errorf(e, "Failed to obtain document from ArtifactResponseString: %s.", (Object)artifactResponseString);
            return this.emptyArtifactResponseMessage(artifactResolveMessage, clientModel);
        }
        if (CommonClientSessionModel.Action.LOGGING_OUT.name().equals(clientSessionModel.getAction())) {
            clientSessionModel.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
            if (artifactResponseType.getAny() instanceof StatusResponseType && artifactResponseString.contains(JBossSAMLConstants.LOGOUT_RESPONSE.get())) {
                if (!UserSessionModel.State.LOGGED_OUT_UNCONFIRMED.equals((Object)userSessionModel.getState())) {
                    logger.warnf("Keycloak issued LogoutResponse for clientSession %s, however user session %s was not in LOGGED_OUT_UNCONFIRMED state.", (Object)clientSessionModel.getId(), (Object)userSessionModel.getId());
                }
                AuthenticationManager.finishUnconfirmedUserSession(this.session, this.realm, userSessionModel);
            }
        }
        return this.artifactResponseMessage(artifactResolveMessage, artifactResponseDocument, clientModel);
    }

    private Response emptyArtifactResponseMessage(ArtifactResolveType artifactResolveMessage, ClientModel clientModel) throws ProcessingException, ConfigurationException {
        return this.emptyArtifactResponseMessage(artifactResolveMessage, clientModel, JBossSAMLURIConstants.STATUS_SUCCESS.getUri());
    }

    private Response emptyArtifactResponseMessage(ArtifactResolveType artifactResolveMessage, ClientModel clientModel, URI responseStatusCode) throws ProcessingException, ConfigurationException {
        Document artifactResponseDocument;
        ArtifactResponseType artifactResponse = SamlProtocolUtils.buildArtifactResponse(null, SAML2NameIDBuilder.value((String)RealmsResource.realmBaseUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString()).build(), responseStatusCode);
        try {
            artifactResponseDocument = SamlProtocolUtils.convert(artifactResponse);
        }
        catch (ConfigurationException | ParsingException | ProcessingException e) {
            logger.errorf("Failed to obtain document from ArtifactResponse: %s.", (Object)artifactResponse);
            throw new ProcessingException("invalid_artifact_response", e);
        }
        return this.artifactResponseMessage(artifactResolveMessage, artifactResponseDocument, clientModel);
    }

    private Response artifactResponseMessage(ArtifactResolveType artifactResolveMessage, Document artifactResponseDocument, ClientModel clientModel) throws ProcessingException, ConfigurationException {
        if (artifactResolveMessage.getID() != null && !artifactResolveMessage.getID().trim().isEmpty()) {
            Element artifactResponseElement = artifactResponseDocument.getDocumentElement();
            artifactResponseElement.setAttribute("InResponseTo", artifactResolveMessage.getID());
        }
        JaxrsSAML2BindingBuilder bindingBuilder = new JaxrsSAML2BindingBuilder(this.session);
        if (clientModel != null) {
            SamlClient samlClient = new SamlClient(clientModel);
            if (samlClient.requiresRealmSignature() || samlClient.requiresAssertionSignature()) {
                KeyManager keyManager = this.session.keys();
                KeyManager.ActiveRsaKey keys = keyManager.getActiveRsaKey(this.realm);
                String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                String canonicalization = samlClient.getCanonicalizationMethod();
                if (canonicalization != null) {
                    bindingBuilder.canonicalizationMethod(canonicalization);
                }
                ((JaxrsSAML2BindingBuilder)bindingBuilder.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate());
                if (samlClient.requiresRealmSignature()) {
                    bindingBuilder.signDocument();
                }
                if (samlClient.requiresAssertionSignature()) {
                    bindingBuilder.signAssertions();
                }
            }
            if (samlClient.requiresEncryption()) {
                try {
                    SamlProtocolUtils.setupEncryption(this.session, samlClient, bindingBuilder);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to obtain encryption key for client", (Throwable)e);
                    return this.emptyArtifactResponseMessage(artifactResolveMessage, null);
                }
            }
        }
        bindingBuilder.postBinding(artifactResponseDocument);
        Soap.SoapMessageBuilder messageBuilder = Soap.createMessage();
        messageBuilder.addToBody(artifactResponseDocument);
        if (logger.isDebugEnabled()) {
            String artifactResponse = DocumentUtil.asString((Document)artifactResponseDocument);
            logger.debugf("Sending artifactResponse message for artifact %s. Message: \n %s", (Object)artifactResolveMessage.getArtifact(), (Object)artifactResponse);
        }
        return messageBuilder.build();
    }

    private Document createArtifactResolve(String issuer, String artifact) throws ProcessingException, ParsingException, ConfigurationException {
        ArtifactResolveType artifactResolve = new ArtifactResolveType(IDGenerator.create((String)"ID_"), XMLTimeUtil.getIssueInstant());
        NameIDType nameIDType = new NameIDType();
        nameIDType.setValue(issuer);
        artifactResolve.setIssuer(nameIDType);
        artifactResolve.setArtifact(artifact);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter((OutputStream)bos);
        new SAMLRequestWriter(xmlStreamWriter).write(artifactResolve);
        return DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(bos.toByteArray()));
    }

    private ArtifactResolver getArtifactResolver(String artifact) {
        ArtifactResolver artifactResolver = (ArtifactResolver)this.session.getProvider(ArtifactResolver.class, ArtifactBindingUtils.artifactToResolverProviderId((String)artifact));
        return artifactResolver != null ? artifactResolver : (ArtifactResolver)this.session.getProvider(ArtifactResolver.class);
    }

    protected class RedirectBindingProtocol
    extends BindingProtocol {
        protected RedirectBindingProtocol() {
        }

        @Override
        protected Response error(KeycloakSession session, AuthenticationSessionModel authenticationSession, Response.Status status, String message, Object ... parameters) {
            return ErrorPage.error(session, authenticationSession, status, message, parameters);
        }

        @Override
        protected String encodeSamlDocument(Document samlDocument) throws ProcessingException {
            try {
                return RedirectBindingUtil.deflateBase64Encode((byte[])DocumentUtil.asString((Document)samlDocument).getBytes(GeneralConstants.SAML_CHARSET_NAME));
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            KeyLocator clientKeyLocator = SamlProtocolUtils.createKeyLocatorForClient(SamlService.this.session, client, KeyUse.SIG);
            SamlProtocolUtils.verifyRedirectSignature(documentHolder, clientKeyLocator, (UriInfo)SamlService.this.session.getContext().getUri(), "SAMLRequest");
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            KeycloakUriInfo uriInformation = SamlService.this.session.getContext().getUri();
            MultivaluedMap encodedParams = uriInformation.getQueryParameters(false);
            String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
            return algorithm != null;
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponseRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }
    }

    protected class PostBindingProtocol
    extends BindingProtocol {
        protected PostBindingProtocol() {
        }

        @Override
        protected Response error(KeycloakSession session, AuthenticationSessionModel authenticationSession, Response.Status status, String message, Object ... parameters) {
            return ErrorPage.error(session, authenticationSession, status, message, parameters);
        }

        @Override
        protected String encodeSamlDocument(Document samlDocument) throws ProcessingException {
            try {
                return PostBindingUtil.base64Encode((String)DocumentUtil.asString((Document)samlDocument));
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            SamlProtocolUtils.verifyDocumentSignature(SamlService.this.session, client, documentHolder.getSamlDocument());
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            Document signedDoc = documentHolder.getSamlDocument();
            NodeList nl = signedDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            return nl != null && nl.getLength() > 0;
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponsePostBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }
    }

    private class ArtifactResolutionRunnable
    implements ScheduledTask {
        private final HttpRequest request;
        private final HttpResponse response;
        private AsyncResponse asyncResponse;
        private URI clientArtifactBindingURI;
        private String relayState;
        private Document doc;
        private String realmId;
        private ClientConnection connection;
        private String bindingType;

        public ArtifactResolutionRunnable(String bindingType, AsyncResponse asyncResponse, Document doc, URI clientArtifactBindingURI, String relayState) {
            this.asyncResponse = asyncResponse;
            this.doc = doc;
            this.clientArtifactBindingURI = clientArtifactBindingURI;
            this.relayState = relayState;
            this.realmId = SamlService.this.realm.getId();
            this.connection = SamlService.this.session.getContext().getConnection();
            this.bindingType = bindingType;
            this.request = SamlService.this.session.getContext().getHttpRequest();
            this.response = SamlService.this.session.getContext().getHttpResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(KeycloakSession session) {
            block27: {
                session.getContext().setHttpRequest(this.request);
                session.getContext().setHttpResponse(this.response);
                session.getContext().setConnection(this.connection);
                RealmManager realmManager = new RealmManager(session);
                RealmModel realm = realmManager.getRealm(this.realmId);
                if (realm == null) {
                    throw new NotFoundException("Realm does not exist");
                }
                session.getContext().setRealm(realm);
                EventBuilder event = new EventBuilder(realm, session, SamlService.this.clientConnection);
                HttpClientProvider httpClientProvider = (HttpClientProvider)session.getProvider(HttpClientProvider.class);
                CloseableHttpClient httpClient = httpClientProvider.getHttpClient();
                HttpPost httpPost = Soap.createMessage().addToBody(this.doc).buildHttpPost(this.clientArtifactBindingURI);
                if (logger.isTraceEnabled()) {
                    logger.tracef("Resolving artifact %s", (Object)DocumentUtil.asString((Document)this.doc));
                }
                try (CloseableHttpResponse result = httpClient.execute((HttpUriRequest)httpPost);){
                    try {
                        BindingProtocol protocol;
                        ArtifactResponseType art;
                        if (result.getStatusLine().getStatusCode() != Response.Status.OK.getStatusCode()) {
                            throw new ProcessingException(String.format("Artifact resolution failed with status: %d", result.getStatusLine().getStatusCode()));
                        }
                        Document soapBodyContents = Soap.extractSoapMessage(result.getEntity().getContent());
                        SAMLDocumentHolder samlDoc = SAML2Request.getSAML2ObjectFromDocument((Document)soapBodyContents);
                        if (!(samlDoc.getSamlObject() instanceof ArtifactResponseType)) {
                            throw new ProcessingException("Message received from ArtifactResolveService is not an ArtifactResponseMessage");
                        }
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Resolved object: %s" + DocumentUtil.asString((Document)samlDoc.getSamlDocument()), new Object[0]);
                        }
                        if ((art = (ArtifactResponseType)samlDoc.getSamlObject()).getAny() == null) {
                            AsyncResponseTransaction.finishAsyncResponseInTransaction(session, this.asyncResponse, ErrorPage.error(session, null, Response.Status.BAD_REQUEST, "saml.artifactResolutionServiceInvalidResponse", new Object[0]));
                            return;
                        }
                        LoginProtocolFactory factory = (LoginProtocolFactory)session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
                        if (factory == null) {
                            logger.debugf("protocol %s not found", (Object)"saml");
                            throw new NotFoundException("Protocol not found");
                        }
                        SamlService endpoint = (SamlService)factory.createProtocolEndpoint(session, event);
                        if ("post".equals(this.bindingType)) {
                            protocol = endpoint.newPostBindingProtocol();
                        } else if ("get".equals(this.bindingType)) {
                            protocol = endpoint.newRedirectBindingProtocol();
                        } else {
                            throw new ConfigurationException("Invalid binding protocol: " + this.bindingType);
                        }
                        if (art.getAny() instanceof ResponseType) {
                            Document clientMessage = SAML2Request.convert((ResponseType)((ResponseType)art.getAny()));
                            String response = protocol.encodeSamlDocument(clientMessage);
                            AsyncResponseTransaction.finishAsyncResponseInTransaction(session, this.asyncResponse, protocol.handleSamlResponse(response, this.relayState));
                            break block27;
                        }
                        if (art.getAny() instanceof RequestAbstractType) {
                            Document clientMessage = SAML2Request.convert((RequestAbstractType)((RequestAbstractType)art.getAny()));
                            String request = protocol.encodeSamlDocument(clientMessage);
                            AsyncResponseTransaction.finishAsyncResponseInTransaction(session, this.asyncResponse, protocol.handleSamlRequest(request, this.relayState));
                            break block27;
                        }
                        throw new ProcessingException("Cannot recognise message contained in ArtifactResponse");
                    }
                    finally {
                        EntityUtils.consumeQuietly((HttpEntity)result.getEntity());
                    }
                }
                catch (IOException | IllegalArgumentException | ParsingException | ProcessingException e) {
                    event.event(EventType.LOGIN);
                    event.detail("reason", e.getMessage());
                    event.error("identity_provider_error");
                    AsyncResponseTransaction.finishAsyncResponseInTransaction(session, this.asyncResponse, ErrorPage.error(session, null, Response.Status.INTERNAL_SERVER_ERROR, "saml.artifactResolutionServiceInvalidResponse", new Object[0]));
                }
                catch (ConfigurationException e) {
                    event.event(EventType.LOGIN);
                    event.detail("reason", e.getMessage());
                    event.error("identity_provider_error");
                    AsyncResponseTransaction.finishAsyncResponseInTransaction(session, this.asyncResponse, ErrorPage.error(session, null, Response.Status.INTERNAL_SERVER_ERROR, "unexpectedErrorHandlingRequestMessage", new Object[0]));
                }
            }
        }
    }

    public abstract class BindingProtocol {
        protected boolean redirectToAuthentication;

        protected abstract Response error(KeycloakSession var1, AuthenticationSessionModel var2, Response.Status var3, String var4, Object ... var5);

        protected Response basicChecks(String samlRequest, String samlResponse, String artifact) {
            logger.tracef("basicChecks(%s, %s, %s)%s", new Object[]{samlRequest, samlResponse, artifact, StackUtil.getShortStackTrace()});
            if (!this.checkSsl()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("ssl_required");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "httpsRequiredMessage", new Object[0]);
            }
            if (!SamlService.this.realm.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN_ERROR);
                SamlService.this.event.error("realm_disabled");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "realmNotEnabledMessage", new Object[0]);
            }
            if (samlRequest == null && samlResponse == null && artifact == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("saml_token_not_found");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            return null;
        }

        protected boolean isDestinationRequired() {
            return true;
        }

        protected Response handleSamlResponse(String samlResponse, String relayState) {
            SamlService.this.event.event(EventType.LOGOUT);
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            if (!(holder.getSamlObject() instanceof StatusResponseType)) {
                SamlService.this.event.detail("reason", "invalid_saml_response");
                SamlService.this.event.error("invalid_saml_response");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (this.isDestinationRequired() && statusResponse.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                SamlService.this.event.detail("reason", "missing_required_destination");
                SamlService.this.event.error("invalid_logout_response");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (!SamlService.this.destinationValidator.validate(this.getExpectedDestinationUri(SamlService.this.session), statusResponse.getDestination())) {
                SamlService.this.event.detail("reason", "invalid_destination");
                SamlService.this.event.error("invalid_logout_response");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            SamlService.this.authManager;
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(SamlService.this.session, SamlService.this.realm, false);
            if (authResult == null) {
                logger.warn((Object)"Unknown saml response.");
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_token");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            UserSessionModel userSession = authResult.session();
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.warn((Object)"Unknown saml response.");
                logger.warn((Object)"UserSession is not tagged as logging out.");
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_logout_response");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            String issuer = statusResponse.getIssuer().getValue();
            ClientModel client = SamlService.this.realm.getClientByClientId(issuer);
            if (client == null) {
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.client(issuer);
                SamlService.this.event.error("client_not_found");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
            }
            if (!SamlService.this.isClientProtocolCorrect(client)) {
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_client");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "Wrong client protocol.", new Object[0]);
            }
            SamlService.this.session.getContext().setClient(client);
            logger.debug((Object)"logout response");
            SamlService.this.authManager;
            Response response = AuthenticationManager.browserLogout(SamlService.this.session, SamlService.this.realm, userSession, (UriInfo)SamlService.this.session.getContext().getUri(), SamlService.this.clientConnection, SamlService.this.headers);
            SamlService.this.event.success();
            return response;
        }

        protected Response triggerSamlEvent(ClientPolicyContext ctx) {
            try {
                SamlService.this.session.clientPolicy().triggerOnEvent(ctx);
            }
            catch (ClientPolicyException cpe) {
                SamlService.this.event.detail("reason", "client_policy_error");
                SamlService.this.event.detail("client_policy_error", cpe.getError());
                SamlService.this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
                SamlService.this.event.error(cpe.getError());
                logger.warnf("Error in client policies processing the request: %s - %s", (Object)cpe.getError(), (Object)cpe.getErrorDetail());
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            return null;
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder documentHolder = this.extractRequestDocument(samlRequest);
            if (documentHolder == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            SAML2Object samlObject = documentHolder.getSamlObject();
            if (samlObject instanceof AuthnRequestType) {
                logger.debug((Object)"** login request");
                SamlService.this.event.event(EventType.LOGIN);
            } else if (samlObject instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SamlService.this.event.event(EventType.LOGOUT);
            } else {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.detail("reason", "Unhandled SAML document type: " + (samlObject == null ? "<null>" : samlObject.getClass().getSimpleName()));
                SamlService.this.event.error("invalid_token");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
            NameIDType issuerNameId = requestAbstractType.getIssuer();
            String issuer = requestAbstractType.getIssuer() == null ? null : issuerNameId.getValue();
            ClientModel client = SamlService.this.realm.getClientByClientId(issuer);
            Response error = this.checkClientValidity(client);
            if (error != null) {
                return error;
            }
            SamlService.this.session.getContext().setClient(client);
            SamlClient samlClient = new SamlClient(client);
            try {
                if (samlClient.requiresClientSignature()) {
                    this.verifySignature(documentHolder, client);
                }
            }
            catch (VerificationException e) {
                logger.error((Object)"request validation failed", (Throwable)e);
                SamlService.this.event.error("invalid_signature");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
            }
            logger.debug((Object)"verified request");
            if (this.isDestinationRequired() && requestAbstractType.getDestination() == null && this.containsUnencryptedSignature(documentHolder)) {
                SamlService.this.event.detail("reason", "missing_required_destination");
                SamlService.this.event.error("invalid_request");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (samlObject instanceof AuthnRequestType) {
                AuthnRequestType authn = (AuthnRequestType)samlObject;
                Response response = this.triggerSamlEvent(new SamlAuthnRequestContext(authn, client, this.getBindingType()));
                if (response != null) {
                    return response;
                }
                return this.loginRequest(relayState, authn, client);
            }
            if (samlObject instanceof LogoutRequestType) {
                LogoutRequestType logout = (LogoutRequestType)samlObject;
                Response response = this.triggerSamlEvent(new SamlLogoutRequestContext(logout, client, this.getBindingType()));
                if (response != null) {
                    return response;
                }
                return this.logoutRequest(logout, client, relayState);
            }
            throw new IllegalStateException("Invalid SAML object");
        }

        protected void handleArtifact(AsyncResponse asyncResponse, String artifact, String relayState) {
            ClientModel client;
            logger.tracef("Keycloak obtained artifact %s. %s", (Object)artifact, StackUtil.getShortStackTrace());
            try {
                client = SamlService.this.getArtifactResolver(artifact).selectSourceClient(SamlService.this.session, artifact);
                Response error = this.checkClientValidity(client);
                if (error != null) {
                    asyncResponse.resume((Object)error);
                    return;
                }
            }
            catch (ArtifactResolverProcessingException e) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.detail("reason", e.getMessage());
                SamlService.this.event.error("invalid_artifact");
                asyncResponse.resume((Object)this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]));
                return;
            }
            try {
                String clientArtifactBindingURL;
                Document doc = SamlService.this.createArtifactResolve(client.getClientId(), artifact);
                BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
                SamlClient samlClient = new SamlClient(client);
                if (samlClient.requiresRealmSignature()) {
                    KeyManager keyManager = SamlService.this.session.keys();
                    KeyManager.ActiveRsaKey keys = keyManager.getActiveRsaKey(SamlService.this.realm);
                    String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                    String canonicalization = samlClient.getCanonicalizationMethod();
                    if (canonicalization != null) {
                        binding.canonicalizationMethod(canonicalization);
                    }
                    binding.signatureAlgorithm(samlClient.getSignatureAlgorithm()).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate()).signDocument(doc);
                }
                if ((clientArtifactBindingURL = client.getAttribute("saml_artifact_resolution_service_url")) == null || clientArtifactBindingURL.isEmpty()) {
                    throw new ConfigurationException("There is no configured artifact resolution service for the client " + client.getClientId());
                }
                URI clientArtifactBindingURI = new URI(clientArtifactBindingURL);
                ExecutorService executor = ((ExecutorsProvider)SamlService.this.session.getProvider(ExecutorsProvider.class)).getExecutor("saml-artifact-pool");
                ArtifactResolutionRunnable artifactResolutionRunnable = new ArtifactResolutionRunnable(this.getBindingType(), asyncResponse, doc, clientArtifactBindingURI, relayState);
                ScheduledTaskRunner task = new ScheduledTaskRunner(SamlService.this.session.getKeycloakSessionFactory(), (ScheduledTask)artifactResolutionRunnable);
                executor.execute((Runnable)task);
                logger.tracef("ArtifactResolutionRunnable scheduled, current transaction will be rolled back", new Object[0]);
                SamlService.this.session.getTransactionManager().rollback();
            }
            catch (URISyntaxException | ConfigurationException | ParsingException | ProcessingException e) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.detail("reason", e.getMessage());
                SamlService.this.event.error("identity_provider_error");
                asyncResponse.resume((Object)this.error(SamlService.this.session, null, Response.Status.INTERNAL_SERVER_ERROR, "unexpectedErrorHandlingRequestMessage", new Object[0]));
                return;
            }
        }

        protected abstract String encodeSamlDocument(Document var1) throws ProcessingException;

        protected abstract void verifySignature(SAMLDocumentHolder var1, ClientModel var2) throws VerificationException;

        protected abstract boolean containsUnencryptedSignature(SAMLDocumentHolder var1);

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected Response loginRequest(String relayState, AuthnRequestType requestAbstractType, ClientModel client) {
            BaseIDAbstractType baseID;
            SubjectType.STSubType subType;
            SubjectType subject;
            URI nameIdFormatUri;
            String redirect;
            URI redirectUri;
            SamlClient samlClient = new SamlClient(client);
            if (!this.validateDestination((RequestAbstractType)requestAbstractType, samlClient, "invalid_authn_request")) {
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            String bindingType = this.getBindingType(requestAbstractType);
            if (samlClient.forcePostBinding()) {
                bindingType = "post";
            }
            if ((redirectUri = requestAbstractType.getAssertionConsumerServiceURL()) != null && !"null".equals(redirectUri.toString())) {
                redirect = RedirectUtils.verifyRedirectUri(SamlService.this.session, redirectUri.toString(), client);
            } else {
                redirect = requestAbstractType.getProtocolBinding() != null && JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri().equals(requestAbstractType.getProtocolBinding()) || samlClient.forceArtifactBinding() ? client.getAttribute("saml_artifact_binding_url") : (bindingType.equals("post") ? client.getAttribute("saml_assertion_consumer_url_post") : client.getAttribute("saml_assertion_consumer_url_redirect"));
                if (redirect == null || redirect.trim().isEmpty()) {
                    redirect = client.getManagementUrl();
                }
            }
            if (redirect == null) {
                SamlService.this.event.error("invalid_redirect_uri");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRedirectUriMessage", new Object[0]);
            }
            AuthenticationSessionModel authSession = SamlService.this.createAuthenticationSession(client, relayState);
            if (requestAbstractType.getProtocolBinding() != null && JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri().equals(requestAbstractType.getProtocolBinding()) || new SamlClient(client).forceArtifactBinding()) {
                authSession.setClientNote(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get(), "true");
            }
            authSession.setProtocol("saml");
            authSession.setRedirectUri(redirect);
            authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
            authSession.setClientNote("saml_binding", bindingType);
            authSession.setClientNote("RelayState", relayState);
            authSession.setClientNote("SAML_REQUEST_ID", requestAbstractType.getID());
            NameIDPolicyType nameIdPolicy = requestAbstractType.getNameIDPolicy();
            URI uRI = nameIdFormatUri = nameIdPolicy == null ? null : nameIdPolicy.getFormat();
            if (nameIdFormatUri != null && !samlClient.forceNameIDFormat()) {
                String nameIdFormat = nameIdFormatUri.toString();
                if (this.isSupportedNameIdFormat(nameIdFormat)) {
                    authSession.setClientNote("NAMEID_FORMAT", nameIdFormat);
                } else {
                    SamlService.this.event.detail("reason", "unsupported_nameid_format");
                    SamlService.this.event.error("invalid_authn_request");
                    return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "unsupportedNameIdFormatMessage", new Object[0]);
                }
            }
            if ((subject = requestAbstractType.getSubject()) != null && (subType = subject.getSubType()) != null && (baseID = subject.getSubType().getBaseID()) instanceof NameIDType) {
                NameIDType nameID = (NameIDType)baseID;
                authSession.setClientNote("login_hint", nameID.getValue());
            }
            if (null != requestAbstractType.isForceAuthn() && requestAbstractType.isForceAuthn().booleanValue()) {
                authSession.setAuthNote("SAML_LOGIN_REQUEST_FORCEAUTHN", "true");
            }
            Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(SamlService.this.session);
            while (it.hasNext()) {
                requestAbstractType = it.next().beforeProcessingLoginRequest(requestAbstractType, authSession);
            }
            boolean isPassive = null != requestAbstractType.isIsPassive() && requestAbstractType.isIsPassive() != false;
            return SamlService.this.newBrowserAuthentication(authSession, isPassive, this.redirectToAuthentication);
        }

        protected String getBindingType(AuthnRequestType requestAbstractType) {
            URI requestedProtocolBinding = requestAbstractType.getProtocolBinding();
            if (requestedProtocolBinding != null) {
                if (JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get().equals(requestedProtocolBinding.toString())) {
                    return "post";
                }
                if (JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get().equals(requestedProtocolBinding.toString())) {
                    return this.getBindingType();
                }
                return "get";
            }
            return this.getBindingType();
        }

        private boolean isSupportedNameIdFormat(String nameIdFormat) {
            return nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        }

        protected abstract String getBindingType();

        protected Response logoutRequest(LogoutRequestType logoutRequest, ClientModel client, String relayState) {
            SamlClient samlClient = new SamlClient(client);
            if (!this.validateDestination((RequestAbstractType)logoutRequest, samlClient, "invalid_logout_request")) {
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            SamlService.this.authManager;
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(SamlService.this.session, SamlService.this.realm, false);
            if (authResult != null) {
                String logoutBinding = this.getBindingType();
                String postBindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.session, client, "post", false);
                if (samlClient.forcePostBinding() && postBindingUri != null && !postBindingUri.trim().isEmpty()) {
                    logoutBinding = "post";
                }
                boolean postBinding = Objects.equals("post", logoutBinding);
                String bindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.session, client, logoutBinding, false);
                UserSessionModel userSession = authResult.session();
                userSession.setNote("SAML_LOGOUT_BINDING_URI", bindingUri);
                if (samlClient.requiresRealmSignature()) {
                    userSession.setNote("saml.logout.signature.algorithm", samlClient.getSignatureAlgorithm().toString());
                }
                if (relayState != null) {
                    userSession.setNote("SAML_LOGOUT_RELAY_STATE", relayState);
                }
                userSession.setNote("SAML_LOGOUT_REQUEST_ID", logoutRequest.getID());
                userSession.setNote("saml.logout.binding", logoutBinding);
                userSession.setNote("saml.logout.addExtensionsElementWithKeyInfo", Boolean.toString(!postBinding && samlClient.addExtensionsElementWithKeyInfo()));
                userSession.setNote("SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER", samlClient.getXmlSigKeyInfoKeyNameTransformer().name());
                userSession.setNote("SAML_LOGOUT_CANONICALIZATION", samlClient.getCanonicalizationMethod());
                userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "saml");
                AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
                if (clientSession != null) {
                    clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
                    if ("artifact".equals(SamlProtocol.getLogoutBindingTypeForClientSession(clientSession))) {
                        clientSession.setAction(CommonClientSessionModel.Action.LOGGING_OUT.name());
                        userSession.setNote(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get(), "true");
                        userSession.setNote("SAML_LOGOUT_INITIATOR_CLIENT_ID", client.getId());
                    }
                }
                Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(SamlService.this.session);
                while (it.hasNext()) {
                    logoutRequest = it.next().beforeProcessingLogoutRequest(logoutRequest, userSession, clientSession);
                }
                logger.debug((Object)"browser Logout");
                SamlService.this.authManager;
                return AuthenticationManager.browserLogout(SamlService.this.session, SamlService.this.realm, userSession, (UriInfo)SamlService.this.session.getContext().getUri(), SamlService.this.clientConnection, SamlService.this.headers);
            }
            if (logoutRequest.getSessionIndex() != null) {
                for (String sessionIndex : logoutRequest.getSessionIndex()) {
                    AuthenticatedClientSessionModel clientSession = SamlSessionUtils.getClientSession(SamlService.this.session, SamlService.this.realm, sessionIndex);
                    if (clientSession == null) continue;
                    UserSessionModel userSession = clientSession.getUserSession();
                    if (clientSession.getClient().getClientId().equals(client.getClientId())) {
                        clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
                    }
                    Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(SamlService.this.session);
                    while (it.hasNext()) {
                        logoutRequest = it.next().beforeProcessingLogoutRequest(logoutRequest, userSession, clientSession);
                    }
                    try {
                        SamlService.this.event.event(EventType.LOGOUT).detail("auth_method", userSession.getAuthMethod()).client(SamlService.this.session.getContext().getClient()).user(userSession.getUser()).session(userSession).detail("username", userSession.getLoginUsername()).detail("response_mode", this.getBindingType());
                        SamlService.this.authManager;
                        AuthenticationManager.backchannelLogout(SamlService.this.session, SamlService.this.realm, userSession, (UriInfo)SamlService.this.session.getContext().getUri(), SamlService.this.clientConnection, SamlService.this.headers, true);
                        SamlService.this.event.success();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failure with backchannel logout", (Throwable)e);
                        SamlService.this.event.error("Failure with backchannel logout");
                    }
                }
            }
            String logoutBinding = this.getBindingType();
            String logoutBindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.session, client, logoutBinding, true);
            String logoutRelayState = relayState;
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(logoutRequest.getID());
            builder.destination(logoutBindingUri);
            builder.issuer(RealmsResource.realmBaseUrl((UriInfo)SamlService.this.session.getContext().getUri()).build(new Object[]{SamlService.this.realm.getName()}).toString());
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(SamlService.this.session).relayState(logoutRelayState);
            boolean postBinding = "post".equals(logoutBinding);
            if (samlClient.requiresRealmSignature()) {
                SignatureAlgorithm algorithm = samlClient.getSignatureAlgorithm();
                KeyManager.ActiveRsaKey keys = SamlService.this.session.keys().getActiveRsaKey(SamlService.this.realm);
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(algorithm)).signWith(keys.getKid(), keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
                if (!postBinding && samlClient.addExtensionsElementWithKeyInfo()) {
                    builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keys.getKid()));
                }
            }
            try {
                if (postBinding) {
                    return binding.postBinding(builder.buildDocument()).response(logoutBindingUri);
                }
                if ("soap".equals(logoutBinding)) {
                    return binding.soapBinding(builder.buildDocument()).response();
                }
                return binding.redirectBinding(builder.buildDocument()).response(logoutBindingUri);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean validateDestination(RequestAbstractType req, SamlClient samlClient, String errorCode) {
            if (!this.isDestinationRequired() && req.getDestination() == null) {
                return true;
            }
            if (req.getDestination() == null && samlClient.requiresClientSignature()) {
                SamlService.this.event.detail("reason", "missing_destination_required");
                SamlService.this.event.error(errorCode);
                return false;
            }
            if (!SamlService.this.destinationValidator.validate(this.getExpectedDestinationUri(SamlService.this.session), req.getDestination())) {
                SamlService.this.event.detail("reason", "invalid_destination");
                SamlService.this.event.error(errorCode);
                return false;
            }
            return true;
        }

        private boolean checkSsl() {
            if (SamlService.this.session.getContext().getUri().getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SamlService.this.realm.getSslRequired().isRequired(SamlService.this.clientConnection);
        }

        public Response execute(String samlRequest, String samlResponse, String relayState, String artifact) {
            Response response = this.basicChecks(samlRequest, samlResponse, artifact);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }

        public void execute(AsyncResponse asyncReponse, String samlRequest, String samlResponse, String relayState, String artifact) {
            Response response = this.basicChecks(samlRequest, samlResponse, artifact);
            if (response != null) {
                asyncReponse.resume((Object)response);
                return;
            }
            if (artifact != null) {
                this.handleArtifact(asyncReponse, artifact, relayState);
                return;
            }
            if (samlRequest != null) {
                asyncReponse.resume((Object)this.handleSamlRequest(samlRequest, relayState));
                return;
            }
            asyncReponse.resume((Object)this.handleSamlResponse(samlResponse, relayState));
        }

        protected URI getExpectedDestinationUri(KeycloakSession session) {
            String realmName = session.getContext().getRealm().getName();
            URI baseUri = session.getContext().getUri().getBaseUri();
            return Urls.samlRequestEndpoint(baseUri, realmName);
        }

        private Response checkClientValidity(ClientModel client) {
            if (client == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.detail("reason", "Cannot_match_source_hash");
                SamlService.this.event.error("client_not_found");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (!client.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("client_disabled");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "loginRequesterNotEnabledMessage", new Object[0]);
            }
            if (client.isBearerOnly()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "bearerOnlyMessage", new Object[0]);
            }
            if (!client.isStandardFlowEnabled()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "standardFlowDisabledMessage", new Object[0]);
            }
            if (!SamlService.this.isClientProtocolCorrect(client)) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_client");
                return this.error(SamlService.this.session, null, Response.Status.BAD_REQUEST, "Wrong client protocol.", new Object[0]);
            }
            return null;
        }
    }
}

