/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.DurationConverter;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.component.ComponentModel;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class NotifyUserStepProvider
implements WorkflowStepProvider {
    private final KeycloakSession session;
    private final ComponentModel stepModel;
    private final Logger log = Logger.getLogger(NotifyUserStepProvider.class);

    public NotifyUserStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.stepModel = model;
    }

    public void close() {
    }

    public void run(WorkflowExecutionContext context) {
        RealmModel realm = this.session.getContext().getRealm();
        EmailTemplateProvider emailProvider = ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(realm);
        String subjectKey = this.getSubjectKey(context);
        String bodyTemplate = this.getBodyTemplate();
        Map<String, Object> bodyAttributes = this.getBodyAttributes(context);
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user != null && user.getEmail() != null) {
            try {
                emailProvider.setUser(user).send(subjectKey, bodyTemplate, bodyAttributes);
                this.log.debugv("Notification email sent to user {0} ({1})", (Object)user.getUsername(), (Object)user.getEmail());
            }
            catch (EmailException e) {
                this.log.errorv((Throwable)e, "Failed to send notification email to user {0} ({1})", (Object)user.getUsername(), (Object)user.getEmail());
            }
        } else if (user != null && user.getEmail() == null) {
            this.log.warnv("User {0} has no email address, skipping notification", (Object)user.getUsername());
        }
    }

    private String getSubjectKey(WorkflowExecutionContext context) {
        String customSubjectKey = (String)this.stepModel.getConfig().getFirst((Object)"subject");
        if (customSubjectKey != null && !customSubjectKey.trim().isEmpty()) {
            return customSubjectKey;
        }
        WorkflowStep nextStep = context.getNextStep();
        if (nextStep == null || nextStep.getNotificationSubject() == null) {
            return "accountNotificationSubject";
        }
        return nextStep.getNotificationSubject();
    }

    private String getBodyTemplate() {
        return "workflow-notification.ftl";
    }

    private Map<String, Object> getBodyAttributes(WorkflowExecutionContext context) {
        RealmModel realm = this.session.getContext().getRealm();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        WorkflowStep nextStep = context.getNextStep();
        String customMessage = (String)this.stepModel.getConfig().getFirst((Object)"message");
        if (customMessage != null && !customMessage.trim().isEmpty()) {
            attributes.put("messageKey", "customMessage");
            attributes.put("customMessage", StringPropertyReplacer.replaceProperties((String)customMessage, (StringPropertyReplacer.PropertyResolver)new NotificationPropertyResolver(this.session, context)));
        } else if (nextStep != null && nextStep.getNotificationMessage() != null) {
            attributes.put("messageKey", nextStep.getNotificationMessage());
        } else {
            attributes.put("messageKey", "accountNotificationBody");
        }
        int daysRemaining = this.calculateDaysUntilNextStep(context);
        attributes.put("daysRemaining", daysRemaining);
        attributes.put("reason", this.stepModel.getConfig().getFirstOrDefault((Object)"reason", (Object)"inactivity"));
        attributes.put("realmName", realm.getDisplayName() != null ? realm.getDisplayName() : realm.getName());
        if (nextStep != null) {
            attributes.put("nextStepType", nextStep.getProviderId());
        }
        attributes.put("subjectKey", this.getSubjectKey(context));
        return attributes;
    }

    private int calculateDaysUntilNextStep(WorkflowExecutionContext context) {
        WorkflowStep nextStep = context.getNextStep();
        if (nextStep == null || nextStep.getAfter() == null) {
            return 0;
        }
        return Math.toIntExact(DurationConverter.parseDuration((String)nextStep.getAfter()).toDays());
    }

    private class NotificationPropertyResolver
    implements StringPropertyReplacer.PropertyResolver {
        private final KeycloakSession session;
        private final WorkflowExecutionContext context;

        public NotificationPropertyResolver(KeycloakSession session, WorkflowExecutionContext context) {
            this.session = session;
            this.context = context;
        }

        public String resolve(String property) {
            if (property.startsWith("user.")) {
                String userId = this.context.getResourceId();
                RealmModel realm = this.session.getContext().getRealm();
                UserModel user = this.session.users().getUserById(realm, userId);
                if (user == null) {
                    return null;
                }
                String attributeKey = property.substring("user.".length());
                return user.getFirstAttribute(attributeKey);
            }
            if (property.startsWith("realm.")) {
                RealmModel realm = this.session.getContext().getRealm();
                String attributeKey = property.substring("realm.".length());
                if (attributeKey.equals("name")) {
                    return realm.getName();
                }
                if (attributeKey.equals("displayName")) {
                    return realm.getDisplayName();
                }
                return null;
            }
            if ("workflow.daysUntilNextStep".equals(property)) {
                return String.valueOf(NotifyUserStepProvider.this.calculateDaysUntilNextStep(this.context));
            }
            return null;
        }
    }
}

