/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.observability;

import io.quarkus.resteasy.reactive.server.runtime.observability.ObservabilityUtil;
import io.vertx.ext.web.RoutingContext;
import java.util.regex.Pattern;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ObservabilityHandler
implements ServerRestHandler {
    static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");
    private String templatePath;
    private boolean isSubResource;

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = MULTIPLE_SLASH_PATTERN.matcher(templatePath).replaceAll("/");
    }

    public boolean isSubResource() {
        return this.isSubResource;
    }

    public void setSubResource(boolean subResource) {
        this.isSubResource = subResource;
    }

    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
        if (this.isSubResource) {
            String previous = ObservabilityUtil.getUrlPathTemplate(routingContext);
            if (previous == null) {
                previous = "";
            }
            ObservabilityUtil.setUrlPathTemplate(routingContext, previous + this.templatePath);
        } else {
            ObservabilityUtil.setUrlPathTemplate(routingContext, this.templatePath);
        }
    }
}

