/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownTokenClasses;

public class BrownBigramFeatureGenerator
implements AdaptiveFeatureGenerator {
    private static final String BROWNCLUSTER = "browncluster";
    private static final String FEATURE_NEXT_BROWNCLUSTER_BASE = "browncluster,nbrowncluster=";
    private static final String FEATURE_PREV_BROWNCLUSTER_BASE = "pbrowncluster,browncluster=";
    private final BrownCluster brownCluster;

    public BrownBigramFeatureGenerator(BrownCluster brownCluster) {
        this.brownCluster = brownCluster;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        int i;
        List<String> wc = BrownTokenClasses.getWordClasses(tokens[index], this.brownCluster);
        if (index > 0) {
            List<String> prevWC = BrownTokenClasses.getWordClasses(tokens[index - 1], this.brownCluster);
            for (i = 0; i < wc.size() && i < prevWC.size(); ++i) {
                features.add(FEATURE_PREV_BROWNCLUSTER_BASE + prevWC.get(i) + "," + wc.get(i));
            }
        }
        if (index + 1 < tokens.length) {
            List<String> nextWordClasses = BrownTokenClasses.getWordClasses(tokens[index + 1], this.brownCluster);
            for (i = 0; i < wc.size() && i < nextWordClasses.size(); ++i) {
                features.add(FEATURE_NEXT_BROWNCLUSTER_BASE + wc.get(i) + "," + nextWordClasses.get(i));
            }
        }
    }
}

