/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.confirmation;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ConfirmationDescriptor
extends AbstractDescriptor {
    private static final String GROUP_ID = "confirm";
    private final String id;
    private final String title;
    private final String description;
    private final String message;
    private final String group;
    private final String toggleMessage;

    protected ConfirmationDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.title = config.getAttribute("title");
        this.description = config.getAttribute("description");
        this.message = config.getAttribute("message");
        this.group = config.getAttribute("group");
        this.toggleMessage = config.getAttribute("toggleMessage");
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public String getToggleMessage() {
        return this.toggleMessage;
    }

    @NotNull
    public String getLocalizedTitle(@NotNull String locale) {
        try {
            return RuntimeUtils.getBundleLocalization(this.getContributorBundle(), locale).getString("confirm." + this.getId() + ".title");
        }
        catch (Exception exception) {
            return this.getTitle();
        }
    }

    @NotNull
    public String getLocalizedMessage(@NotNull String locale) {
        try {
            return RuntimeUtils.getBundleLocalization(this.getContributorBundle(), locale).getString("confirm." + this.getId() + ".message");
        }
        catch (Exception exception) {
            return this.getMessage();
        }
    }
}

