/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DefaultProgressMonitor
implements DBRProgressMonitor {
    private static final Log log = Log.getLog(DefaultProgressMonitor.class);
    private final IProgressMonitor nestedMonitor;
    private List<DBRBlockingObject> blocks = null;
    private final List<ProgressState> states = new ArrayList<ProgressState>();

    public DefaultProgressMonitor(@NotNull IProgressMonitor nestedMonitor) {
        this.nestedMonitor = nestedMonitor;
    }

    @Override
    @NotNull
    public IProgressMonitor getNestedMonitor() {
        return this.nestedMonitor;
    }

    @Override
    public void beginTask(@NotNull String name, int totalWork) {
        ProgressState state = new ProgressState(name, totalWork);
        this.states.add(state);
        this.nestedMonitor.beginTask(name, totalWork);
    }

    @Override
    public void done() {
        this.nestedMonitor.done();
        if (!this.states.isEmpty()) {
            ProgressState lastState = this.states.removeLast();
            this.nestedMonitor.beginTask(lastState.taskName, lastState.totalWork);
            if (lastState.subTask != null) {
                this.nestedMonitor.subTask(lastState.subTask);
            }
            if (lastState.progress > 0) {
                this.nestedMonitor.worked(lastState.progress);
            }
        } else {
            log.trace(new DBCException("Progress ended without start"));
        }
    }

    @Override
    public void subTask(@NotNull String name) {
        if (this.states.isEmpty()) {
            log.trace(new DBCException("Progress sub task without start"));
        } else {
            this.states.getLast().subTask = name;
        }
        this.nestedMonitor.subTask(name);
    }

    @Override
    public void worked(int work) {
        if (this.states.isEmpty()) {
            log.trace(new DBCException("Progress info without start"));
        } else {
            this.states.getLast().progress += work;
        }
        this.nestedMonitor.worked(work);
    }

    @Override
    public boolean isCanceled() {
        return this.nestedMonitor.isCanceled() || DBWorkbench.getPlatform().isShuttingDown();
    }

    @Override
    public synchronized void startBlock(@NotNull DBRBlockingObject object, @Nullable String taskName) {
        if (taskName != null) {
            this.subTask(taskName);
        }
        if (this.blocks == null) {
            this.blocks = new ArrayList<DBRBlockingObject>();
        }
        this.blocks.add(object);
    }

    @Override
    public synchronized void endBlock() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            log.warn("End block invoked while no blocking objects are in stack");
            return;
        }
        this.blocks.removeLast();
    }

    @Override
    @Nullable
    public synchronized List<DBRBlockingObject> getActiveBlocks() {
        return this.blocks == null || this.blocks.isEmpty() ? null : new ArrayList<DBRBlockingObject>(this.blocks);
    }

    private static class ProgressState {
        final String taskName;
        final int totalWork;
        int progress;
        String subTask;

        ProgressState(String taskName, int totalWork) {
            this.taskName = taskName;
            this.totalWork = totalWork;
        }

        public String toString() {
            return this.taskName + (String)(this.subTask == null ? "" : " (" + this.subTask + ")");
        }
    }
}

