/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import org.mvel2.ast.Safe;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;

public class ExecutableLiteral
implements ExecutableStatement,
Safe {
    private Object literal;
    private int integer32;
    private boolean intOptimized;

    public ExecutableLiteral(Object literal) {
        this.literal = literal;
        if (this.literal instanceof Integer) {
            this.integer32 = (Integer)literal;
        }
    }

    public ExecutableLiteral(int literal) {
        this.integer32 = literal;
        this.literal = this.integer32;
        this.intOptimized = true;
    }

    public int getInteger32() {
        return this.integer32;
    }

    public void setInteger32(int integer32) {
        this.integer32 = integer32;
    }

    @Override
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        return this.literal;
    }

    @Override
    public void setKnownIngressType(Class type2) {
    }

    @Override
    public void setKnownEgressType(Class type2) {
    }

    @Override
    public Class getKnownIngressType() {
        return null;
    }

    @Override
    public Class getKnownEgressType() {
        return this.literal == null ? Object.class : this.literal.getClass();
    }

    @Override
    public boolean isConvertableIngressEgress() {
        return false;
    }

    @Override
    public void computeTypeConversionRule() {
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        return this.literal;
    }

    public Object getLiteral() {
        return this.literal;
    }

    @Override
    public boolean intOptimized() {
        return this.intOptimized;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    @Override
    public boolean isLiteralOnly() {
        return true;
    }

    @Override
    public boolean isEmptyStatement() {
        return false;
    }

    @Override
    public boolean isExplicitCast() {
        return false;
    }
}

