# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Snippet message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class Snippet < Message
      ##
      # The programming language of the code.
      #
      # This must be formatted as an all lowercase identifier such that syntax highlighters like [Prism](https://prismjs.com/#supported-languages) or [Highlight.js](https://github.com/highlightjs/highlight.js/blob/main/SUPPORTED_LANGUAGES.md) can recognize it.
      # For example: `cpp`, `cs`, `go`, `java`, `javascript`, `php`, `python`, `ruby`, `scala`.
      ##
      attr_reader :language

      ##
      # A snippet of code
      ##
      attr_reader :code

      def initialize(
        language: '',
        code: ''
      )
        @language = language
        @code = code
        super()
      end

      ##
      # Returns a new Snippet from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Snippet.from_h(some_hash) # => #<Cucumber::Messages::Snippet:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          language: hash[:language],
          code: hash[:code]
        )
      end
    end
  end
end
