/**
 * ./src/components/partitions.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import fs from 'fs';
import { Box, Newline, Text } from 'ink';
import yaml from 'js-yaml';
import React from 'react';
import { InstallationMode } from '../classes/krill_enums.js';
import Steps from './steps.js';
import Title from './title.js';
export default function Partitions({ filesystemType, installationDevice, installationMode, replacedPartition, userSwapChoice }) {
    const installer = 'krill';
    let productName = '';
    let version = '';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    const calamaresRoot = '/etc/calamares/';
    const settingFileName = configRoot + 'settings.conf';
    let brandingFile = '';
    if (fs.existsSync(calamaresRoot + settingFileName)) {
        configRoot = calamaresRoot;
    }
    if (fs.existsSync(configRoot + settingFileName)) {
        const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf8'));
        const { branding } = settings;
        brandingFile = configRoot + 'branding/' + branding + '/branding.desc';
        if (fs.existsSync(brandingFile)) {
            const calamares = yaml.load(fs.readFileSync(brandingFile, 'utf8'));
            productName = calamares.strings.productName;
            version = calamares.strings.version;
        }
    }
    /**
     * totale width=75
     * step width=15
     * finestra with=59
     */
    let bios = 'standard';
    if (fs.existsSync('/sys/firmware/efi/efivars')) {
        bios = 'UEFI';
    }
    let partitions = {};
    if (fs.existsSync(configRoot + 'modules/partition.conf')) {
        partitions = yaml.load(fs.readFileSync(configRoot + 'modules/partition.conf', 'utf8'));
    }
    else {
        partitions.initialSwapChoice = 'small';
    }
    let message = '';
    if (installationMode === InstallationMode.Replace) {
        message = `replaced partition: ${replacedPartition}`;
    }
    else {
        message = `installation device: ${installationDevice}`;
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { borderStyle: "round", flexDirection: "column", height: 11, width: 75 },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 4 }),
                    React.createElement(Box, { flexDirection: "column" }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "BIOS: "),
                            React.createElement(Text, { color: "cyan" },
                                bios,
                                " "),
                            React.createElement(Text, null, "Installation device: "),
                            React.createElement(Text, { color: "cyan" }, installationDevice)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Installation mode: "),
                            React.createElement(Text, { color: "cyan" }, installationMode)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Filesystem: "),
                            React.createElement(Text, { color: "cyan" }, filesystemType)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "User swap choice: "),
                            React.createElement(Text, { color: "cyan" }, userSwapChoice)),
                        React.createElement(Newline, null),
                        React.createElement(Box, { flexDirection: "row" },
                            React.createElement(Text, { underline: false }, "(*) "),
                            React.createElement(Box, { flexDirection: "column" },
                                React.createElement(Text, { backgroundColor: "red", color: "white" }, "this will erase all data currently present on the"),
                                React.createElement(Text, { backgroundColor: "red", color: "white" }, message)))))))));
}
