/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Explanation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Explanation> {
    @Nonnull
    private final String description;
    @Nonnull
    private final List<Explanation> details;
    @Nonnull
    private final Number value;
    public static final JsonpDeserializer<Explanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Explanation::setupExplanationDeserializer);

    private Explanation(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.details = ApiTypeHelper.unmodifiable(builder.details);
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static Explanation of(Function<Builder, ObjectBuilder<Explanation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final List<Explanation> details() {
        return this.details;
    }

    @Nonnull
    public final Number value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (Explanation item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("value");
        generator.write(this.value.doubleValue());
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupExplanationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "details");
        op.add(Builder::value, JsonpDeserializer.numberDeserializer(), "value");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.description.hashCode();
        result = 31 * result + Objects.hashCode(this.details);
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Explanation other = (Explanation)o;
        return this.description.equals(other.description) && Objects.equals(this.details, other.details) && this.value.equals(other.value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Explanation> {
        private String description;
        @Nullable
        private List<Explanation> details;
        private Number value;

        public Builder() {
        }

        private Builder(Explanation o) {
            this.description = o.description;
            this.details = Builder._listCopy(o.details);
            this.value = o.value;
        }

        private Builder(Builder o) {
            this.description = o.description;
            this.details = Builder._listCopy(o.details);
            this.value = o.value;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder details(List<Explanation> list) {
            this.details = Builder._listAddAll(this.details, list);
            return this;
        }

        @Nonnull
        public final Builder details(Explanation value, Explanation ... values) {
            this.details = Builder._listAdd(this.details, value, values);
            return this;
        }

        @Nonnull
        public final Builder details(Function<Builder, ObjectBuilder<Explanation>> fn) {
            return this.details(fn.apply(new Builder()).build(), new Explanation[0]);
        }

        @Nonnull
        public final Builder value(Number value) {
            this.value = value;
            return this;
        }

        @Override
        @Nonnull
        public Explanation build() {
            this._checkSingleUse();
            return new Explanation(this);
        }
    }
}

