/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.oauth;

import java.sql.SQLException;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.oauth.OpaqueAccessToken;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.Clock;
import oracle.net.nt.TimeoutInterruptHandler;

final class AccessTokenCache<T extends OpaqueAccessToken>
implements Supplier<T> {
    private static final long EXPIRATION_THRESHOLD = 30000L;
    private static final long UPDATE_THRESHOLD = 60000L;
    private final Supplier<T> tokenSupplier;
    private final Executor executor;
    private final LongSummaryStatistics latency = new LongSummaryStatistics();
    private final AtomicInteger getCount = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition updateCondition = this.lock.newCondition();
    private boolean isUpdating = false;
    private T token = null;
    private RuntimeException failure;

    public static <T extends OpaqueAccessToken> AccessTokenCache<T> create(Supplier<T> tokenSupplier) {
        try {
            return new AccessTokenCache<T>(OracleDriver.getExecutorService(), tokenSupplier);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException(sqlException);
        }
    }

    private AccessTokenCache(Executor executor, @Blind Supplier<T> tokenSupplier) {
        this.executor = executor;
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    @Blind
    public T get() {
        this.getCount.incrementAndGet();
        T cachedToken = this.token;
        if (cachedToken != null && !AccessTokenCache.isExpiring(cachedToken)) {
            return cachedToken;
        }
        this.lock.lock();
        try {
            while (cachedToken == this.token && this.failure == null) {
                if (!this.isUpdating) {
                    this.isUpdating = true;
                    this.requestUpdate();
                }
                this.updateCondition.await();
            }
            if (this.failure != null) {
                RuntimeException updateFailure = this.failure;
                this.failure = null;
                throw updateFailure;
            }
            T updateFailure = this.token;
            return updateFailure;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void requestUpdate() {
        this.executor.execute(() -> {
            try {
                long start = System.nanoTime();
                OpaqueAccessToken token = (OpaqueAccessToken)this.tokenSupplier.get();
                this.latency.accept(System.nanoTime() - start);
                this.update(Objects.requireNonNull(token, "token supplier has output a null value"), null);
            }
            catch (RuntimeException failure) {
                this.update(null, failure);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@Blind T token, RuntimeException failure) {
        boolean isUpdating = this.getCount.getAndSet(0) != 0 && failure == null;
        this.lock.lock();
        try {
            this.token = token;
            this.failure = failure;
            this.isUpdating = isUpdating;
            this.updateCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (isUpdating) {
            this.scheduleUpdate(TimeUnit.SECONDS.toMillis(((OpaqueAccessToken)token).expiration().toEpochSecond()));
        }
    }

    private void scheduleUpdate(long expireTimeMillis) {
        long updateLatency = TimeUnit.NANOSECONDS.toMillis(Math.round(this.latency.getAverage() * 1.2));
        long expirationDelay = expireTimeMillis - 60000L - System.currentTimeMillis();
        TimeoutInterruptHandler.scheduleTask(this::requestUpdate, Math.max(0L, expirationDelay - updateLatency));
    }

    private static boolean isExpiring(@Blind OpaqueAccessToken accessToken) {
        return Clock.currentTimeMillis() + 30000L >= TimeUnit.SECONDS.toMillis(accessToken.expiration().toEpochSecond());
    }
}

