/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.FindOption;
import jakarta.persistence.LockOption;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.RefreshOption;
import java.util.Locale;
import org.hibernate.Incubating;

@Incubating
public interface Locking {

    public static enum FollowOn implements FindOption,
    LockOption,
    RefreshOption
    {
        ALLOW,
        DISALLOW,
        IGNORE,
        FORCE;


        public static FollowOn interpret(String name) {
            if (name == null) {
                return null;
            }
            return FollowOn.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public Boolean asLegacyValue() {
            return switch (this.ordinal()) {
                case 3 -> true;
                case 1 -> false;
                default -> null;
            };
        }

        public static FollowOn fromLegacyValue(Boolean value) {
            if (value == Boolean.TRUE) {
                return FORCE;
            }
            if (value == Boolean.FALSE) {
                return DISALLOW;
            }
            return ALLOW;
        }
    }

    public static enum Scope implements FindOption,
    LockOption,
    RefreshOption
    {
        ROOT_ONLY,
        INCLUDE_COLLECTIONS,
        INCLUDE_FETCHES;


        public PessimisticLockScope getCorrespondingJpaScope() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> PessimisticLockScope.NORMAL;
                case 1 -> PessimisticLockScope.EXTENDED;
                case 2 -> null;
            };
        }

        public static Scope fromJpaScope(PessimisticLockScope scope) {
            if (scope == PessimisticLockScope.EXTENDED) {
                return INCLUDE_COLLECTIONS;
            }
            return ROOT_ONLY;
        }

        public static Scope interpret(String name) {
            if (name == null) {
                return null;
            }
            return Scope.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }
}

