/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TransactionState {
    EMPTY(0, org.apache.kafka.clients.admin.TransactionState.EMPTY.toString(), true),
    ONGOING(1, org.apache.kafka.clients.admin.TransactionState.ONGOING.toString(), false),
    PREPARE_COMMIT(2, org.apache.kafka.clients.admin.TransactionState.PREPARE_COMMIT.toString(), false),
    PREPARE_ABORT(3, org.apache.kafka.clients.admin.TransactionState.PREPARE_ABORT.toString(), false),
    COMPLETE_COMMIT(4, org.apache.kafka.clients.admin.TransactionState.COMPLETE_COMMIT.toString(), true),
    COMPLETE_ABORT(5, org.apache.kafka.clients.admin.TransactionState.COMPLETE_ABORT.toString(), true),
    DEAD(6, "Dead", false),
    PREPARE_EPOCH_FENCE(7, org.apache.kafka.clients.admin.TransactionState.PREPARE_EPOCH_FENCE.toString(), false);

    private static final Map<String, TransactionState> NAME_TO_ENUM;
    private static final Map<Byte, TransactionState> ID_TO_ENUM;
    public static final Set<TransactionState> ALL_STATES;
    private final byte id;
    private final String stateName;
    public static final Map<TransactionState, Set<TransactionState>> VALID_PREVIOUS_STATES;
    private final boolean expirationAllowed;

    private TransactionState(byte id, String name, boolean expirationAllowed) {
        this.id = id;
        this.stateName = name;
        this.expirationAllowed = expirationAllowed;
    }

    public byte id() {
        return this.id;
    }

    public String stateName() {
        return this.stateName;
    }

    public Set<TransactionState> validPreviousStates() {
        return VALID_PREVIOUS_STATES.getOrDefault((Object)this, Set.of());
    }

    public boolean isExpirationAllowed() {
        return this.expirationAllowed;
    }

    public static Optional<TransactionState> fromName(String name) {
        return Optional.ofNullable(NAME_TO_ENUM.get(name));
    }

    public static TransactionState fromId(byte id) {
        TransactionState state = ID_TO_ENUM.get(id);
        if (state == null) {
            throw new IllegalStateException("Unknown transaction state id " + id + " from the transaction status message");
        }
        return state;
    }

    static {
        NAME_TO_ENUM = Arrays.stream(TransactionState.values()).collect(Collectors.toUnmodifiableMap(TransactionState::stateName, Function.identity()));
        ID_TO_ENUM = Arrays.stream(TransactionState.values()).collect(Collectors.toUnmodifiableMap(TransactionState::id, Function.identity()));
        ALL_STATES = Set.copyOf(EnumSet.allOf(TransactionState.class));
        VALID_PREVIOUS_STATES = Map.of(EMPTY, Set.of(EMPTY, COMPLETE_COMMIT, COMPLETE_ABORT), ONGOING, Set.of(ONGOING, EMPTY, COMPLETE_COMMIT, COMPLETE_ABORT), PREPARE_COMMIT, Set.of(ONGOING), PREPARE_ABORT, Set.of(ONGOING, PREPARE_EPOCH_FENCE, EMPTY, COMPLETE_COMMIT, COMPLETE_ABORT), COMPLETE_COMMIT, Set.of(PREPARE_COMMIT), COMPLETE_ABORT, Set.of(PREPARE_ABORT), DEAD, Set.of(EMPTY, COMPLETE_ABORT, COMPLETE_COMMIT), PREPARE_EPOCH_FENCE, Set.of(ONGOING));
    }
}

