/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.event.MidiDeviceEvent;
import org.jsampler.event.MidiDeviceListener;
import org.jsampler.event.ParameterEvent;
import org.jsampler.event.ParameterListener;
import org.jsampler.task.Midi;
import org.jsampler.view.ParameterTable;
import org.jsampler.view.fantasia.DevicePane;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.Parameter;

public class MidiDevicePane
extends DevicePane {
    private final OptionsPane optionsPane;
    private final ParameterTable portParamTable = new ParameterTable();
    private MidiDeviceModel midiDeviceModel;

    public MidiDevicePane(MidiDeviceModel midiDeviceModel) {
        this.midiDeviceModel = midiDeviceModel;
        this.portParamTable.setFillsViewportHeight(true);
        this.optionsPane = new OptionsPane();
        this.setOptionsPane(this.optionsPane);
        int n = midiDeviceModel.getDeviceId();
        String string = midiDeviceModel.getDeviceInfo().getDriverName();
        this.setDeviceName(FantasiaI18n.i18n.getLabel("MidiDevicePane.lDevName", n, string));
    }

    @Override
    protected void destroyDevice() {
        final Midi.DestroyDevice destroyDevice = new Midi.DestroyDevice(this.midiDeviceModel.getDeviceId());
        destroyDevice.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (destroyDevice.doneWithErrors()) {
                    MidiDevicePane.this.restoreDevice();
                }
            }
        });
        CC.getTaskQueue().add(destroyDevice);
    }

    public int getDeviceId() {
        return this.midiDeviceModel.getDeviceId();
    }

    class OptionsPane
    extends PixmapPane
    implements ActionListener,
    ItemListener,
    ChangeListener,
    MidiDeviceListener,
    ParameterListener {
        private final JCheckBox checkActive;
        private final JLabel lPorts;
        private final JSpinner spinnerPorts;
        private final JLabel lPort;
        private final JComboBox cbPort;
        private final ParameterTable additionalParamsTable;
        private final JPanel additionalParamsPane;

        OptionsPane() {
            super(Res.gfxChannelOptions);
            this.checkActive = new JCheckBox(FantasiaI18n.i18n.getLabel("MidiDevicePane.checkActive"));
            this.lPorts = new JLabel(FantasiaI18n.i18n.getLabel("MidiDevicePane.lPorts"));
            this.lPort = new JLabel(FantasiaI18n.i18n.getLabel("MidiDevicePane.lPort"));
            this.cbPort = new JComboBox();
            this.additionalParamsTable = new ParameterTable();
            this.additionalParamsPane = new JPanel();
            this.setAlignmentX(0.0f);
            this.setPixmapInsets(new Insets(1, 1, 1, 1));
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setOpaque(false);
            PixmapPane pixmapPane = new PixmapPane(Res.gfxRoundBg7);
            pixmapPane.setPixmapInsets(new Insets(3, 3, 3, 3));
            pixmapPane.setOpaque(false);
            pixmapPane.setLayout(new BoxLayout(pixmapPane, 1));
            pixmapPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pixmapPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.checkActive);
            jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
            jPanel.add(this.lPorts);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            Parameter<Integer> parameter = MidiDevicePane.this.midiDeviceModel.getDeviceInfo().getPortsParameter();
            int n = 1;
            if (parameter.getRangeMin() != null) {
                n = parameter.getRangeMin().intValue();
            }
            int n2 = 50;
            if (parameter.getRangeMax() != null) {
                n2 = parameter.getRangeMax().intValue();
            }
            this.spinnerPorts = new JSpinner(new SpinnerNumberModel(1, n, n2, 1));
            if (parameter.isFixed()) {
                this.spinnerPorts.setEnabled(false);
            }
            jPanel.add(this.spinnerPorts);
            jPanel.setOpaque(false);
            pixmapPane.add(jPanel);
            pixmapPane.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel jPanel2 = this.additionalParamsPane;
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.setOpaque(false);
            jPanel2.add(MidiDevicePane.this.createHSeparator());
            jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
            JScrollPane jScrollPane = new JScrollPane(this.additionalParamsTable);
            jScrollPane.setPreferredSize(new Dimension(77, 90));
            jPanel2.add(jScrollPane);
            pixmapPane.add(jPanel2);
            pixmapPane.add(Box.createRigidArea(new Dimension(0, 5)));
            pixmapPane.add(MidiDevicePane.this.createHSeparator());
            pixmapPane.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setOpaque(false);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(this.lPort);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this.cbPort);
            jPanel2.setOpaque(false);
            jPanel.add(jPanel2);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            jScrollPane = new JScrollPane(MidiDevicePane.this.portParamTable);
            jScrollPane.setPreferredSize(new Dimension(77, 90));
            jPanel.add(jScrollPane);
            pixmapPane.add(jPanel);
            this.add(pixmapPane);
            this.checkActive.setSelected(MidiDevicePane.this.midiDeviceModel.isActive());
            this.spinnerPorts.setValue(MidiDevicePane.this.midiDeviceModel.getDeviceInfo().getMidiPortCount());
            this.cbPort.addActionListener(this);
            this.checkActive.addItemListener(this);
            this.spinnerPorts.addChangeListener(this);
            MidiDevicePane.this.midiDeviceModel.addMidiDeviceListener(this);
            MidiDevicePane.this.portParamTable.getModel().addParameterListener(this);
            for (MidiPort midiPort : MidiDevicePane.this.midiDeviceModel.getDeviceInfo().getMidiPorts()) {
                this.cbPort.addItem(midiPort);
            }
            Object[] objectArray = MidiDevicePane.this.midiDeviceModel.getDeviceInfo().getAdditionalParameters();
            this.additionalParamsTable.getModel().setParameters((Parameter[])objectArray);
            this.additionalParamsTable.getModel().addParameterListener(new ParameterListener(){

                @Override
                public void parameterChanged(ParameterEvent parameterEvent) {
                    MidiDevicePane.this.midiDeviceModel.setBackendDeviceParameter(parameterEvent.getParameter());
                }
            });
            this.updateAdditionalParamsViewState();
            String string = "MidiDevice.showAdditionalParameters";
            FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    OptionsPane.this.updateAdditionalParamsViewState();
                }
            });
        }

        private void updateAdditionalParamsViewState() {
            String string = "MidiDevice.showAdditionalParameters";
            this.additionalParamsPane.setVisible(FantasiaPrefs.preferences().getBoolProperty(string));
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.cbPort.getSelectedItem();
            if (object == null) {
                MidiDevicePane.this.portParamTable.getModel().setParameters(new Parameter[0]);
                return;
            }
            MidiPort midiPort = (MidiPort)object;
            MidiDevicePane.this.portParamTable.getModel().setParameters(midiPort.getAllParameters());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = this.checkActive.isSelected();
            if (bl != MidiDevicePane.this.midiDeviceModel.isActive()) {
                MidiDevicePane.this.midiDeviceModel.setBackendActive(bl);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = (Integer)this.spinnerPorts.getValue();
            if (n != MidiDevicePane.this.midiDeviceModel.getDeviceInfo().getMidiPortCount()) {
                MidiDevicePane.this.midiDeviceModel.setBackendPortCount(n);
            }
        }

        @Override
        public void settingsChanged(MidiDeviceEvent midiDeviceEvent) {
            boolean bl;
            boolean bl2;
            int n;
            int n2 = (Integer)this.spinnerPorts.getValue();
            if (n2 != (n = MidiDevicePane.this.midiDeviceModel.getDeviceInfo().getMidiPortCount())) {
                this.spinnerPorts.setValue(n);
            }
            if ((bl2 = this.checkActive.isSelected()) != (bl = MidiDevicePane.this.midiDeviceModel.isActive())) {
                this.checkActive.setSelected(bl);
            }
            MidiInputDevice midiInputDevice = midiDeviceEvent.getMidiDeviceModel().getDeviceInfo();
            Parameter[] parameterArray = midiInputDevice.getAdditionalParameters();
            this.additionalParamsTable.getModel().setParameters(parameterArray);
            int n3 = this.cbPort.getSelectedIndex();
            this.cbPort.removeAllItems();
            for (MidiPort midiPort : midiInputDevice.getMidiPorts()) {
                this.cbPort.addItem(midiPort);
            }
            if (n3 >= this.cbPort.getModel().getSize()) {
                n3 = 0;
            }
            if (this.cbPort.getModel().getSize() > 0) {
                this.cbPort.setSelectedIndex(n3);
            }
        }

        @Override
        public void parameterChanged(ParameterEvent parameterEvent) {
            int n = this.cbPort.getSelectedIndex();
            if (n == -1) {
                CC.getLogger().warning("There is no MIDI port selected!");
                return;
            }
            MidiDevicePane.this.midiDeviceModel.setBackendPortParameter(n, parameterEvent.getParameter());
        }
    }
}

