/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.local.LazyLocallyAvailableResourceCandidates;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class AbstractLocallyAvailableResourceFinder<C>
implements LocallyAvailableResourceFinder<C> {
    private final Function<C, Factory<List<File>>> producer;
    private final ChecksumService checksumService;

    public AbstractLocallyAvailableResourceFinder(Function<C, Factory<List<File>>> producer, ChecksumService checksumService) {
        this.producer = producer;
        this.checksumService = checksumService;
    }

    @Override
    public LocallyAvailableResourceCandidates findCandidates(C criterion) {
        return new LazyLocallyAvailableResourceCandidates(this.producer.apply(criterion), this.checksumService);
    }

    public ChecksumService getChecksumService() {
        return this.checksumService;
    }
}

