/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optionals;
import com.tngtech.archunit.core.Convertible;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaParameter;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ComparisonChain;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public class Dependency
implements HasDescription,
Comparable<Dependency>,
HasSourceCodeLocation,
Convertible {
    private final JavaClass originClass;
    private final JavaClass targetClass;
    private final String description;
    private final SourceCodeLocation sourceCodeLocation;
    private final int hashCode;

    private Dependency(JavaClass originClass, JavaClass targetClass, SourceCodeLocation sourceCodeLocation, String description) {
        Preconditions.checkArgument(!originClass.equals(targetClass) || targetClass.isPrimitive(), "Tried to create illegal dependency '%s' (%s -> %s), this is likely a bug!", (Object)description, (Object)originClass.getSimpleName(), (Object)targetClass.getSimpleName());
        this.originClass = originClass;
        this.targetClass = targetClass;
        this.description = description;
        this.sourceCodeLocation = sourceCodeLocation;
        this.hashCode = Objects.hash(originClass, targetClass, sourceCodeLocation, description);
    }

    static Set<Dependency> tryCreateFromAccess(JavaAccess<?> access) {
        JavaClass originOwner = access.getOriginOwner();
        JavaClass targetOwner = access.getTargetOwner();
        ImmutableCollection.Builder dependencies = ImmutableSet.builder().addAll(Dependency.createComponentTypeDependencies(originOwner, access.getOrigin().getDescription(), targetOwner, access.getSourceCodeLocation()));
        if (!originOwner.equals(targetOwner) && !targetOwner.isPrimitive()) {
            ((ImmutableSet.Builder)dependencies).add(new FromAccess(access));
        }
        return ((ImmutableSet.Builder)dependencies).build();
    }

    static Dependency fromInheritance(JavaClass origin, JavaClass targetSupertype) {
        String originType = origin.isInterface() ? "Interface" : "Class";
        String originDescription = originType + " " + Dependency.bracketFormat(origin.getName());
        String dependencyType = !origin.isInterface() && targetSupertype.isInterface() ? "implements" : "extends";
        String targetType = targetSupertype.isInterface() ? "interface" : "class";
        String targetDescription = Dependency.bracketFormat(targetSupertype.getName());
        String dependencyDescription = originDescription + " " + dependencyType + " " + targetType + " " + targetDescription;
        String description = dependencyDescription + " in " + origin.getSourceCodeLocation();
        Optional<Dependency> result = Dependency.tryCreateDependency(origin, targetSupertype, description, origin.getSourceCodeLocation());
        if (!result.isPresent()) {
            throw new IllegalStateException(String.format("Tried to create illegal inheritance dependency '%s' (%s -> %s), this is likely a bug!", description, origin.getSimpleName(), targetSupertype.getSimpleName()));
        }
        return result.get();
    }

    static Set<Dependency> tryCreateFromField(JavaField field) {
        return Dependency.tryCreateDependency(field, "has type", field.getRawType());
    }

    static Set<Dependency> tryCreateFromReturnType(JavaMethod method) {
        return Dependency.tryCreateDependency(method, "has return type", method.getRawReturnType());
    }

    static Set<Dependency> tryCreateFromParameter(JavaCodeUnit codeUnit, JavaClass parameter) {
        return Dependency.tryCreateDependency(codeUnit, "has parameter of type", parameter);
    }

    static Set<Dependency> tryCreateFromThrowsDeclaration(ThrowsDeclaration<? extends JavaCodeUnit> declaration) {
        return Dependency.tryCreateDependency(declaration.getLocation(), "throws type", declaration.getRawType());
    }

    static Set<Dependency> tryCreateFromInstanceofCheck(InstanceofCheck instanceofCheck) {
        return Dependency.tryCreateDependency(instanceofCheck.getOwner(), "checks instanceof", instanceofCheck.getRawType(), instanceofCheck.getSourceCodeLocation());
    }

    static Set<Dependency> tryCreateFromReferencedClassObject(ReferencedClassObject referencedClassObject) {
        return Dependency.tryCreateDependency(referencedClassObject.getOwner(), "references class object", referencedClassObject.getRawType(), referencedClassObject.getSourceCodeLocation());
    }

    static Set<Dependency> tryCreateFromAnnotation(JavaAnnotation<?> target) {
        Origin origin = Dependency.findSuitableOrigin(target, target.getAnnotatedElement());
        return Dependency.tryCreateDependency(origin, "is annotated with", target.getRawType());
    }

    static Set<Dependency> tryCreateFromAnnotationMember(JavaAnnotation<?> annotation, JavaClass memberType) {
        Origin origin = Dependency.findSuitableOrigin(annotation, annotation.getAnnotatedElement());
        return Dependency.tryCreateDependency(origin, "has annotation member of type", memberType);
    }

    static Set<Dependency> tryCreateFromTypeParameter(JavaTypeVariable<?> typeParameter, JavaClass typeParameterDependency) {
        String dependencyType = "has type parameter '" + typeParameter.getName() + "' depending on";
        Origin origin = Dependency.findSuitableOrigin(typeParameter, typeParameter.getOwner());
        return Dependency.tryCreateDependency(origin, dependencyType, typeParameterDependency);
    }

    static Set<Dependency> tryCreateFromGenericSuperclassTypeArguments(JavaClass originClass, JavaType superclass, JavaClass typeArgumentDependency) {
        return Dependency.tryCreateDependency(originClass, Dependency.genericDependencyType("superclass", superclass), typeArgumentDependency);
    }

    static Set<Dependency> tryCreateFromGenericInterfaceTypeArgument(JavaClass originClass, JavaType genericInterface, JavaClass typeArgumentDependency) {
        return Dependency.tryCreateDependency(originClass, Dependency.genericDependencyType("interface", genericInterface), typeArgumentDependency);
    }

    static Set<Dependency> tryCreateFromGenericFieldTypeArgument(JavaField origin, JavaClass typeArgumentDependency) {
        return Dependency.tryCreateDependency(origin, Dependency.genericDependencyType("type", origin.getType()), typeArgumentDependency);
    }

    static Set<Dependency> tryCreateFromGenericMethodReturnTypeArgument(JavaMethod origin, JavaClass typeArgumentDependency) {
        return Dependency.tryCreateDependency(origin, Dependency.genericDependencyType("return type", origin.getReturnType()), typeArgumentDependency);
    }

    static Set<Dependency> tryCreateFromGenericCodeUnitParameterTypeArgument(JavaCodeUnit origin, JavaType parameterType, JavaClass typeArgumentDependency) {
        return Dependency.tryCreateDependency(origin, Dependency.genericDependencyType("parameter type", parameterType), typeArgumentDependency);
    }

    private static String genericDependencyType(String genericTypeDescription, JavaType genericType) {
        return "has generic " + genericTypeDescription + " " + Dependency.bracketFormat(genericType.getName()) + " with type argument depending on";
    }

    private static Origin findSuitableOrigin(Object dependencyCause, Object originCandidate) {
        if (originCandidate instanceof JavaMember) {
            JavaMember member = (JavaMember)originCandidate;
            return new Origin(member.getOwner(), member.getDescription());
        }
        if (originCandidate instanceof JavaClass) {
            JavaClass clazz = (JavaClass)originCandidate;
            return new Origin(clazz, clazz.getDescription());
        }
        if (originCandidate instanceof JavaParameter) {
            JavaParameter parameter = (JavaParameter)originCandidate;
            return new Origin(parameter.getOwner().getOwner(), parameter.getDescription());
        }
        throw new IllegalStateException("Could not find suitable dependency origin for " + dependencyCause);
    }

    private static Set<Dependency> tryCreateDependency(JavaClass origin, String dependencyType, JavaClass targetClass) {
        return Dependency.tryCreateDependency(origin, origin.getDescription(), dependencyType, targetClass, origin.getSourceCodeLocation());
    }

    private static <T extends HasOwner<JavaClass> & HasDescription> Set<Dependency> tryCreateDependency(T origin, String dependencyType, JavaClass targetClass) {
        return Dependency.tryCreateDependency(origin, dependencyType, targetClass, origin.getOwner().getSourceCodeLocation());
    }

    private static <T extends HasOwner<JavaClass> & HasDescription> Set<Dependency> tryCreateDependency(T origin, String dependencyType, JavaClass targetClass, SourceCodeLocation sourceCodeLocation) {
        return Dependency.tryCreateDependency(origin.getOwner(), ((HasDescription)origin).getDescription(), dependencyType, targetClass, sourceCodeLocation);
    }

    private static Set<Dependency> tryCreateDependency(JavaClass originClass, String originDescription, String dependencyType, JavaClass targetClass, SourceCodeLocation sourceCodeLocation) {
        ImmutableCollection.Builder dependencies = ImmutableSet.builder().addAll(Dependency.createComponentTypeDependencies(originClass, originDescription, targetClass, sourceCodeLocation));
        String targetDescription = Dependency.bracketFormat(targetClass.getName());
        String dependencyDescription = originDescription + " " + dependencyType + " " + targetDescription;
        String description = dependencyDescription + " in " + sourceCodeLocation;
        ((ImmutableSet.Builder)dependencies).addAll(Optionals.asSet(Dependency.tryCreateDependency(originClass, targetClass, description, sourceCodeLocation)));
        return ((ImmutableSet.Builder)dependencies).build();
    }

    private static Set<Dependency> createComponentTypeDependencies(JavaClass originClass, String originDescription, JavaClass targetClass, SourceCodeLocation sourceCodeLocation) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Optional<JavaClass> componentType = targetClass.tryGetComponentType();
        while (componentType.isPresent()) {
            String componentTypeTargetDescription = Dependency.bracketFormat(componentType.get().getName());
            String componentTypeDependencyDescription = originDescription + " depends on component type " + componentTypeTargetDescription;
            String componentTypeDescription = componentTypeDependencyDescription + " in " + sourceCodeLocation;
            result.addAll(Optionals.asSet(Dependency.tryCreateDependency(originClass, componentType.get(), componentTypeDescription, sourceCodeLocation)));
            componentType = componentType.get().tryGetComponentType();
        }
        return result.build();
    }

    private static Optional<Dependency> tryCreateDependency(JavaClass originClass, JavaClass targetClass, String description, SourceCodeLocation sourceCodeLocation) {
        if (originClass.equals(targetClass) || targetClass.isPrimitive()) {
            return Optional.empty();
        }
        return Optional.of(new Dependency(originClass, targetClass, sourceCodeLocation, description));
    }

    private static String bracketFormat(String name) {
        return "<" + name + ">";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOriginClass() {
        return this.originClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getTargetClass() {
        return this.targetClass;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return this.description;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Override
    public <T> Set<T> convertTo(Class<T> type) {
        if (type.isAssignableFrom(Dependency.class)) {
            return Collections.singleton(this);
        }
        return Collections.emptySet();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int compareTo(Dependency o) {
        return ComparisonChain.start().compare(this.sourceCodeLocation.getLineNumber(), o.sourceCodeLocation.getLineNumber()).compare((Comparable<?>)((Object)this.getDescription()), (Comparable<?>)((Object)o.getDescription())).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return Objects.equals(this.originClass, other.originClass) && Objects.equals(this.targetClass, other.targetClass) && Objects.equals(this.sourceCodeLocation.getLineNumber(), other.sourceCodeLocation.getLineNumber()) && Objects.equals(this.description, other.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("originClass", this.originClass).add("targetClass", this.targetClass).add("sourceCodeLocation", this.sourceCodeLocation).add("description", this.description).toString();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static JavaClasses toTargetClasses(Iterable<Dependency> dependencies) {
        HashSet<JavaClass> classes = new HashSet<JavaClass>();
        for (Dependency dependency : dependencies) {
            classes.add(dependency.getTargetClass());
        }
        return JavaClasses.of(classes);
    }

    private static class FromAccess
    extends Dependency {
        private final JavaAccess<?> access;

        FromAccess(JavaAccess<?> access) {
            super(access.getOriginOwner(), access.getTargetOwner(), access.getSourceCodeLocation(), access.getDescription());
            this.access = access;
        }

        @Override
        public <T> Set<T> convertTo(Class<T> type) {
            if (type.isAssignableFrom(this.getClass())) {
                return Collections.singleton(this);
            }
            if (type.isAssignableFrom(this.access.getClass())) {
                return Collections.singleton(this.access);
            }
            return super.convertTo(type);
        }

        @Override
        public int hashCode() {
            return this.access.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FromAccess other = (FromAccess)obj;
            return Objects.equals(this.access, other.access);
        }

        @Override
        public String toString() {
            return this.getClass().getEnclosingClass().getSimpleName() + "." + super.toString();
        }
    }

    private static class Origin
    implements HasOwner<JavaClass>,
    HasDescription {
        private final JavaClass originClass;
        private final String originDescription;

        private Origin(JavaClass originClass, String originDescription) {
            this.originClass = originClass;
            this.originDescription = originDescription;
        }

        @Override
        public JavaClass getOwner() {
            return this.originClass;
        }

        @Override
        public String getDescription() {
            return this.originDescription;
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<Dependency, JavaClass> GET_ORIGIN_CLASS = new ChainableFunction<Dependency, JavaClass>(){

            @Override
            public JavaClass apply(Dependency input) {
                return input.getOriginClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<Dependency, JavaClass> GET_TARGET_CLASS = new ChainableFunction<Dependency, JavaClass>(){

            @Override
            public JavaClass apply(Dependency input) {
                return input.getTargetClass();
            }
        };

        private Functions() {
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependency(Class<?> originClass, Class<?> targetClass) {
            return Predicates.dependencyOrigin(originClass).and(Predicates.dependencyTarget(targetClass)).as("dependency %s -> %s", originClass.getName(), targetClass.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependency(String originClassName, String targetClassName) {
            return Predicates.dependencyOrigin(originClassName).and(Predicates.dependencyTarget(targetClassName)).as("dependency %s -> %s", originClassName, targetClassName);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependency(DescribedPredicate<? super JavaClass> originPredicate, DescribedPredicate<? super JavaClass> targetPredicate) {
            return Predicates.dependencyOrigin(originPredicate).and(Predicates.dependencyTarget(targetPredicate)).as("dependency %s -> %s", originPredicate.getDescription(), targetPredicate.getDescription());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyOrigin(Class<?> clazz) {
            return Predicates.dependencyOrigin(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyOrigin(String className) {
            return Predicates.dependencyOrigin(HasName.Predicates.name(className).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyOrigin(DescribedPredicate<? super JavaClass> predicate) {
            return Functions.GET_ORIGIN_CLASS.is(predicate).as("origin " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyTarget(Class<?> clazz) {
            return Predicates.dependencyTarget(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyTarget(String className) {
            return Predicates.dependencyTarget(HasName.Predicates.name(className).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyTarget(DescribedPredicate<? super JavaClass> predicate) {
            return Functions.GET_TARGET_CLASS.is(predicate).as("target " + predicate.getDescription(), new Object[0]);
        }
    }
}

