/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.AuxiliarySplitPanes;
import org.freeplane.main.application.AuxillaryEditorSplitPane;
import org.freeplane.main.application.BorderLayoutWithVisibleCenterComponent;
import org.freeplane.main.application.Browser;
import org.freeplane.main.application.FrameComponentMover;
import org.freeplane.main.application.MapViewDockingWindows;
import org.freeplane.main.application.NavigationMapNextViewAction;
import org.freeplane.main.application.NavigationMapPreviousViewAction;
import org.freeplane.main.application.NavigationNextMapAction;
import org.freeplane.main.application.NavigationPreviousMapAction;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.overview.BookmarkToolbarPane;

class ApplicationViewController
extends FrameController {
    private final JFrame mainFrame;
    private final NavigationNextMapAction navigationNextMap;
    private final NavigationPreviousMapAction navigationPreviousMap;
    private MapViewDockingWindows mapViewWindows;
    private final Map<Window, BookmarkToolbarPane> bookmarkToolbarPanes = new HashMap<Window, BookmarkToolbarPane>();
    private final FrameComponentMover frameComponentMover;

    private static Image frameIcon(String size) {
        return new ImageIcon(ResourceController.getResourceController().getResource("/images/Freeplane_frame_icon_" + size + ".png")).getImage();
    }

    public ApplicationViewController(Controller controller, IMapViewManager mapViewController, JFrame frame, FrameComponentMover frameComponentMover) {
        super(controller, mapViewController, "");
        this.navigationPreviousMap = new NavigationPreviousMapAction();
        controller.addAction((AFreeplaneAction)this.navigationPreviousMap);
        this.navigationNextMap = new NavigationNextMapAction();
        controller.addAction((AFreeplaneAction)this.navigationNextMap);
        controller.addAction((AFreeplaneAction)new NavigationMapNextViewAction());
        controller.addAction((AFreeplaneAction)new NavigationMapPreviousViewAction());
        this.mainFrame = frame;
        this.frameComponentMover = frameComponentMover;
    }

    public void changeNoteWindowLocation(String location) {
        AuxiliarySplitPanes splitPanes = this.getSplitPanes();
        if (splitPanes != null) {
            splitPanes.changeAuxComponentSide(0, location);
        }
    }

    public FreeplaneMenuBar getFreeplaneMenuBar() {
        return Controller.getCurrentModeController().getUserInputListenerFactory().getMenuBar();
    }

    public void insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        AuxiliarySplitPanes splitPanes = this.getSplitPanes();
        if (splitPanes != null) {
            splitPanes.insertComponentIntoSplitPane(0, pMindMapComponent, Controller.getCurrentModeController().getModeName());
        }
    }

    private AuxillaryEditorSplitPane getSplitPane() {
        Component currentRootComponent = this.getCurrentRootComponent();
        if (currentRootComponent instanceof RootPaneContainer) {
            return this.getSplitPane((RootPaneContainer)((Object)currentRootComponent));
        }
        return null;
    }

    private AuxiliarySplitPanes getSplitPanes() {
        AuxillaryEditorSplitPane splitPane = this.getSplitPane();
        return splitPane != null ? splitPane.getManager() : null;
    }

    public AuxillaryEditorSplitPane getSplitPane(RootPaneContainer topLevelAncestor) {
        Container contentPane = ((JFrame)topLevelAncestor).getContentPane();
        Component centerComponent = ((BorderLayout)contentPane.getLayout()).getLayoutComponent("Center");
        if (centerComponent instanceof AuxillaryEditorSplitPane) {
            return (AuxillaryEditorSplitPane)centerComponent;
        }
        return null;
    }

    void createAuxillaryPaneForFloatingWindow(Window frame, Component rootWindow) {
        if (frame instanceof JFrame) {
            JFrame jFrame = (JFrame)frame;
            Container contentPane = jFrame.getContentPane();
            Component centralComponent = null;
            if (contentPane.getLayout() instanceof BorderLayout) {
                centralComponent = ((BorderLayout)contentPane.getLayout()).getLayoutComponent("Center");
            }
            BookmarkToolbarPane bookmarkToolbarPane = new BookmarkToolbarPane(rootWindow);
            AuxiliarySplitPanes splitPanes = new AuxiliarySplitPanes((Component)bookmarkToolbarPane);
            AuxillaryEditorSplitPane splitPane = splitPanes.getRootPane();
            this.bookmarkToolbarPanes.put(frame, bookmarkToolbarPane);
            if (centralComponent != null) {
                contentPane.remove(centralComponent);
            }
            contentPane.setLayout(new BorderLayoutWithVisibleCenterComponent());
            contentPane.add((Component)splitPane, "Center");
            this.insertActiveComponentsIntoSplitPane(splitPane, frame);
        }
    }

    private void insertActiveComponentsIntoSplitPane(AuxillaryEditorSplitPane splitPane, Window frame) {
    }

    void removeAuxillaryPaneForFloatingWindow(Window frame) {
        BookmarkToolbarPane bookmarkToolbarPane = this.bookmarkToolbarPanes.remove(frame);
        if (bookmarkToolbarPane != null) {
            bookmarkToolbarPane.dispose();
        }
    }

    public void openDocument(Hyperlink link) throws IOException {
        new Browser().openDocument(link);
    }

    public void openDocument(URL url) throws Exception {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), url.getRef());
        }
        this.openDocument(new Hyperlink(uri));
    }

    public boolean quit() {
        if (!super.quit()) {
            return false;
        }
        this.controller.fireApplicationStopped();
        this.mainFrame.dispose();
        return true;
    }

    public void removeAuxiliaryComponent() {
        AuxiliarySplitPanes splitPanes = this.getSplitPanes();
        if (splitPanes != null) {
            splitPanes.removeAuxiliaryComponent(0);
        }
    }

    public void saveProperties() {
        if (this.mapViewWindows == null) {
            return;
        }
        ApplicationResourceController resourceController = (ApplicationResourceController)ResourceController.getResourceController();
        if (this.mainFrame.isResizable()) {
            int winState = this.mainFrame.getExtendedState() & 0xFFFFFFFE;
            if (6 != (winState & 6)) {
                resourceController.setProperty("appwindow_x", String.valueOf(this.mainFrame.getX()));
                resourceController.setProperty("appwindow_y", String.valueOf(this.mainFrame.getY()));
                resourceController.setProperty("appwindow_width", String.valueOf(this.mainFrame.getWidth()));
                resourceController.setProperty("appwindow_height", String.valueOf(this.mainFrame.getHeight()));
            }
            resourceController.setProperty("appwindow_state", String.valueOf(winState));
        }
        this.mapViewWindows.saveLayout();
        resourceController.getLastOpenedList().saveProperties();
    }

    protected void setFreeplaneMenuBar(FreeplaneMenuBar menuBar) {
        JFrame menuComponent = this.getMenuComponent();
        if (!menuComponent.isVisible()) {
            return;
        }
        if (Compat.isMacOsX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            menuComponent.setJMenuBar((JMenuBar)menuBar);
            System.setProperty("apple.laf.useScreenMenuBar", "false");
        } else {
            menuComponent.setJMenuBar((JMenuBar)menuBar);
        }
    }

    public void setTitle(String frameTitle) {
        this.mainFrame.setTitle(frameTitle);
        this.mapViewWindows.setTitle();
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.mainFrame.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.mainFrame.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.mainFrame.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.mainFrame.getRootPane().getGlassPane().setVisible(false);
        }
    }

    public void viewNumberChanged(int number) {
        this.navigationPreviousMap.setEnabled(number > 1);
        this.navigationNextMap.setEnabled(number > 1);
    }

    public void init(Controller controller) {
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mapViewWindows = new MapViewDockingWindows(this);
        BookmarkToolbarPane mainBookmarkToolbarPane = new BookmarkToolbarPane((Component)this.mapViewWindows.getRootWindow());
        AuxiliarySplitPanes splitPanes = new AuxiliarySplitPanes((Component)mainBookmarkToolbarPane);
        AuxillaryEditorSplitPane splitPane = splitPanes.getRootPane();
        splitPane.setResizeWeight(1.0);
        Container contentPane = this.mainFrame.getContentPane();
        contentPane.setLayout(new BorderLayoutWithVisibleCenterComponent());
        contentPane.add((Component)splitPane, "Center");
        this.initFrame(this.mainFrame);
        super.init(controller);
    }

    private void initFrame(JFrame frame) {
        if (!Compat.isMacOsX()) {
            frame.setIconImages(Arrays.asList(ApplicationViewController.frameIcon("16x16"), ApplicationViewController.frameIcon("32x32"), ApplicationViewController.frameIcon("64x64"), ApplicationViewController.frameIcon("128x128"), ApplicationViewController.frameIcon("256x256"), ApplicationViewController.frameIcon("512x512")));
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Controller.getCurrentController().quit();
            }
        });
        frame.setFocusTraversalKeysEnabled(false);
        int win_width = ResourceController.getResourceController().getIntProperty("appwindow_width", -1);
        int win_height = ResourceController.getResourceController().getIntProperty("appwindow_height", -1);
        int win_x = ResourceController.getResourceController().getIntProperty("appwindow_x", -1);
        int win_y = ResourceController.getResourceController().getIntProperty("appwindow_y", -1);
        Rectangle frameBounds = UITools.getValidFrameBounds((Component)frame, (int)win_x, (int)win_y, (int)win_width, (int)win_height);
        frame.setBounds(frameBounds);
        frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        int win_state = Integer.parseInt(ResourceController.getResourceController().getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        frame.setExtendedState(win_state);
        Compat.registerFullScreenListener((JFrame)frame);
    }

    public void openMapsOnStart() {
        this.mapViewWindows.loadLayout();
    }

    public void focusTo(MapView currentMapView, Runnable onFocus) {
        this.mapViewWindows.focusMapViewLater(currentMapView, onFocus);
    }

    public void previousMapView() {
        this.mapViewWindows.selectPreviousMapView();
    }

    public void nextMapView() {
        this.mapViewWindows.selectNextMapView();
    }

    public void setFullScreen(JFrame frame, boolean fullScreen) {
        super.setFullScreen(frame, fullScreen);
        this.mapViewWindows.setTabAreaVisiblePolicy(frame, !fullScreen);
    }

    public Component getCurrentRootComponent() {
        JComponent mapViewComponent = this.selectedMapView();
        if (mapViewComponent == null) {
            return this.mainFrame;
        }
        Component rootComponent = SwingUtilities.getRoot(mapViewComponent);
        if (rootComponent != null) {
            return rootComponent;
        }
        return this.mainFrame;
    }

    public JFrame getMainFrameComponent() {
        return this.mainFrame;
    }

    public JFrame getMenuComponent() {
        return this.mainFrame.getMenuBar() != null ? this.mainFrame : this.frameComponentMover.getUIFrame();
    }

    public List<? extends Component> getMapViewVector() {
        return this.mapViewWindows != null ? this.mapViewWindows.getMapViewVector() : null;
    }

    public void openMapNextView() {
        this.mapViewWindows.selectMapNextView(this.selectedMapView());
    }

    public void openMapPreviousView() {
        this.mapViewWindows.selectMapPreviousView(this.selectedMapView());
    }

    private JComponent selectedMapView() {
        return this.controller.getMapViewManager().getMapViewComponent();
    }
}

