/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.Collections;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public abstract class SQLQuerySymbolOrigin {
    public abstract boolean isChained();

    public abstract void apply(Visitor var1);

    public boolean isApplicable(@NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult) {
        return true;
    }

    public static class ColumnNameFromRowsData
    extends RowsDataRef {
        public ColumnNameFromRowsData(@NotNull SQLQueryRowsDataContext dataContext) {
            super(dataContext);
        }

        @Override
        public boolean isApplicable(@NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult) {
            return syntaxInspectionResult.expectingColumnName();
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitColumnNameFromRowsData(this);
        }
    }

    public static class ColumnRefFromReferencedContext
    extends SQLQuerySymbolOrigin {
        private final SourceResolutionResult referencedSource;

        public ColumnRefFromReferencedContext(SourceResolutionResult referencedSource) {
            this.referencedSource = referencedSource;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        public SourceResolutionResult getRowsSource() {
            return this.referencedSource;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitColumnRefFromReferencedContext(this);
        }
    }

    public static enum DbObjectFilterMode {
        DEFAULT,
        ROWSET,
        VALUE,
        FUNCTION,
        TABLE,
        OBJECT;

    }

    public static class DbObjectFromDbObject
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final DBSObject object;
        @NotNull
        private final Set<DBSObjectType> objectTypes;
        @NotNull
        private final SQLQueryRowsSourceContext rowsContext;
        @NotNull
        private final DbObjectFilterMode filterMode;

        public DbObjectFromDbObject(@NotNull DBSObject object, @NotNull SQLQueryRowsSourceContext rowsContext, @NotNull DbObjectFilterMode filterMode) {
            this.object = object;
            this.objectTypes = Collections.emptySet();
            this.rowsContext = rowsContext;
            this.filterMode = filterMode;
        }

        @NotNull
        public DBSObject getObject() {
            return this.object;
        }

        @NotNull
        public Set<DBSObjectType> getMemberTypes() {
            return this.objectTypes;
        }

        @NotNull
        public SQLQueryRowsSourceContext getRowsContext() {
            return this.rowsContext;
        }

        @NotNull
        public DbObjectFilterMode getFilterMode() {
            return this.filterMode;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitDbObjectFromDbObject(this);
        }
    }

    public static class DbObjectRef
    extends RowsSourceRef {
        @NotNull
        private final Set<DBSObjectType> objectTypes;
        private final boolean includingRowsets;

        public DbObjectRef(@NotNull SQLQueryRowsSourceContext rowsSourceContext, @NotNull DBSObjectType objectType) {
            this(rowsSourceContext, Set.of(objectType), false);
        }

        public DbObjectRef(@NotNull SQLQueryRowsSourceContext rowsSourceContext, @NotNull Set<DBSObjectType> objectTypes, boolean includingRowsets) {
            super(rowsSourceContext);
            this.objectTypes = objectTypes;
            this.includingRowsets = includingRowsets;
        }

        @NotNull
        public Set<DBSObjectType> getObjectTypes() {
            return this.objectTypes;
        }

        public boolean isIncludingRowsets() {
            return this.includingRowsets;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitDbObjectRef(this);
        }
    }

    public static class ExpandableRowsTupleRef
    extends RowsDataRef {
        @NotNull
        private final STMTreeNode placeholder;
        @Nullable
        private final SourceResolutionResult referencedSource;

        public ExpandableRowsTupleRef(@NotNull STMTreeNode placeholder, @NotNull SQLQueryRowsDataContext dataContext, @Nullable SourceResolutionResult referencedSource) {
            super(dataContext);
            this.placeholder = placeholder;
            this.referencedSource = referencedSource;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @Override
        public boolean isApplicable(@NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult) {
            return true;
        }

        @NotNull
        public STMTreeNode getPlaceholder() {
            return this.placeholder;
        }

        @Nullable
        public SourceResolutionResult getReferencedSource() {
            return this.referencedSource;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitExpandableRowsTupleRef(this);
        }
    }

    public static class MemberOfType
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final SQLQueryExprType type;

        public MemberOfType(@NotNull SQLQueryExprType type) {
            this.type = type;
        }

        @NotNull
        public final SQLQueryExprType getType() {
            return this.type;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitMemberOfType(this);
        }
    }

    public static class RowsDataRef
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final SQLQueryRowsDataContext rowsDataContext;

        public RowsDataRef(@NotNull SQLQueryRowsDataContext rowsDataContext) {
            this.rowsDataContext = rowsDataContext;
        }

        @Override
        public boolean isChained() {
            return false;
        }

        @Override
        public boolean isApplicable(@NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult) {
            return syntaxInspectionResult.expectingColumnReference();
        }

        @NotNull
        public SQLQueryRowsDataContext getRowsDataContext() {
            return this.rowsDataContext;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitRowsDataRef(this);
        }
    }

    public static class RowsSourceRef
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final SQLQueryRowsSourceContext rowsSourceContext;

        public RowsSourceRef(@NotNull SQLQueryRowsSourceContext rowsSourceContext) {
            this.rowsSourceContext = rowsSourceContext;
        }

        @Override
        public boolean isChained() {
            return false;
        }

        @Override
        public boolean isApplicable(@NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult) {
            return syntaxInspectionResult.expectingTableReference();
        }

        @NotNull
        public SQLQueryRowsSourceContext getRowsSourceContext() {
            return this.rowsSourceContext;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitRowsSourceRef(this);
        }
    }

    public static class SyntaxBasedFromRowsData
    extends RowsDataRef {
        public SyntaxBasedFromRowsData(@NotNull SQLQueryRowsDataContext dataContext) {
            super(dataContext);
        }

        @Override
        public boolean isApplicable(@NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult) {
            return true;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitSyntaxBasedFromRowsData(this);
        }
    }

    public static interface Visitor {
        public void visitDbObjectFromDbObject(DbObjectFromDbObject var1);

        public void visitDbObjectRef(DbObjectRef var1);

        public void visitColumnRefFromReferencedContext(ColumnRefFromReferencedContext var1);

        public void visitMemberOfType(MemberOfType var1);

        public void visitRowsSourceRef(RowsSourceRef var1);

        public void visitRowsDataRef(RowsDataRef var1);

        public void visitExpandableRowsTupleRef(ExpandableRowsTupleRef var1);

        public void visitColumnNameFromRowsData(ColumnNameFromRowsData var1);

        public void visitSyntaxBasedFromRowsData(SyntaxBasedFromRowsData var1);
    }
}

