/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;

public final class EmptySequenceStorage
extends SequenceStorage {
    public static final EmptySequenceStorage INSTANCE = new EmptySequenceStorage();

    public ArrayBasedSequenceStorage generalizeFor(Object value) {
        ArrayBasedSequenceStorage generalized = value instanceof Byte ? new ByteSequenceStorage(16) : (value instanceof Boolean ? new BoolSequenceStorage(16) : (value instanceof Integer ? new IntSequenceStorage() : (value instanceof Long ? new LongSequenceStorage() : (value instanceof Double ? new DoubleSequenceStorage() : new ObjectSequenceStorage(PythonUtils.EMPTY_OBJECT_ARRAY)))));
        return generalized;
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Empty;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "EmptySequenceStorage[]";
    }
}

