/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.regex.RegexSource;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexSyntaxException
extends AbstractTruffleException {
    private final SourceSection sourceSection;
    private final ErrorCode errorCode;
    private static final long serialVersionUID = 1L;

    public static RegexSyntaxException createOptions(Source source, String msg, int position) {
        return new RegexSyntaxException(msg, source, position, ErrorCode.InvalidOption);
    }

    public static RegexSyntaxException createPattern(RegexSource source, String msg, int position, ErrorCode errorCode) {
        return new RegexSyntaxException(msg, RegexSyntaxException.patternSource(source), position, errorCode);
    }

    public static RegexSyntaxException createFlags(RegexSource source, String msg) {
        return new RegexSyntaxException(msg, RegexSyntaxException.flagsSource(source), 0, ErrorCode.InvalidFlag);
    }

    public static RegexSyntaxException createFlags(RegexSource source, String msg, int position) {
        return new RegexSyntaxException(msg, RegexSyntaxException.flagsSource(source), position, ErrorCode.InvalidFlag);
    }

    @CompilerDirectives.TruffleBoundary
    private static Source patternSource(RegexSource regexSource) {
        String src = regexSource.getSource().getCharacters().toString();
        int firstPos = src.indexOf(47) + 1;
        int lastPos = src.lastIndexOf(47);
        assert (firstPos > 0);
        assert (lastPos > firstPos);
        return regexSource.getSource().subSource(firstPos, lastPos - firstPos);
    }

    @CompilerDirectives.TruffleBoundary
    private static Source flagsSource(RegexSource regexSource) {
        String src = regexSource.getSource().getCharacters().toString();
        int lastPos = src.lastIndexOf(47) + 1;
        assert (lastPos > 0);
        return regexSource.getSource().subSource(lastPos, src.length() - lastPos);
    }

    @CompilerDirectives.TruffleBoundary
    private RegexSyntaxException(String reason, Source src, int position, ErrorCode errorCode) {
        super(reason);
        assert (position <= src.getLength());
        this.sourceSection = src.createSection(position, src.getLength() - position);
        this.errorCode = errorCode;
    }

    @CompilerDirectives.TruffleBoundary
    private RegexSyntaxException(String reason, SourceSection sourceSection, ErrorCode errorCode) {
        super(reason);
        this.sourceSection = sourceSection;
        this.errorCode = errorCode;
    }

    public RegexSyntaxException withErrorCodeInMessage() {
        return new RegexSyntaxException(this.errorCode.name() + " " + this.getMessage(), this.sourceSection, this.errorCode);
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.PARSE_ERROR;
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage(name="getSourceLocation")
    SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCode {
        InvalidBackReference,
        InvalidCharacterClass,
        InvalidEscape,
        InvalidFlag,
        InvalidGroup,
        InvalidInlineFlag,
        InvalidLookbehind,
        InvalidNamedGroup,
        InvalidOption,
        InvalidQuantifier,
        InvalidSubexpressionCall,
        UnfinishedSequence,
        UnmatchedBracket,
        UnmatchedParenthesis,
        TRegexBailout;


        public int intValue() {
            return -(this.ordinal() + 3);
        }
    }
}

