/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import java.util.Objects;

public abstract class JSLogicalNode
extends JavaScriptNode
implements ResumableNode.WithIntState {
    @Node.Child
    @Executed
    protected JavaScriptNode leftNode;
    @Node.Child
    protected JavaScriptNode rightNode;
    private static final int RESUME_RIGHT = 1;
    private static final int RESUME_UNEXECUTED = 0;

    protected JSLogicalNode(JavaScriptNode left, JavaScriptNode right) {
        this.leftNode = left;
        this.rightNode = right;
    }

    protected abstract Object executeEvaluated(VirtualFrame var1, Object var2);

    @Override
    public Object resume(VirtualFrame frame, int stateSlot) {
        int state = this.getStateAsIntAndReset(frame, stateSlot);
        if (state == 0) {
            Object leftValue = this.leftNode.execute(frame);
            try {
                return this.executeEvaluated(frame, leftValue);
            }
            catch (YieldException e) {
                this.setStateAsInt(frame, stateSlot, 1);
                throw e;
            }
        }
        assert (state == 1);
        try {
            return this.rightNode.execute(frame);
        }
        catch (YieldException e) {
            this.setStateAsInt(frame, stateSlot, 1);
            throw e;
        }
    }

    public final JavaScriptNode getLeft() {
        return this.leftNode;
    }

    public final JavaScriptNode getRight() {
        return this.rightNode;
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.getLeft().isResultAlwaysOfType(clazz) && this.getRight().isResultAlwaysOfType(clazz);
    }

    @Override
    public String expressionToString() {
        NodeInfo annotation;
        if (this.getLeft() != null && this.getRight() != null && (annotation = this.getClass().getAnnotation(NodeInfo.class)) != null && !annotation.shortName().isEmpty()) {
            return "(" + Objects.toString(this.getLeft().expressionToString(), "(intermediate value)") + " " + annotation.shortName() + " " + Objects.toString(this.getRight().expressionToString(), "(intermediate value)") + ")";
        }
        return null;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        String shortName;
        NodeInfo annotation = this.getClass().getAnnotation(NodeInfo.class);
        if (annotation != null && !(shortName = annotation.shortName()).isEmpty()) {
            return JSTags.createNodeObjectDescriptor("operator", annotation.shortName());
        }
        return null;
    }
}

