/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.frame;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlotKind;

public final class FrameSlotTypeException
extends IllegalStateException {
    private static final long serialVersionUID = 6972120475215757452L;
    private final int slot;
    private final FrameSlotKind expectedKind;
    private final FrameSlotKind actualKind;

    @Deprecated
    public FrameSlotTypeException() {
        this.slot = -1;
        this.expectedKind = null;
        this.actualKind = null;
    }

    FrameSlotTypeException(int slot, FrameSlotKind expectedTag, FrameSlotKind actualTag) {
        this.slot = slot;
        this.expectedKind = expectedTag;
        this.actualKind = actualTag;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getMessage() {
        if (this.slot < 0) {
            return null;
        }
        return String.format("Frame slot kind %s expected, but got %s at frame slot index %s.", new Object[]{this.expectedKind, this.actualKind, this.slot});
    }

    public int getSlot() {
        return this.slot;
    }

    public FrameSlotKind getExpectedKind() {
        return this.expectedKind;
    }

    public FrameSlotKind getActualKind() {
        return this.actualKind;
    }

    public static FrameSlotTypeException create(int slot, FrameSlotKind expectedKind, FrameSlotKind actualKind) {
        return new FrameSlotTypeException(slot, expectedKind, actualKind);
    }
}

