/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.optionsProcessing;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.OptionsProcessor;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;

public class ArtifactOptionsSet {
    private final Tool tool_;
    private OptionsProcessor.TypeOfOptions typeOfOptions_;
    private final EnumMap<PossibleArgs, ArrayList<String>> optionsAndArtifacts_ = new EnumMap(PossibleArgs.class);
    private String artifactName_ = null;
    private String artifactStatementSetName_ = null;
    private PossibleArgs artifactType_ = null;
    private String artifactNameAndStatementSetNameAsProvidedByUser_ = null;
    private boolean isHelpRequested_ = false;
    private boolean errorsFoundOtherThanUnexpectedOption_ = false;
    private final TreeSet<String> generalErrorMessages_;
    private final EnumMap<OptionsProcessor.TypeOfOptions, TreeSet<String>> toolsOptionsErrorMessages_;
    private final List<String> falseValue_ = Arrays.asList(PossibleArgs.PredefinedOptionValues.FALSE.getOptionValue());
    private boolean warningMessageHasBeenSet_ = false;
    private String warningMessageForOptionsBeingIgnored_ = null;
    private boolean recordOptionsAndArtifactsUsed_ = false;
    private final EnumSet<PossibleArgs> optionsAndArtifactsNotUsed_ = EnumSet.noneOf(PossibleArgs.class);
    private static final EnumSet<PossibleArgs> optionsUsedInCommonCode_ = EnumSet.of(PossibleArgs.SHOW_DETAILS, new PossibleArgs[]{PossibleArgs.TRACE_FILE, PossibleArgs.TRACE_LEVEL, PossibleArgs.ARCHIVE, PossibleArgs.BIND_AUTO_DETECT, PossibleArgs.ROOT_PATH, PossibleArgs.NO_CLEANUP, PossibleArgs.OPTIONS_FILE, PossibleArgs.PORT});
    private Boolean utilityHasArtifacts = null;

    protected ArtifactOptionsSet(Tool tool, OptionsProcessor.TypeOfOptions typeOfOptions) {
        this.tool_ = tool;
        this.typeOfOptions_ = typeOfOptions;
        this.generalErrorMessages_ = new TreeSet();
        this.toolsOptionsErrorMessages_ = new EnumMap(OptionsProcessor.TypeOfOptions.class);
        for (OptionsProcessor.TypeOfOptions typeOfOptions2 : OptionsProcessor.TypeOfOptions.values()) {
            this.toolsOptionsErrorMessages_.put(typeOfOptions2, new TreeSet());
        }
    }

    protected ArtifactOptionsSet(ArtifactOptionsSet artifactOptionsSet, String string, PossibleArgs possibleArgs) {
        this(artifactOptionsSet);
        this.setArtifactToProcess(string, possibleArgs);
    }

    protected ArtifactOptionsSet(ArtifactOptionsSet artifactOptionsSet) {
        AbstractCollection abstractCollection;
        this.tool_ = artifactOptionsSet.tool_;
        this.typeOfOptions_ = artifactOptionsSet.typeOfOptions_;
        this.artifactName_ = artifactOptionsSet.artifactName_;
        this.artifactStatementSetName_ = artifactOptionsSet.artifactStatementSetName_;
        this.artifactType_ = artifactOptionsSet.artifactType_;
        this.artifactNameAndStatementSetNameAsProvidedByUser_ = artifactOptionsSet.artifactNameAndStatementSetNameAsProvidedByUser_;
        this.isHelpRequested_ = artifactOptionsSet.isHelpRequested_;
        this.errorsFoundOtherThanUnexpectedOption_ = artifactOptionsSet.errorsFoundOtherThanUnexpectedOption_;
        this.warningMessageHasBeenSet_ = artifactOptionsSet.warningMessageHasBeenSet_;
        this.warningMessageForOptionsBeingIgnored_ = artifactOptionsSet.warningMessageForOptionsBeingIgnored_;
        for (Map.Entry<PossibleArgs, ArrayList<String>> entry : artifactOptionsSet.optionsAndArtifacts_.entrySet()) {
            abstractCollection = new ArrayList();
            ((ArrayList)abstractCollection).addAll((Collection)entry.getValue());
            this.optionsAndArtifacts_.put(entry.getKey(), (ArrayList)entry.getValue().clone());
        }
        this.generalErrorMessages_ = (TreeSet)artifactOptionsSet.generalErrorMessages_.clone();
        this.toolsOptionsErrorMessages_ = new EnumMap(OptionsProcessor.TypeOfOptions.class);
        for (Map.Entry<Enum, AbstractCollection> entry : artifactOptionsSet.toolsOptionsErrorMessages_.entrySet()) {
            abstractCollection = new TreeSet();
            ((TreeSet)abstractCollection).addAll(entry.getValue());
            this.toolsOptionsErrorMessages_.put((OptionsProcessor.TypeOfOptions)entry.getKey(), (TreeSet)((TreeSet)entry.getValue()).clone());
        }
    }

    protected void setArtifactToProcess(String string, PossibleArgs possibleArgs) {
        this.artifactNameAndStatementSetNameAsProvidedByUser_ = string;
        String[] stringArray = OptionsProcessor.getArtifactNameAndStatementSetName(string);
        this.artifactName_ = stringArray[0];
        this.artifactStatementSetName_ = stringArray[1];
        this.artifactType_ = null != possibleArgs ? possibleArgs : this.getArtifactType(this.artifactName_);
    }

    public String getArtifactName() {
        if (this.recordOptionsAndArtifactsUsed_ && null != this.artifactType_) {
            this.optionsAndArtifactsNotUsed_.remove((Object)this.artifactType_);
        }
        return this.artifactName_;
    }

    public PossibleArgs getArtifactType() {
        return this.artifactType_;
    }

    public String getArtifactStatementSet() {
        return this.artifactStatementSetName_;
    }

    protected String getArtifactNameAndStatementSetNameAsProvidedByUser() {
        return this.artifactNameAndStatementSetNameAsProvidedByUser_;
    }

    public String getOptionOrArtifactSingleValue(PossibleArgs possibleArgs) {
        return this.getOptionOrArtifactSingleValue(possibleArgs, true);
    }

    public String getOptionOrArtifactSingleValue(PossibleArgs possibleArgs, boolean bl2) {
        if (possibleArgs.acceptsMultipleValues(this.tool_)) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_ARGS_MULTIVALUE_AS_SINGLEVALUE", new Object[0]), null, 10739);
        }
        List<String> list = this.getOptionOrArtifactMultipleValues(possibleArgs, bl2);
        return null == list ? null : list.get(0);
    }

    public List<String> getOptionOrArtifactMultipleValues(PossibleArgs possibleArgs, boolean bl2) {
        if (possibleArgs.isAllowedForTool(this.tool_)) {
            if (this.recordOptionsAndArtifactsUsed_) {
                this.optionsAndArtifactsNotUsed_.remove((Object)possibleArgs);
            }
            List<String> list = (List<String>)this.optionsAndArtifacts_.get((Object)possibleArgs);
            if (PossibleArgs.GENERATE_DBRM == possibleArgs && null != list && 0 < list.size()) {
                List list2 = this.optionsAndArtifacts_.get((Object)PossibleArgs.VERIFY_PACKAGES);
                if (null != list2 && 0 < list2.size() && !PossibleArgs.PredefinedOptionValues.FALSE.getOptionValue().equalsIgnoreCase(list.get(0))) {
                    return this.falseValue_;
                }
                return list;
            }
            return bl2 && null == list ? possibleArgs.defaultValueStringAsList() : list;
        }
        return null;
    }

    protected String getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs possibleArgs) {
        List list = this.optionsAndArtifacts_.get((Object)possibleArgs);
        return null == list ? null : (String)list.get(0);
    }

    protected List<String> getOptionOrArtifactMultipleValuesForErrorChecking(PossibleArgs possibleArgs) {
        return this.optionsAndArtifacts_.get((Object)possibleArgs);
    }

    public boolean isOptionOrArtifactSpecified(PossibleArgs possibleArgs) {
        if (!possibleArgs.isAllowedForTool(this.tool_)) {
            return false;
        }
        return this.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs);
    }

    protected boolean isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs possibleArgs) {
        return this.optionsAndArtifacts_.containsKey((Object)possibleArgs);
    }

    protected void addOptionOrArtifact(PossibleArgs possibleArgs, String string) {
        if (null == string) {
            this.addErrorMessage(possibleArgs.errorMessage(this.tool_), true, false);
        }
        if (PossibleArgs.INTERFACE_IMPL == possibleArgs || PossibleArgs.DEPRECATED_INTERFACE_IMPL == possibleArgs) {
            if (null != string && string.endsWith("Impl")) {
                possibleArgs = PossibleArgs.INTERFACE;
                string = string.substring(0, string.length() - "Impl".length());
            } else {
                this.addErrorMessage(Messages.getText("ERR_BIND_BAD_IMPL_NAME", string, "Impl"), true, false);
            }
        }
        if (null == this.optionsAndArtifacts_.get((Object)possibleArgs)) {
            this.optionsAndArtifacts_.put(possibleArgs, new ArrayList());
        }
        this.optionsAndArtifacts_.get((Object)possibleArgs).add(string);
    }

    protected void addOptionOrArtifact(PossibleArgs possibleArgs, PossibleArgs.PredefinedOptionValues predefinedOptionValues) {
        this.addOptionOrArtifact(possibleArgs, predefinedOptionValues.getOptionValue());
    }

    protected void replaceOptionOrArtifact(PossibleArgs possibleArgs, String string) {
        this.optionsAndArtifacts_.remove((Object)possibleArgs);
        this.addOptionOrArtifact(possibleArgs, string);
    }

    public boolean isArtifactToProcessValidForThisTool() {
        if (null == this.utilityHasArtifacts) {
            this.utilityHasArtifacts = OptionsProcessor.utilityHasArtifacts(this.tool_);
        }
        return false == this.utilityHasArtifacts || this.artifactType_.isArtifact(this.tool_) && this.artifactType_.isAllowedForTool(this.tool_);
    }

    public boolean getOptionValueBoolean(PossibleArgs possibleArgs) {
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = this.getOptionSingleValueFromPredefinedOptionValues(possibleArgs, true);
        return PossibleArgs.PredefinedOptionValues.TRUE == predefinedOptionValues;
    }

    public PossibleArgs.PredefinedOptionValues getOptionSingleValueFromPredefinedOptionValues(PossibleArgs possibleArgs) {
        return this.getOptionSingleValueFromPredefinedOptionValues(possibleArgs, true);
    }

    public PossibleArgs.PredefinedOptionValues getOptionSingleValueFromPredefinedOptionValues(PossibleArgs possibleArgs, boolean bl2) {
        String string = this.getOptionOrArtifactSingleValue(possibleArgs, bl2);
        return possibleArgs.getOptionValueFromString(string);
    }

    public List<PossibleArgs.PredefinedOptionValues> getOptionMultipleValuesFromPredefinedOptionValues(PossibleArgs possibleArgs) {
        List<String> list = this.getOptionOrArtifactMultipleValues(possibleArgs, true);
        List list2 = null;
        if (null != list) {
            for (String string : list) {
                list2.add(possibleArgs.getOptionValueFromString(string));
            }
        }
        return list2;
    }

    public String getOptionValueGrantAndRevokeUsernames(PossibleArgs possibleArgs) {
        return this.getUsernameStringFromGrantOrRevoke(possibleArgs);
    }

    protected void copyOptionsAndErrorsFromOtherArtifactOptionsSet(ArtifactOptionsSet artifactOptionsSet, boolean bl2) {
        if (null != artifactOptionsSet) {
            for (Map.Entry<PossibleArgs, ArrayList<String>> entry : artifactOptionsSet.optionsAndArtifacts_.entrySet()) {
                PossibleArgs possibleArgs = entry.getKey();
                if (!bl2 && this.optionsAndArtifacts_.containsKey((Object)possibleArgs)) continue;
                this.optionsAndArtifacts_.put(possibleArgs, entry.getValue());
            }
            if (null != artifactOptionsSet) {
                this.generalErrorMessages_.addAll(artifactOptionsSet.generalErrorMessages_);
                this.errorsFoundOtherThanUnexpectedOption_ |= artifactOptionsSet.errorsFoundOtherThanUnexpectedOption_;
                for (OptionsProcessor.TypeOfOptions typeOfOptions : OptionsProcessor.TypeOfOptions.values()) {
                    this.toolsOptionsErrorMessages_.get((Object)typeOfOptions).addAll((Collection<String>)artifactOptionsSet.toolsOptionsErrorMessages_.get((Object)typeOfOptions));
                }
            }
        }
    }

    protected void setHelpRequested(boolean bl2) {
        this.isHelpRequested_ = bl2;
    }

    public boolean isHelpRequested() {
        return this.isHelpRequested_;
    }

    protected void replaceDeprecatedOptions() {
        EnumMap<PossibleArgs, ArrayList<String>> enumMap = null;
        EnumSet<PossibleArgs> enumSet = null;
        for (Map.Entry<PossibleArgs, ArrayList<String>> object : this.optionsAndArtifacts_.entrySet()) {
            PossibleArgs possibleArgs = object.getKey();
            ArrayList<String> arrayList = object.getValue();
            PossibleArgs possibleArgs2 = PossibleArgs.getPossibleArgCheckForDeprecated(possibleArgs);
            if (possibleArgs2 == possibleArgs) continue;
            if (null != this.optionsAndArtifacts_.get((Object)possibleArgs2)) {
                this.addErrorMessage(Messages.getText("ERR_OPTION_DEPRECATED_AND_NOTDEPRECATED_USED", possibleArgs.externalOptionName(), possibleArgs2.externalOptionName()), true, false);
                continue;
            }
            if (null == enumMap) {
                enumMap = new EnumMap<PossibleArgs, ArrayList<String>>(PossibleArgs.class);
            }
            enumMap.put(possibleArgs2, arrayList);
            if (null == enumSet) {
                enumSet = EnumSet.noneOf(PossibleArgs.class);
            }
            enumSet.add(possibleArgs);
            if (PossibleArgs.DEPRECATED_USERNAME_BINDER == possibleArgs) continue;
            this.addErrorMessage(Messages.getText("WARN_OPTION_DEPRECATED", possibleArgs.externalOptionName(), possibleArgs2.externalOptionName()), true, true);
        }
        if (null != enumSet) {
            for (PossibleArgs possibleArgs : enumSet) {
                this.optionsAndArtifacts_.remove((Object)possibleArgs);
            }
        }
        if (null != enumMap) {
            this.optionsAndArtifacts_.putAll(enumMap);
        }
    }

    protected void addErrorMessage(String string, boolean bl2, boolean bl3) {
        this.errorsFoundOtherThanUnexpectedOption_ |= !bl3;
        if (bl2) {
            OptionsProcessor.TypeOfOptions typeOfOptions = this.typeOfOptions_;
            boolean bl4 = false;
            if (OptionsProcessor.TypeOfOptions.MERGED_OPTIONS == this.typeOfOptions_) {
                typeOfOptions = OptionsProcessor.TypeOfOptions.OPTIONS_FILE_ARTIFACT_OPTIONS;
                for (OptionsProcessor.TypeOfOptions typeOfOptions2 : OptionsProcessor.TypeOfOptions.values()) {
                    if (!this.toolsOptionsErrorMessages_.get((Object)typeOfOptions2).contains(string)) continue;
                    bl4 = true;
                    break;
                }
            }
            if (!bl4) {
                this.toolsOptionsErrorMessages_.get((Object)typeOfOptions).add(string);
            }
        } else {
            this.generalErrorMessages_.add(string);
        }
    }

    public boolean checkIfOptionsAreValidAndLogWarningsForOptionsThatWillBeIgnored() {
        if (!this.warningMessageHasBeenSet_) {
            this.warningMessageHasBeenSet_ = true;
            StringBuilder stringBuilder = null;
            for (PossibleArgs possibleArgs : this.optionsAndArtifacts_.keySet()) {
                if (possibleArgs.isAllowedForTool(this.tool_)) continue;
                if (null == stringBuilder) {
                    stringBuilder = new StringBuilder("In the options file, the following options will be ignored because they are not valid options for this tool: ");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("\"" + possibleArgs.externalOptionName() + "\"");
            }
            String string = this.warningMessageForOptionsBeingIgnored_ = null != stringBuilder ? stringBuilder.toString() : null;
        }
        if (null != this.warningMessageForOptionsBeingIgnored_ && 0 == this.warningMessageForOptionsBeingIgnored_.length()) {
            ToolsLogger.getLogger().log(Level.WARNING, this.warningMessageForOptionsBeingIgnored_.toString());
        }
        return !this.errorsFoundOtherThanUnexpectedOption_;
    }

    protected void initializeOptionsAndArtifactsNotUsed() {
        this.optionsAndArtifactsNotUsed_.clear();
        for (PossibleArgs possibleArgs : this.optionsAndArtifacts_.keySet()) {
            if (!possibleArgs.isAllowedForTool(this.tool_)) continue;
            this.optionsAndArtifactsNotUsed_.add(possibleArgs);
        }
        if (this.optionsAndArtifacts_.get((Object)PossibleArgs.OPTIONS_FILE) != null) {
            this.optionsAndArtifactsNotUsed_.remove((Object)PossibleArgs.SUMMARY_LOG_OPTIONS_FILE);
        }
        this.optionsAndArtifactsNotUsed_.removeAll(optionsUsedInCommonCode_);
    }

    public void recordOptionsAndArtifactsUsed(boolean bl2) {
        this.recordOptionsAndArtifactsUsed_ = bl2;
    }

    public String getErrorMessages(boolean bl2, boolean bl3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.generalErrorMessages_.size();
        if (0 < n2) {
            int n3 = 1;
            for (String string2 : this.generalErrorMessages_) {
                stringBuilder.append('\n');
                if (1 < n2) {
                    stringBuilder.append('(').append(n3++).append(") ");
                }
                stringBuilder.append(string2);
            }
        }
        for (OptionsProcessor.TypeOfOptions enum_ : OptionsProcessor.TypeOfOptions.values()) {
            Object object;
            Set set = this.toolsOptionsErrorMessages_.get((Object)enum_);
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : set) {
                for (String string3 : set) {
                    if (string2.equals(string3) || !string3.contains(string2)) continue;
                    hashSet.add(string2);
                }
            }
            set.removeAll(hashSet);
            if (0 >= set.size() || bl3 && (OptionsProcessor.TypeOfOptions.OPTIONS_FILE_ARTIFACT_OPTIONS == enum_ || OptionsProcessor.TypeOfOptions.MERGED_OPTIONS == enum_)) continue;
            switch (enum_) {
                case COMMAND_LINE: {
                    if (null != string) {
                        object = Messages.getText("MSG_OPTIONS_ERR_CMDLINE2", string);
                        break;
                    }
                    object = Messages.getText("MSG_OPTIONS_ERR_CMDLINE", new Object[0]);
                    break;
                }
                case OPTIONS_FILE_DEFAULT_OPTIONS: {
                    if (null != string) {
                        object = Messages.getText("MSG_OPTIONS_ERR_DEFAULTOPTIONS2", "defaultOptions", string);
                        break;
                    }
                    object = Messages.getText("MSG_OPTIONS_ERR_DEFAULTOPTIONS", "defaultOptions");
                    break;
                }
                case OPTIONS_FILE_ARTIFACT_OPTIONS: 
                case MERGED_OPTIONS: {
                    if (null != string) {
                        object = Messages.getText("MSG_OPTIONS_ERR_ARTIFACT2", string);
                        break;
                    }
                    object = Messages.getText("MSG_OPTIONS_ERR_ARTIFACT", new Object[0]);
                    break;
                }
                default: {
                    object = null != string ? Messages.getText("MSG_OPTIONS_ERR2", string) : Messages.getText("MSG_OPTIONS_ERR", new Object[0]);
                }
            }
            if (0 < stringBuilder.length()) {
                stringBuilder.append("\n\n");
            }
            if (bl2) {
                stringBuilder.append(Messages.getText("MSG_WARN", new Object[0]) + "  ");
            }
            stringBuilder.append((String)object);
            int n3 = 1;
            for (String string3 : set) {
                stringBuilder.append("\n(" + n3++ + ")  " + string3);
            }
        }
        if (bl2 && !this.optionsAndArtifactsNotUsed_.isEmpty()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n5 = 1;
            for (PossibleArgs possibleArgs : this.optionsAndArtifactsNotUsed_) {
                if (n5 != 0) {
                    n5 = 0;
                } else {
                    stringBuilder2.append(',').append(' ');
                }
                stringBuilder2.append(possibleArgs.externalOptionName());
            }
            if (0 < stringBuilder.length()) {
                stringBuilder.append("\n\n");
            }
            stringBuilder.append("\n" + Messages.getText("WARN_OPTIONS_IGNORED", stringBuilder2.toString()));
        }
        return stringBuilder.toString();
    }

    protected OptionsProcessor.TypeOfOptions getTypeOfOptions() {
        return this.typeOfOptions_;
    }

    protected void changeTypeOfOptionsToMerged() {
        this.typeOfOptions_ = OptionsProcessor.TypeOfOptions.MERGED_OPTIONS;
    }

    protected Tool getTool() {
        return this.tool_;
    }

    private PossibleArgs getArtifactType(String string) {
        if (null == string) {
            return null;
        }
        if (Tool.MERGE == this.tool_) {
            return PossibleArgs.OUTPUT_PUREQUERY_XML;
        }
        return OptionsProcessor.getArtifactTypeForOptionsFileLine(string);
    }

    private String getUsernameStringFromGrantOrRevoke(PossibleArgs possibleArgs) {
        String string = this.getOptionOrArtifactSingleValue(possibleArgs);
        String string2 = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
            boolean bl2 = true;
            while (stringTokenizer.hasMoreTokens()) {
                if (!bl2) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GRANT_OPTION_SYNTAX_NEW", string), null, 10512);
                }
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = null;
                bl2 = false;
                if (!string3.equalsIgnoreCase("grantees")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GRANT_OPTION_SYNTAX_NEW", string), null, 10513);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim();
                }
                if (string4 != null && string4.length() > 0) {
                    string2 = string4;
                    continue;
                }
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GRANTEES_LIST_IS_NULL", new Object[0]), null, 10514);
            }
            if (bl2) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GRANT_OPTION_SYNTAX_NEW", string), null, 10577);
            }
        }
        return string2;
    }

    public Set<PossibleArgs> getAllOptionsAndArtifactsSpecified() {
        return this.optionsAndArtifacts_.keySet();
    }

    public String getAllOptionsAndArtifactsAsString(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PossibleArgs possibleArgs : PossibleArgs.getValues(this.tool_)) {
            List<String> list = this.getOptionOrArtifactMultipleValues(possibleArgs, bl2);
            if (!this.isOptionOrArtifactSpecified(possibleArgs) && null == list && possibleArgs != this.artifactType_ || possibleArgs == PossibleArgs.OPTIONS_FILE && "~!AUTO_DETECTED_BIND_PROPS_CONTENTS!~".equals(this.getOptionOrArtifactSingleValue(possibleArgs))) continue;
            if (possibleArgs == this.artifactType_) {
                stringBuilder.append(this.artifactType_.externalOptionName()).append(' ');
                this.appendQuotedValue(stringBuilder, this.artifactName_, false);
                if (null != this.artifactStatementSetName_) {
                    stringBuilder.append(':');
                    this.appendQuotedValue(stringBuilder, this.artifactStatementSetName_, false);
                }
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(possibleArgs.externalOptionName()).append(' ');
            if (possibleArgs.maskUserValueInOutput()) {
                this.appendQuotedValue(stringBuilder, "*****", true);
                continue;
            }
            for (String string : list) {
                this.appendQuotedValue(stringBuilder, string, true);
            }
        }
        return stringBuilder.toString().trim();
    }

    private void appendQuotedValue(StringBuilder stringBuilder, String string, boolean bl2) {
        if (null == string) {
            stringBuilder.append((String)null);
        } else {
            stringBuilder.append('\"').append(string).append('\"');
        }
        if (bl2) {
            stringBuilder.append(' ');
        }
    }
}

