/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.util.JsonSerialization;

public class SdJwtCredentialBody
implements CredentialBody {
    private final SdJwt.Builder sdJwtBuilder;
    private final IssuerSignedJWT issuerSignedJWT;

    public SdJwtCredentialBody(SdJwt.Builder sdJwtBuilder, IssuerSignedJWT issuerSignedJWT) {
        this.sdJwtBuilder = sdJwtBuilder;
        this.issuerSignedJWT = issuerSignedJWT;
    }

    @Override
    public void addKeyBinding(JWK jwk) throws CredentialBuilderException {
        ObjectNode jwkNode = (ObjectNode)JsonSerialization.mapper.convertValue((Object)jwk, ObjectNode.class);
        ObjectNode keyBindingNode = JsonSerialization.mapper.createObjectNode();
        keyBindingNode.set("jwk", (JsonNode)jwkNode);
        this.issuerSignedJWT.getPayload().set("cnf", (JsonNode)keyBindingNode);
    }

    public IssuerSignedJWT getIssuerSignedJWT() {
        return this.issuerSignedJWT;
    }

    public String sign(SignatureSignerContext signatureSignerContext) {
        SdJwt sdJwt = this.sdJwtBuilder.withIssuerSignedJwt(this.issuerSignedJWT).withIssuerSigningContext(signatureSignerContext).build();
        return sdJwt.toSdJwtString();
    }
}

