/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.model;

import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public enum ReferenceType {
    HEADER(Header.class, "headers"),
    SCHEMA(Schema.class, "schemas"),
    SECURITY_SCHEME(SecurityScheme.class, "securitySchemes"),
    CALLBACK(Callback.class, "callbacks"),
    LINK(Link.class, "links"),
    RESPONSE(APIResponse.class, "responses"),
    PARAMETER(Parameter.class, "parameters"),
    EXAMPLE(Example.class, "examples"),
    REQUEST_BODY(RequestBody.class, "requestBodies"),
    PATH_ITEM(PathItem.class, "pathItems");

    private static final Pattern COMPONENT_KEY_PATTERN;
    public static final String PROP_ANNOTATION = "ref";
    public static final String PROP_STANDARD = "$ref";
    Class<? extends Reference<?>> modelType;
    String componentPath;

    private ReferenceType(Class<? extends Reference<?>> modelType, String componentPath) {
        this.modelType = modelType;
        this.componentPath = componentPath;
    }

    public static ReferenceType fromModel(Reference<?> model) {
        for (ReferenceType ref : ReferenceType.values()) {
            if (!ref.modelType.isAssignableFrom(model.getClass())) continue;
            return ref;
        }
        return null;
    }

    public static ReferenceType fromComponentPath(String path) {
        for (ReferenceType ref : ReferenceType.values()) {
            if (!ref.componentPath.equals(path)) continue;
            return ref;
        }
        return null;
    }

    public static boolean isReference(AnnotationInstance annotation) {
        return annotation != null && annotation.value(PROP_ANNOTATION) != null;
    }

    public static String referenceValue(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation.value(PROP_ANNOTATION)).map(AnnotationValue::asString).orElse(null);
    }

    public String referencePrefix() {
        return "#/components/" + this.componentPath;
    }

    public String referenceOf(String ref) {
        return this.referencePrefix() + "/" + ref;
    }

    public String parseRefValue(String ref) {
        if (ref == null) {
            return null;
        }
        if (!COMPONENT_KEY_PATTERN.matcher(ref).matches()) {
            return ref;
        }
        return this.referenceOf(ref);
    }

    public String refValue(AnnotationInstance annotation) {
        String ref = ReferenceType.referenceValue(annotation);
        return this.parseRefValue(ref);
    }

    static {
        COMPONENT_KEY_PATTERN = Pattern.compile("^[a-zA-Z0-9\\.\\-_]+$");
    }
}

