/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Polygon;
import javax.swing.border.Border;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.gui.colorprovider.ColorBlender;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.gui.shaped.border.RoundedCornerBorder;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.theme.ShapedGradientTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class ShapedGradientDockingTheme
extends DockingWindowsTheme {
    private RootWindowProperties rootWindowProperties = new RootWindowProperties();
    private String name;

    public ShapedGradientDockingTheme() {
        this(0.0f, 0.5f);
    }

    public ShapedGradientDockingTheme(float leftSlope, float rightSlope) {
        this(leftSlope, rightSlope, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT, true);
    }

    public ShapedGradientDockingTheme(float leftSlope, float rightSlope, ColorProvider lineColor, ColorProvider highlightColor, boolean focusHighlighterEnabled) {
        this(leftSlope, rightSlope, 25, lineColor, highlightColor, focusHighlighterEnabled);
    }

    public ShapedGradientDockingTheme(float leftSlope, float rightSlope, int slopeHeight, ColorProvider lineColor, ColorProvider highlightColor, boolean focusHighlighterEnabled) {
        ShapedGradientTheme theme = new ShapedGradientTheme(leftSlope, rightSlope, slopeHeight, lineColor, highlightColor);
        this.name = theme.getName();
        int cornerType = 3;
        TabbedPanelProperties tabbedPanelProperties = theme.getTabbedPanelProperties();
        TitledTabProperties titledTabProperties = theme.getTitledTabProperties();
        this.rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties().addSuperObject(tabbedPanelProperties);
        this.rootWindowProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().addSuperObject(titledTabProperties);
        if (focusHighlighterEnabled) {
            this.rootWindowProperties.getTabWindowProperties().getTabProperties().getFocusedProperties().getShapedPanelProperties().setComponentPainter(this.rootWindowProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getHighlightedProperties().getShapedPanelProperties().getComponentPainter());
            ColorMultiplier topColor = new ColorMultiplier(theme.getControlColor(), 0.85f);
            this.rootWindowProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getHighlightedProperties().getShapedPanelProperties().setComponentPainter(new GradientComponentPainter(topColor, theme.getControlColor(), theme.getControlColor(), theme.getControlColor()));
            this.rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties().getTabAreaComponentsProperties().getShapedPanelProperties().setComponentPainter(new GradientComponentPainter(new ColorMultiplier(theme.getControlColor(), 1.1f), theme.getControlColor(), theme.getControlColor(), topColor));
        }
        Border highlightBorder = theme.createTabBorder(theme.getLineColor(), theme.getHighlightColor(), 0.0f, 0.0f, true, true, true, true, false, true, 0);
        int inset = 4;
        boolean extraRaised = true;
        RoundedCornerBorder normalBorder = new RoundedCornerBorder(theme.getLineColor(), null, cornerType, cornerType, cornerType, cornerType, true, true, true, true, theme){
            private Border calculatedInsetsBorder;
            {
                this.calculatedInsetsBorder = shapedGradientTheme.createTabBorder(shapedGradientTheme.getLineColor(), null, 0.0f, 0.0f, false, true, true, false, true, true, 0);
            }

            @Override
            protected Polygon createPolygon(Component c, int width, int height) {
                Polygon p = super.createPolygon(c, width, height);
                int i = 0;
                while (i < p.npoints) {
                    p.xpoints[i] = p.xpoints[i] < width / 2 ? p.xpoints[i] + (this.isFirst(c) ? 0 : 4) + 1 : p.xpoints[i] - 4 - 1;
                    ++i;
                }
                return p;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return this.calculatedInsetsBorder.getBorderInsets(c);
            }

            private boolean isFirst(Component c) {
                Tab tab = TabbedUtils.getParentTab(c);
                if (tab != null && tab.getTabbedPanel() != null) {
                    return tab.getTabbedPanel().getTabAt(0) == tab;
                }
                return false;
            }
        };
        TitledTabProperties tabProperties = this.rootWindowProperties.getWindowBarProperties().getTabWindowProperties().getTabProperties().getTitledTabProperties();
        tabProperties.getNormalProperties().getComponentProperties().setBorder(normalBorder).setInsets(new Insets(1, 0, 1, 3));
        tabProperties.getHighlightedProperties().getComponentProperties().setBorder(highlightBorder);
        tabProperties.setHighlightedRaised(0).setBorderSizePolicy(TitledTabBorderSizePolicy.EQUAL_SIZE);
        this.rootWindowProperties.getWindowBarProperties().getTabWindowProperties().getTabbedPanelProperties().setTabSpacing(-8).getTabAreaComponentsProperties().getComponentProperties().setBorder(new RoundedCornerBorder(theme.getLineColor(), theme.getHighlightColor(), cornerType, cornerType, cornerType, cornerType, true, true, true, true)).setInsets(new Insets(0, 3, 0, 3));
        this.rootWindowProperties.setDragRectangleBorderWidth(3).getWindowBarProperties().getComponentProperties().setInsets(new Insets(2, 0, 2, 0));
        this.rootWindowProperties.getWindowAreaProperties().setBorder(null).setInsets(new Insets(2, 2, 2, 2));
        this.rootWindowProperties.getComponentProperties().setBackgroundColor(null);
        this.rootWindowProperties.getShapedPanelProperties().setComponentPainter(new SolidColorComponentPainter(new ColorBlender(UIManagerColorProvider.TABBED_PANE_BACKGROUND, UIManagerColorProvider.CONTROL_COLOR, 0.5f)));
        this.rootWindowProperties.getWindowAreaShapedPanelProperties().setComponentPainter(new SolidColorComponentPainter(UIManagerColorProvider.CONTROL_COLOR));
        Insets insets = this.rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().getInsets();
        if (highlightColor == null) {
            this.rootWindowProperties.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().setInsets(new Insets(insets.top, insets.top, insets.top, insets.top));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RootWindowProperties getRootWindowProperties() {
        return this.rootWindowProperties;
    }
}

