/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.actions.gui;

import de.sciss.syntaxpane.actions.ActionUtils;
import de.sciss.syntaxpane.actions.DocumentSearchData;
import de.sciss.syntaxpane.actions.gui.EscapeListener;
import de.sciss.syntaxpane.components.Markers;
import de.sciss.syntaxpane.util.SwingUtils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ReplaceDialog
extends JDialog
implements CaretListener,
EscapeListener {
    private JTextComponent textComponent;
    private DocumentSearchData dsd;
    private static Markers.SimpleMarker SEARCH_MARKER = new Markers.SimpleMarker(Color.YELLOW);
    private JButton jBtnNext;
    private JButton jBtnPrev;
    private JButton jBtnReplace;
    private JButton jBtnReplaceAll;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegex;
    private JCheckBox jChkWrap;
    private JComboBox jCmbFind;
    private JComboBox jCmbReplace;
    private JLabel jLblFind;
    private JLabel jLblReplace;
    private JToggleButton jTglHighlight;

    public ReplaceDialog(JTextComponent text, DocumentSearchData dsd) {
        super(SwingUtilities.getWindowAncestor(text), Dialog.ModalityType.MODELESS);
        this.initComponents();
        this.textComponent = text;
        this.dsd = dsd;
        this.textComponent.addCaretListener(this);
        this.setLocationRelativeTo(text.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnNext);
        SwingUtils.addEscapeListener(this);
        this.jBtnReplaceAll.setEnabled(text.isEditable() && text.isEnabled());
    }

    public void updateHighlights() {
        Markers.removeMarkers(this.textComponent, SEARCH_MARKER);
        if (this.jTglHighlight.isSelected()) {
            Markers.markAll(this.textComponent, this.dsd.getPattern(), SEARCH_MARKER);
        }
    }

    private void showRegexpError(PatternSyntaxException ex) throws HeadlessException {
        JOptionPane.showMessageDialog(this, "Regexp error: " + ex.getMessage(), "Regular Expression Error", 0);
        this.jCmbFind.requestFocus();
    }

    private void updateFinder() {
        String regex = (String)this.jCmbFind.getSelectedItem();
        try {
            this.dsd.setPattern(regex, this.jChkRegex.isSelected(), this.jChkIgnoreCase.isSelected());
            ActionUtils.insertIntoCombo(this.jCmbFind, regex);
        }
        catch (PatternSyntaxException e) {
            this.showRegexpError(e);
        }
    }

    private void setIcon(AbstractButton b, String name) {
        URL res = this.getClass().getClassLoader().getResource("de/sciss/syntaxpane/images/small-icons/" + name);
        if (res != null) {
            b.setIcon(new ImageIcon(res));
        }
    }

    private void initComponents() {
        this.jLblFind = new JLabel();
        this.jBtnNext = new JButton();
        this.jBtnPrev = new JButton();
        this.jBtnReplaceAll = new JButton();
        this.jChkWrap = new JCheckBox();
        this.jChkRegex = new JCheckBox();
        this.jChkIgnoreCase = new JCheckBox();
        this.jLblReplace = new JLabel();
        this.jTglHighlight = new JToggleButton();
        this.jCmbReplace = new JComboBox();
        this.jCmbFind = new JComboBox();
        this.jBtnReplace = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("de/sciss/syntaxpane/Bundle");
        this.setTitle(bundle.getString("ReplaceDialog.title"));
        this.setName("");
        this.setResizable(false);
        this.jLblFind.setDisplayedMnemonic('F');
        this.jLblFind.setLabelFor(this.jCmbFind);
        this.jLblFind.setText(bundle.getString("ReplaceDialog.jLblFind.text"));
        this.setIcon(this.jBtnNext, "go-next.png");
        this.jBtnNext.setMnemonic('N');
        this.jBtnNext.setText(bundle.getString("ReplaceDialog.jBtnNext.text"));
        this.jBtnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnNextActionPerformed(evt);
            }
        });
        this.setIcon(this.jBtnPrev, "go-previous.png");
        this.jBtnPrev.setMnemonic('N');
        this.jBtnPrev.setText(bundle.getString("ReplaceDialog.jBtnPrev.text"));
        this.jBtnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnPrevActionPerformed(evt);
            }
        });
        this.setIcon(this.jBtnReplaceAll, "edit-find-replace-all.png");
        this.jBtnReplaceAll.setMnemonic('H');
        this.jBtnReplaceAll.setText(bundle.getString("ReplaceDialog.jBtnReplaceAll.text"));
        this.jBtnReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnReplaceAllActionPerformed(evt);
            }
        });
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText(bundle.getString("ReplaceDialog.jChkWrap.text"));
        this.jChkWrap.setToolTipText(bundle.getString("ReplaceDialog.jChkWrap.toolTipText"));
        this.jChkRegex.setMnemonic('R');
        this.jChkRegex.setText(bundle.getString("ReplaceDialog.jChkRegex.text"));
        this.jChkIgnoreCase.setMnemonic('I');
        this.jChkIgnoreCase.setText(bundle.getString("ReplaceDialog.jChkIgnoreCase.text"));
        this.jLblReplace.setDisplayedMnemonic('R');
        this.jLblReplace.setLabelFor(this.jCmbReplace);
        this.jLblReplace.setText(bundle.getString("ReplaceDialog.jLblReplace.text"));
        this.setIcon(this.jTglHighlight, "highlight.png");
        this.jTglHighlight.setText(bundle.getString("ReplaceDialog.jTglHighlight.text"));
        this.jTglHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jTglHighlightActionPerformed(evt);
            }
        });
        this.jCmbReplace.setEditable(true);
        this.jCmbFind.setEditable(true);
        this.setIcon(this.jBtnReplace, "edit-find-replace.png");
        this.jBtnReplace.setText(bundle.getString("ReplaceDialog.jBtnReplace.text"));
        this.jBtnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnReplaceActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLblFind).addComponent(this.jLblReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCmbFind, 0, 289, Short.MAX_VALUE).addComponent(this.jCmbReplace, GroupLayout.Alignment.TRAILING, 0, 289, Short.MAX_VALUE).addComponent(this.jChkRegex, -1, 289, Short.MAX_VALUE).addComponent(this.jChkWrap, -1, 289, Short.MAX_VALUE).addComponent(this.jChkIgnoreCase, -1, 289, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnReplace, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE).addComponent(this.jBtnNext, -1, 107, Short.MAX_VALUE).addComponent(this.jBtnPrev, -1, 107, Short.MAX_VALUE).addComponent(this.jTglHighlight, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE).addComponent(this.jBtnReplaceAll, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFind).addComponent(this.jCmbFind, -2, -1, -2).addComponent(this.jBtnNext)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnPrev).addComponent(this.jCmbReplace, -2, -1, -2).addComponent(this.jLblReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnReplace).addComponent(this.jChkWrap, -2, 23, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkRegex).addComponent(this.jBtnReplaceAll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkIgnoreCase).addComponent(this.jTglHighlight)).addContainerGap()));
        this.pack();
    }

    private void jBtnNextActionPerformed(ActionEvent evt) {
        try {
            this.updateFinder();
            if (!this.dsd.doFindNext(this.textComponent)) {
                this.dsd.msgNotFound(this.textComponent);
            }
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jBtnReplaceAllActionPerformed(ActionEvent evt) {
        try {
            this.updateFinder();
            String replacement = (String)this.jCmbReplace.getSelectedItem();
            if (replacement == null) {
                replacement = "";
            }
            if (!this.jChkRegex.isSelected()) {
                replacement = Matcher.quoteReplacement(replacement);
            }
            ActionUtils.insertIntoCombo(this.jCmbReplace, replacement);
            this.jTglHighlight.setSelected(false);
            this.dsd.doReplaceAll(this.textComponent, replacement);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jTglHighlightActionPerformed(ActionEvent evt) {
        this.updateFinder();
        this.updateHighlights();
    }

    private void jBtnPrevActionPerformed(ActionEvent evt) {
        this.updateFinder();
        this.dsd.doFindPrev(this.textComponent);
    }

    private void jBtnReplaceActionPerformed(ActionEvent evt) {
        this.jTglHighlight.setSelected(false);
        String replacement = this.jCmbReplace.getSelectedItem() == null ? "" : this.jCmbReplace.getSelectedItem().toString();
        this.dsd.doReplace(this.textComponent, replacement);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateHighlights();
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
        this.textComponent.requestFocus();
    }
}

