---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, listes, profondeur de liste
---

# Comment augmenter la profondeur des listes ?

Il est parfois utile d'avoir des niveaux d'imbrication élevés dans des listes 
(autrement dit des *listes imbriquées dans des listes imbriquées* 
*dans des listes...* et ainsi de suite un certain nombre de fois). 
Cependant, LaTeX, par défaut, ne vous propose que 4 niveaux d'imbrication.

Ainsi l'exemple suivant ne fonctionnera pas et vous aurez le message d'erreur
"LaTeX Error: Too deeply nested".

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un extrait d'une classification du vivant classant les chordés 
(ou cordés) et les mollusques. Wikipédia précise à cet égard que ce 
type de classification porte souvent à débat :
\begin{itemize}
  \item Bacteria (bactéries) ;
  \item Archaea (archées) ;
  \item Eukaryota (eucaryotes) :
  \begin{itemize}
    \item Opisthokonta (opisthocontes) :
    \begin{itemize}
      \item Metazoa (métazoaires ou animaux pluricellulaires) :
      \begin{itemize}
        \item Bilateria (animaux bilatériens) :
        \begin{itemize}
          \item Chordata (chordés),
          \item Mollusca (mollusques).
        \end{itemize}
      \end{itemize}
    \end{itemize}
  \end{itemize}
\end{itemize}
\end{document}
```


## Avec l'extension <ctanpkg:enumitem>

L'extension <ctanpkg:enumitem>, de Javier Bezos, propose 
de nombreuses fonctionnalités pour modifier les listes. Parmi celles-ci, 
se trouve la commande `\setlistdepth{⟨niveau⟩}` qui permet de rédéfinir 
le `⟨niveau⟩` de profondeur des listes.

Une fois cette redéfinition faite, il faut également définir une liste
avec la commande suivante (ou la redéfinir avec la commande proche 
`\renewlist`).

```{noedit}
\newlist{⟨nom⟩}{⟨type⟩}{⟨niveau-max⟩}
```

Dans celle-ci, les différents paramètres sont :
- `⟨nom⟩`, le nom de votre nouvel environnement (ou le nom d'un environnement
  existant pour le redéfinir) ;
- `⟨type⟩`, le nom d'un des environnements classiques qui sert de base 
  à notre nouvelle liste : `itemize`, `enumerate`, `description` ; 
- `⟨niveau-max⟩`, le niveau de profondeur maximal de cette liste.

Enfin, il faut définir le format des différents niveaux de cette liste avec 
la commande suivante.

```{noedit}
\setlist[⟨nom⟩,⟨niveau⟩]{⟨options⟩}
```

Les paramètres sont ici :

- `⟨nom⟩`, le nom de l'environnement à modifier ;
- `⟨niveau⟩`, le niveau de l'environnement à modifier ;
- `⟨options⟩`, une série de paramètres au format "clé=valeur". Dans l'exemple
  ci-dessous, nous indiquons la présentation de la puce de chaque niveau 
  avec la clé `label`. 

Notez que la seule commande `\setlist` réellement nécessaire dans l'exemple 
qui suit est la dernière car elle définit une puce non définie jusque-là 
(en effet, <ctanpkg:enumitem> ne préjuge pas du format de la puce 
de ce nouveau niveau de liste). Sans cette commande, LaTeX indiquerait 
une erreur "Package enumitem Error: Undefined label".

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{enumitem}
  
  \setlistdepth{5}                       % Profondeur maximale des listes
  \renewlist{itemize}{itemize}{5}        % Rédéfinition d'itemize
  \setlist[itemize,1]{label=\textbullet} % puce du niveau 1 d'itemize
  \setlist[itemize,2]{label=---}         % puce du niveau 2 d'itemize
  \setlist[itemize,3]{label=--}          % puce du niveau 3 d'itemize
  \setlist[itemize,4]{label=+}           % puce du niveau 4 d'itemize
  \setlist[itemize,5]{label=-}           % puce du niveau 5 d'itemize

\begin{document}
Voici un extrait d'une classification du vivant classant les chordés 
(ou cordés) et les mollusques. Wikipédia précise à cet égard que ce 
type de classification porte souvent à débat :
\begin{itemize}
  \item Bacteria (bactéries) ;
  \item Archaea (archées) ;
  \item Eukaryota (eucaryotes) :
  \begin{itemize}
    \item Opisthokonta (opisthocontes) :
    \begin{itemize}
      \item Metazoa (métazoaires ou animaux pluricellulaires) :
      \begin{itemize}
        \item Bilateria (animaux bilatériens) :
        \begin{itemize}
          \item Chordata (chordés),
          \item Mollusca (mollusques).
        \end{itemize}
      \end{itemize}
    \end{itemize}
  \end{itemize}
\end{itemize}
\end{document}
```


:::{sources}
- [A five level deep list](https://tex.stackexchange.com/q/41408), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::