---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références, 
              protection de commande, référence bibliographique dans un titre
              référence bibliographique dans une légende
---

# Comment utiliser la commande `\cite` dans une commande `\caption` ?

## Avec les commandes de base

La commande `\cite` est, à l'origine, une commande dite "fragile". Il faut la 
"[protéger](/2_programmation/syntaxe/c_est_quoi_la_protection)" 
avec la commande `\protect` pour l'inclure dans des commandes 
telles que `\caption`, les commandes de sectionnement, etc. Ce qui donnera
par exemple :

```{noedit}
\caption{Une figure extraite de~\protect\cite{doc}}
```

Les versions récentes de LaTeX définissent `\cite` à l'aide de
`\DeclareRobustCommand` pour qu'elle ne soit pas fragile, mais il est possible
que certaines extensions la redéfinissent comme une commande "fragile".


:::{todo} Ajouter un exemple
:::


## Cas particulier avec le style bibliographique `unsrt`

Avec le style de bibliographie `unsrt` peut se produire un problème
de numérotation. En effet, ce style permet que les références soient numérotées
dans l'ordre où elles apparaissent. Cependant, le fait de rajouter une table
des figures (ou des matières...) peut changer cet ordre. La question 
"[](/3_composition/annexes/bibliographie/style_bst/probleme_avec_le_style_unsrt)"
traite ce point.