# `armebv7r-none-eabi` and `armebv7r-none-eabihf`

* **Tier: 3**
* **Library Support:** core and alloc (bare-metal, `#![no_std]`)

Bare-metal target for CPUs in the Armv7-R architecture family running in Big
Endian mode. These processors support dual ARM/Thumb mode, with ARM mode as
the default.

**NOTE:** You should almost always prefer the [little-endian
versions](armv7r-none-eabi.md) of these target. Big Endian Arm systems are
highly unusual.

Processors in this family include the [Arm Cortex-R4, 5, 7, and 8][cortex-r].

See [`arm-none-eabi`](arm-none-eabi.md) for information applicable to all
`arm-none-eabi` targets.

[cortex-r]: https://en.wikipedia.org/wiki/ARM_Cortex-R

## Target maintainers

[@chrisnc](https://github.com/chrisnc)

## Requirements

Note that some variants of the Cortex-R have both big-endian instructions and
data. This configuration is known as BE-32, while data-only big-endianness is
known as BE-8. To build programs for BE-32 processors, the GNU linker must be
used with the `-mbe32` option. See [ARM Cortex-R Series Programmer's Guide:
Endianness][endianness] for more details about different endian modes.

When using the hardfloat targets, the minimum floating-point features assumed
are those of the `vfpv3-d16`, which includes single- and double-precision, with
16 double-precision registers. This floating-point unit appears in Cortex-R4F
and Cortex-R5F processors. See [VFP in the Cortex-R processors][vfp]
for more details on the possible FPU variants.

If your processor supports a different set of floating-point features than the
default expectations of `vfpv3-d16`, then these should also be enabled or
disabled as needed with `-C target-feature=(+/-)`.

[endianness]: https://developer.arm.com/documentation/den0042/a/Coding-for-Cortex-R-Processors/Endianness

[vfp]: https://developer.arm.com/documentation/den0042/a/Floating-Point/Floating-point-basics-and-the-IEEE-754-standard/VFP-in-the-Cortex-R-processors

## Start-up and Low-Level Code

The [Rust Embedded Devices Working Group Arm Team] maintain the [`aarch32-cpu`]
and [`aarch32-rt`] crates, which may be useful for writing bare-metal code
using this target. Those crates include several examples which run in QEMU and
build using these targets.

[`aarch32-cpu`]: https://docs.rs/aarch32-cpu
[`aarch32-rt`]: https://docs.rs/aarch32-rt
