;;! target = "aarch64"
;;! test = "winch"

(module
  (func $fibonacci8 (param $n i32) (result i32)
    (if (result i32) (i32.le_s (local.get $n) (i32.const 1))
      (then
        ;; If n <= 1, return n (base case)
        (local.get $n)
      )
      (else
        ;; Else, return fibonacci(n - 1) + fibonacci(n - 2)
        (i32.add
          (call $fibonacci8
            (i32.sub (local.get $n) (i32.const 1)) ;; Calculate n - 1
          )
          (call $fibonacci8
            (i32.sub (local.get $n) (i32.const 2)) ;; Calculate n - 2
          )
        )
      )
    )
  )
  (export "fib" (func $fibonacci8))
)

;; wasm[0]::function[0]::fibonacci8:
;;       stp     x29, x30, [sp, #-0x10]!
;;       mov     x29, sp
;;       mov     x28, sp
;;       mov     x9, x0
;;       sub     sp, sp, #0x18
;;       mov     x28, sp
;;       stur    x0, [x28, #0x10]
;;       stur    x1, [x28, #8]
;;       stur    w2, [x28, #4]
;;       ldur    w0, [x28, #4]
;;       cmp     w0, #1
;;       cset    x0, le
;;       tst     w0, w0
;;       b.eq    #0x44
;;       b       #0x3c
;;   3c: ldur    w0, [x28, #4]
;;       b       #0xd4
;;   44: ldur    w0, [x28, #4]
;;       sub     w0, w0, #1
;;       sub     sp, sp, #4
;;       mov     x28, sp
;;       stur    w0, [x28]
;;       sub     sp, sp, #4
;;       mov     x28, sp
;;       mov     x0, x9
;;       mov     x1, x9
;;       ldur    w2, [x28, #4]
;;       bl      #0
;;   70: add     sp, sp, #4
;;       mov     x28, sp
;;       add     sp, sp, #4
;;       mov     x28, sp
;;       ldur    x9, [x28, #0x10]
;;       ldur    w1, [x28, #4]
;;       sub     w1, w1, #2
;;       sub     sp, sp, #4
;;       mov     x28, sp
;;       stur    w0, [x28]
;;       sub     sp, sp, #4
;;       mov     x28, sp
;;       stur    w1, [x28]
;;       mov     x0, x9
;;       mov     x1, x9
;;       ldur    w2, [x28]
;;       bl      #0
;;   b4: add     sp, sp, #4
;;       mov     x28, sp
;;       ldur    x9, [x28, #0x14]
;;       ldur    w1, [x28]
;;       add     sp, sp, #4
;;       mov     x28, sp
;;       add     w1, w1, w0, uxtx
;;       mov     w0, w1
;;       add     sp, sp, #0x18
;;       mov     x28, sp
;;       ldp     x29, x30, [sp], #0x10
;;       ret
