% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-vctrs-helpers.R
\name{rset_reconstruct}
\alias{rset_reconstruct}
\title{Extending rsample with new rset subclasses}
\usage{
rset_reconstruct(x, to)
}
\arguments{
\item{x}{A data frame to restore to an rset subclass.}

\item{to}{An rset subclass to restore to.}
}
\value{
\code{x} restored to the rset subclass of \code{to}.
}
\description{
\code{rset_reconstruct()} encapsulates the logic for allowing new rset
subclasses to work properly with vctrs (through \code{vctrs::vec_restore()}) and
dplyr (through \code{dplyr::dplyr_reconstruct()}). It is intended to be a
developer tool, and is not required for normal usage of rsample.
}
\details{
rset objects are considered "reconstructable" after a vctrs/dplyr operation
if:
\itemize{
\item \code{x} and \code{to} both have an identical column named \code{"splits"} (column
and row order do not matter).
\item \code{x} and \code{to} both have identical columns prefixed with \code{"id"} (column
and row order do not matter).
}
}
\examples{
to <- bootstraps(mtcars, times = 25)

# Imitate a vctrs/dplyr operation,
# where the class might be lost along the way
x <- tibble::as_tibble(to)

# Say we added a new column to `x`. Here we mock a `mutate()`.
x$foo <- "bar"

# This is still reconstructable to `to`
rset_reconstruct(x, to)

# Say we lose the first row
x <- x[-1, ]

# This is no longer reconstructable to `to`, as `x` is no longer an rset
# bootstraps object with 25 bootstraps if one is lost!
rset_reconstruct(x, to)
}
