% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_changepoint.R
\name{fortify.cpt}
\alias{fortify.cpt}
\alias{fortify.breakpointsfull}
\alias{fortify.breakpoints}
\title{Convert \code{changepoint::cpt} and \code{strucchange::breakpoints} to \code{data.frame}}
\usage{
\method{fortify}{cpt}(model, data = NULL, is.date = NULL, ...)
}
\arguments{
\item{model}{\code{chantepoint::cpt} or \code{strucchange::breakpoints} instance}

\item{data}{original dataset, if needed}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12.}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{changepoint::cpt} and \code{strucchange::breakpoints} to \code{data.frame}
}
\examples{
\dontrun{
library(changepoint)
fortify(cpt.mean(AirPassengers))
fortify(cpt.var(AirPassengers))
fortify(cpt.meanvar(AirPassengers))

library(strucchange)
bp.nile <- breakpoints(Nile ~ 1)
fortify(bp.nile)
fortify(breakpoints(bp.nile, breaks = 2))
fortify(breakpoints(bp.nile, breaks = 2), data = Nile)
}
}
