//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumberformatterkey?language=objc)
// NS_TYPED_ENUM
pub type CFNumberFormatterKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumberformatter?language=objc)
#[repr(C)]
pub struct CFNumberFormatter {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFNumberFormatter {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFNumberFormatter"> for CFNumberFormatter {}
);

unsafe impl ConcreteType for CFNumberFormatter {
    #[doc(alias = "CFNumberFormatterGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFNumberFormatterGetTypeID() -> CFTypeID;
        }
        unsafe { CFNumberFormatterGetTypeID() }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumberformatterstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFNumberFormatterStyle(pub CFIndex);
impl CFNumberFormatterStyle {
    #[doc(alias = "kCFNumberFormatterNoStyle")]
    pub const NoStyle: Self = Self(0);
    #[doc(alias = "kCFNumberFormatterDecimalStyle")]
    pub const DecimalStyle: Self = Self(1);
    #[doc(alias = "kCFNumberFormatterCurrencyStyle")]
    pub const CurrencyStyle: Self = Self(2);
    #[doc(alias = "kCFNumberFormatterPercentStyle")]
    pub const PercentStyle: Self = Self(3);
    #[doc(alias = "kCFNumberFormatterScientificStyle")]
    pub const ScientificStyle: Self = Self(4);
    #[doc(alias = "kCFNumberFormatterSpellOutStyle")]
    pub const SpellOutStyle: Self = Self(5);
    #[doc(alias = "kCFNumberFormatterOrdinalStyle")]
    pub const OrdinalStyle: Self = Self(6);
    #[doc(alias = "kCFNumberFormatterCurrencyISOCodeStyle")]
    pub const CurrencyISOCodeStyle: Self = Self(8);
    #[doc(alias = "kCFNumberFormatterCurrencyPluralStyle")]
    pub const CurrencyPluralStyle: Self = Self(9);
    #[doc(alias = "kCFNumberFormatterCurrencyAccountingStyle")]
    pub const CurrencyAccountingStyle: Self = Self(10);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFNumberFormatterStyle {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFNumberFormatterStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFNumberFormatter {
    #[doc(alias = "CFNumberFormatterCreate")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        locale: Option<&CFLocale>,
        style: CFNumberFormatterStyle,
    ) -> Option<CFRetained<CFNumberFormatter>> {
        extern "C-unwind" {
            fn CFNumberFormatterCreate(
                allocator: Option<&CFAllocator>,
                locale: Option<&CFLocale>,
                style: CFNumberFormatterStyle,
            ) -> Option<NonNull<CFNumberFormatter>>;
        }
        let ret = unsafe { CFNumberFormatterCreate(allocator, locale, style) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFNumberFormatterGetLocale")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub unsafe fn locale(self: &CFNumberFormatter) -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFNumberFormatterGetLocale(
                formatter: &CFNumberFormatter,
            ) -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFNumberFormatterGetLocale(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFNumberFormatterGetStyle")]
    #[inline]
    pub unsafe fn style(self: &CFNumberFormatter) -> CFNumberFormatterStyle {
        extern "C-unwind" {
            fn CFNumberFormatterGetStyle(formatter: &CFNumberFormatter) -> CFNumberFormatterStyle;
        }
        unsafe { CFNumberFormatterGetStyle(self) }
    }

    #[doc(alias = "CFNumberFormatterGetFormat")]
    #[inline]
    pub unsafe fn format(self: &CFNumberFormatter) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFNumberFormatterGetFormat(
                formatter: &CFNumberFormatter,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFNumberFormatterGetFormat(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFNumberFormatterSetFormat")]
    #[inline]
    pub unsafe fn set_format(self: &CFNumberFormatter, format_string: Option<&CFString>) {
        extern "C-unwind" {
            fn CFNumberFormatterSetFormat(
                formatter: &CFNumberFormatter,
                format_string: Option<&CFString>,
            );
        }
        unsafe { CFNumberFormatterSetFormat(self, format_string) }
    }

    #[doc(alias = "CFNumberFormatterCreateStringWithNumber")]
    #[cfg(feature = "CFNumber")]
    #[inline]
    pub unsafe fn new_string_with_number(
        allocator: Option<&CFAllocator>,
        formatter: Option<&CFNumberFormatter>,
        number: Option<&CFNumber>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFNumberFormatterCreateStringWithNumber(
                allocator: Option<&CFAllocator>,
                formatter: Option<&CFNumberFormatter>,
                number: Option<&CFNumber>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFNumberFormatterCreateStringWithNumber(allocator, formatter, number) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFNumberFormatterCreateStringWithValue")]
    #[cfg(feature = "CFNumber")]
    #[inline]
    pub unsafe fn new_string_with_value(
        allocator: Option<&CFAllocator>,
        formatter: Option<&CFNumberFormatter>,
        number_type: CFNumberType,
        value_ptr: *const c_void,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFNumberFormatterCreateStringWithValue(
                allocator: Option<&CFAllocator>,
                formatter: Option<&CFNumberFormatter>,
                number_type: CFNumberType,
                value_ptr: *const c_void,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe {
            CFNumberFormatterCreateStringWithValue(allocator, formatter, number_type, value_ptr)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumberformatteroptionflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFNumberFormatterOptionFlags(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFNumberFormatterOptionFlags: CFOptionFlags {
        #[doc(alias = "kCFNumberFormatterParseIntegersOnly")]
        const ParseIntegersOnly = 1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFNumberFormatterOptionFlags {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFNumberFormatterOptionFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFNumberFormatter {
    #[doc(alias = "CFNumberFormatterCreateNumberFromString")]
    #[cfg(feature = "CFNumber")]
    #[inline]
    pub unsafe fn new_number_from_string(
        allocator: Option<&CFAllocator>,
        formatter: Option<&CFNumberFormatter>,
        string: Option<&CFString>,
        rangep: *mut CFRange,
        options: CFOptionFlags,
    ) -> Option<CFRetained<CFNumber>> {
        extern "C-unwind" {
            fn CFNumberFormatterCreateNumberFromString(
                allocator: Option<&CFAllocator>,
                formatter: Option<&CFNumberFormatter>,
                string: Option<&CFString>,
                rangep: *mut CFRange,
                options: CFOptionFlags,
            ) -> Option<NonNull<CFNumber>>;
        }
        let ret = unsafe {
            CFNumberFormatterCreateNumberFromString(allocator, formatter, string, rangep, options)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFNumberFormatterGetValueFromString")]
    #[cfg(feature = "CFNumber")]
    #[inline]
    pub unsafe fn value_from_string(
        self: &CFNumberFormatter,
        string: Option<&CFString>,
        rangep: *mut CFRange,
        number_type: CFNumberType,
        value_ptr: *mut c_void,
    ) -> bool {
        extern "C-unwind" {
            fn CFNumberFormatterGetValueFromString(
                formatter: &CFNumberFormatter,
                string: Option<&CFString>,
                rangep: *mut CFRange,
                number_type: CFNumberType,
                value_ptr: *mut c_void,
            ) -> Boolean;
        }
        let ret = unsafe {
            CFNumberFormatterGetValueFromString(self, string, rangep, number_type, value_ptr)
        };
        ret != 0
    }

    #[doc(alias = "CFNumberFormatterSetProperty")]
    #[inline]
    pub unsafe fn set_property(
        self: &CFNumberFormatter,
        key: Option<&CFNumberFormatterKey>,
        value: Option<&CFType>,
    ) {
        extern "C-unwind" {
            fn CFNumberFormatterSetProperty(
                formatter: &CFNumberFormatter,
                key: Option<&CFNumberFormatterKey>,
                value: Option<&CFType>,
            );
        }
        unsafe { CFNumberFormatterSetProperty(self, key, value) }
    }

    #[doc(alias = "CFNumberFormatterCopyProperty")]
    #[inline]
    pub unsafe fn property(
        self: &CFNumberFormatter,
        key: Option<&CFNumberFormatterKey>,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFNumberFormatterCopyProperty(
                formatter: &CFNumberFormatter,
                key: Option<&CFNumberFormatterKey>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CFNumberFormatterCopyProperty(self, key) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattercurrencycode?language=objc)
    pub static kCFNumberFormatterCurrencyCode: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterdecimalseparator?language=objc)
    pub static kCFNumberFormatterDecimalSeparator: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattercurrencydecimalseparator?language=objc)
    pub static kCFNumberFormatterCurrencyDecimalSeparator: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatteralwaysshowdecimalseparator?language=objc)
    pub static kCFNumberFormatterAlwaysShowDecimalSeparator: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattergroupingseparator?language=objc)
    pub static kCFNumberFormatterGroupingSeparator: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterusegroupingseparator?language=objc)
    pub static kCFNumberFormatterUseGroupingSeparator: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterpercentsymbol?language=objc)
    pub static kCFNumberFormatterPercentSymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterzerosymbol?language=objc)
    pub static kCFNumberFormatterZeroSymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatternansymbol?language=objc)
    pub static kCFNumberFormatterNaNSymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterinfinitysymbol?language=objc)
    pub static kCFNumberFormatterInfinitySymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterminussign?language=objc)
    pub static kCFNumberFormatterMinusSign: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterplussign?language=objc)
    pub static kCFNumberFormatterPlusSign: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattercurrencysymbol?language=objc)
    pub static kCFNumberFormatterCurrencySymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterexponentsymbol?language=objc)
    pub static kCFNumberFormatterExponentSymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterminintegerdigits?language=objc)
    pub static kCFNumberFormatterMinIntegerDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattermaxintegerdigits?language=objc)
    pub static kCFNumberFormatterMaxIntegerDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterminfractiondigits?language=objc)
    pub static kCFNumberFormatterMinFractionDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattermaxfractiondigits?language=objc)
    pub static kCFNumberFormatterMaxFractionDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattergroupingsize?language=objc)
    pub static kCFNumberFormatterGroupingSize: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattersecondarygroupingsize?language=objc)
    pub static kCFNumberFormatterSecondaryGroupingSize: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterroundingmode?language=objc)
    pub static kCFNumberFormatterRoundingMode: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterroundingincrement?language=objc)
    pub static kCFNumberFormatterRoundingIncrement: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterformatwidth?language=objc)
    pub static kCFNumberFormatterFormatWidth: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterpaddingposition?language=objc)
    pub static kCFNumberFormatterPaddingPosition: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterpaddingcharacter?language=objc)
    pub static kCFNumberFormatterPaddingCharacter: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterdefaultformat?language=objc)
    pub static kCFNumberFormatterDefaultFormat: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattermultiplier?language=objc)
    pub static kCFNumberFormatterMultiplier: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterpositiveprefix?language=objc)
    pub static kCFNumberFormatterPositivePrefix: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterpositivesuffix?language=objc)
    pub static kCFNumberFormatterPositiveSuffix: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatternegativeprefix?language=objc)
    pub static kCFNumberFormatterNegativePrefix: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatternegativesuffix?language=objc)
    pub static kCFNumberFormatterNegativeSuffix: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterpermillsymbol?language=objc)
    pub static kCFNumberFormatterPerMillSymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterinternationalcurrencysymbol?language=objc)
    pub static kCFNumberFormatterInternationalCurrencySymbol: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattercurrencygroupingseparator?language=objc)
    pub static kCFNumberFormatterCurrencyGroupingSeparator: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterislenient?language=objc)
    pub static kCFNumberFormatterIsLenient: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterusesignificantdigits?language=objc)
    pub static kCFNumberFormatterUseSignificantDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformatterminsignificantdigits?language=objc)
    pub static kCFNumberFormatterMinSignificantDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattermaxsignificantdigits?language=objc)
    pub static kCFNumberFormatterMaxSignificantDigits: Option<&'static CFNumberFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberformattermingroupingdigits?language=objc)
    pub static kCFNumberFormatterMinGroupingDigits: Option<&'static CFNumberFormatterKey>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumberformatterroundingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFNumberFormatterRoundingMode(pub CFIndex);
impl CFNumberFormatterRoundingMode {
    #[doc(alias = "kCFNumberFormatterRoundCeiling")]
    pub const RoundCeiling: Self = Self(0);
    #[doc(alias = "kCFNumberFormatterRoundFloor")]
    pub const RoundFloor: Self = Self(1);
    #[doc(alias = "kCFNumberFormatterRoundDown")]
    pub const RoundDown: Self = Self(2);
    #[doc(alias = "kCFNumberFormatterRoundUp")]
    pub const RoundUp: Self = Self(3);
    #[doc(alias = "kCFNumberFormatterRoundHalfEven")]
    pub const RoundHalfEven: Self = Self(4);
    #[doc(alias = "kCFNumberFormatterRoundHalfDown")]
    pub const RoundHalfDown: Self = Self(5);
    #[doc(alias = "kCFNumberFormatterRoundHalfUp")]
    pub const RoundHalfUp: Self = Self(6);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFNumberFormatterRoundingMode {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFNumberFormatterRoundingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumberformatterpadposition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFNumberFormatterPadPosition(pub CFIndex);
impl CFNumberFormatterPadPosition {
    #[doc(alias = "kCFNumberFormatterPadBeforePrefix")]
    pub const BeforePrefix: Self = Self(0);
    #[doc(alias = "kCFNumberFormatterPadAfterPrefix")]
    pub const AfterPrefix: Self = Self(1);
    #[doc(alias = "kCFNumberFormatterPadBeforeSuffix")]
    pub const BeforeSuffix: Self = Self(2);
    #[doc(alias = "kCFNumberFormatterPadAfterSuffix")]
    pub const AfterSuffix: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFNumberFormatterPadPosition {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFNumberFormatterPadPosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFNumberFormatter {
    #[doc(alias = "CFNumberFormatterGetDecimalInfoForCurrencyCode")]
    #[inline]
    pub unsafe fn decimal_info_for_currency_code(
        currency_code: Option<&CFString>,
        default_fraction_digits: *mut i32,
        rounding_increment: *mut c_double,
    ) -> bool {
        extern "C-unwind" {
            fn CFNumberFormatterGetDecimalInfoForCurrencyCode(
                currency_code: Option<&CFString>,
                default_fraction_digits: *mut i32,
                rounding_increment: *mut c_double,
            ) -> Boolean;
        }
        let ret = unsafe {
            CFNumberFormatterGetDecimalInfoForCurrencyCode(
                currency_code,
                default_fraction_digits,
                rounding_increment,
            )
        };
        ret != 0
    }
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFNumberFormatter::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterCreate(
    allocator: Option<&CFAllocator>,
    locale: Option<&CFLocale>,
    style: CFNumberFormatterStyle,
) -> Option<CFRetained<CFNumberFormatter>> {
    extern "C-unwind" {
        fn CFNumberFormatterCreate(
            allocator: Option<&CFAllocator>,
            locale: Option<&CFLocale>,
            style: CFNumberFormatterStyle,
        ) -> Option<NonNull<CFNumberFormatter>>;
    }
    let ret = unsafe { CFNumberFormatterCreate(allocator, locale, style) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFNumberFormatter::locale`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterGetLocale(
    formatter: &CFNumberFormatter,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFNumberFormatterGetLocale(formatter: &CFNumberFormatter) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFNumberFormatterGetLocale(formatter) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFNumberFormatter::style`"]
    pub fn CFNumberFormatterGetStyle(formatter: &CFNumberFormatter) -> CFNumberFormatterStyle;
}

#[deprecated = "renamed to `CFNumberFormatter::format`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterGetFormat(
    formatter: &CFNumberFormatter,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFNumberFormatterGetFormat(formatter: &CFNumberFormatter) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFNumberFormatterGetFormat(formatter) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFNumberFormatter::set_format`"]
    pub fn CFNumberFormatterSetFormat(
        formatter: &CFNumberFormatter,
        format_string: Option<&CFString>,
    );
}

#[cfg(feature = "CFNumber")]
#[deprecated = "renamed to `CFNumberFormatter::new_string_with_number`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterCreateStringWithNumber(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFNumberFormatter>,
    number: Option<&CFNumber>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFNumberFormatterCreateStringWithNumber(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFNumberFormatter>,
            number: Option<&CFNumber>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFNumberFormatterCreateStringWithNumber(allocator, formatter, number) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFNumber")]
#[deprecated = "renamed to `CFNumberFormatter::new_string_with_value`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterCreateStringWithValue(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFNumberFormatter>,
    number_type: CFNumberType,
    value_ptr: *const c_void,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFNumberFormatterCreateStringWithValue(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFNumberFormatter>,
            number_type: CFNumberType,
            value_ptr: *const c_void,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFNumberFormatterCreateStringWithValue(allocator, formatter, number_type, value_ptr)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFNumber")]
#[deprecated = "renamed to `CFNumberFormatter::new_number_from_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterCreateNumberFromString(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFNumberFormatter>,
    string: Option<&CFString>,
    rangep: *mut CFRange,
    options: CFOptionFlags,
) -> Option<CFRetained<CFNumber>> {
    extern "C-unwind" {
        fn CFNumberFormatterCreateNumberFromString(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFNumberFormatter>,
            string: Option<&CFString>,
            rangep: *mut CFRange,
            options: CFOptionFlags,
        ) -> Option<NonNull<CFNumber>>;
    }
    let ret = unsafe {
        CFNumberFormatterCreateNumberFromString(allocator, formatter, string, rangep, options)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFNumber")]
#[deprecated = "renamed to `CFNumberFormatter::value_from_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterGetValueFromString(
    formatter: &CFNumberFormatter,
    string: Option<&CFString>,
    rangep: *mut CFRange,
    number_type: CFNumberType,
    value_ptr: *mut c_void,
) -> bool {
    extern "C-unwind" {
        fn CFNumberFormatterGetValueFromString(
            formatter: &CFNumberFormatter,
            string: Option<&CFString>,
            rangep: *mut CFRange,
            number_type: CFNumberType,
            value_ptr: *mut c_void,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFNumberFormatterGetValueFromString(formatter, string, rangep, number_type, value_ptr)
    };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFNumberFormatter::set_property`"]
    pub fn CFNumberFormatterSetProperty(
        formatter: &CFNumberFormatter,
        key: Option<&CFNumberFormatterKey>,
        value: Option<&CFType>,
    );
}

#[deprecated = "renamed to `CFNumberFormatter::property`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterCopyProperty(
    formatter: &CFNumberFormatter,
    key: Option<&CFNumberFormatterKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFNumberFormatterCopyProperty(
            formatter: &CFNumberFormatter,
            key: Option<&CFNumberFormatterKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFNumberFormatterCopyProperty(formatter, key) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFNumberFormatter::decimal_info_for_currency_code`"]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberFormatterGetDecimalInfoForCurrencyCode(
    currency_code: Option<&CFString>,
    default_fraction_digits: *mut i32,
    rounding_increment: *mut c_double,
) -> bool {
    extern "C-unwind" {
        fn CFNumberFormatterGetDecimalInfoForCurrencyCode(
            currency_code: Option<&CFString>,
            default_fraction_digits: *mut i32,
            rounding_increment: *mut c_double,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFNumberFormatterGetDecimalInfoForCurrencyCode(
            currency_code,
            default_fraction_digits,
            rounding_increment,
        )
    };
    ret != 0
}
