// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Point, Rect, Vec2, ffi};
use glib::translate::*;

glib::wrapper! {
    pub struct Box2D(BoxedInline<ffi::graphene_box2d_t>);

    match fn {
        copy => |ptr| glib::gobject_ffi::g_boxed_copy(ffi::graphene_box2d_get_type(), ptr as *mut _) as *mut ffi::graphene_box2d_t,
        free => |ptr| glib::gobject_ffi::g_boxed_free(ffi::graphene_box2d_get_type(), ptr as *mut _),
        type_ => || ffi::graphene_box2d_get_type(),
    }
}

impl Box2D {
    #[doc(alias = "graphene_box2d_contains_box")]
    pub fn contains_box(&self, b: &Box2D) -> bool {
        unsafe { ffi::graphene_box2d_contains_box(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_contains_point")]
    pub fn contains_point(&self, point: &Point) -> bool {
        unsafe { ffi::graphene_box2d_contains_point(self.to_glib_none().0, point.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_contains_rect")]
    pub fn contains_rect(&self, rect: &Rect) -> bool {
        unsafe { ffi::graphene_box2d_contains_rect(self.to_glib_none().0, rect.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_equal")]
    fn equal(&self, b: &Box2D) -> bool {
        unsafe { ffi::graphene_box2d_equal(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_expand")]
    #[must_use]
    pub fn expand(&self, point: &Point) -> Box2D {
        unsafe {
            let mut res = Box2D::uninitialized();
            ffi::graphene_box2d_expand(
                self.to_glib_none().0,
                point.to_glib_none().0,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_box2d_expand_scalar")]
    #[must_use]
    pub fn expand_scalar(&self, scalar: f32) -> Box2D {
        unsafe {
            let mut res = Box2D::uninitialized();
            ffi::graphene_box2d_expand_scalar(
                self.to_glib_none().0,
                scalar,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_box2d_expand_vec2")]
    #[must_use]
    pub fn expand_vec2(&self, vec: &Vec2) -> Box2D {
        unsafe {
            let mut res = Box2D::uninitialized();
            ffi::graphene_box2d_expand_vec2(
                self.to_glib_none().0,
                vec.to_glib_none().0,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_box2d_get_center")]
    #[doc(alias = "get_center")]
    pub fn center(&self) -> Point {
        unsafe {
            let mut center = Point::uninitialized();
            ffi::graphene_box2d_get_center(self.to_glib_none().0, center.to_glib_none_mut().0);
            center
        }
    }

    #[doc(alias = "graphene_box2d_get_height")]
    #[doc(alias = "get_height")]
    pub fn height(&self) -> f32 {
        unsafe { ffi::graphene_box2d_get_height(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_get_max")]
    #[doc(alias = "get_max")]
    pub fn max(&self) -> Point {
        unsafe {
            let mut max = Point::uninitialized();
            ffi::graphene_box2d_get_max(self.to_glib_none().0, max.to_glib_none_mut().0);
            max
        }
    }

    #[doc(alias = "graphene_box2d_get_min")]
    #[doc(alias = "get_min")]
    pub fn min(&self) -> Point {
        unsafe {
            let mut min = Point::uninitialized();
            ffi::graphene_box2d_get_min(self.to_glib_none().0, min.to_glib_none_mut().0);
            min
        }
    }

    #[doc(alias = "graphene_box2d_get_minmax")]
    #[doc(alias = "get_minmax")]
    pub fn minmax(&self) -> (Point, Point) {
        unsafe {
            let mut min = Point::uninitialized();
            let mut max = Point::uninitialized();
            ffi::graphene_box2d_get_minmax(
                self.to_glib_none().0,
                min.to_glib_none_mut().0,
                max.to_glib_none_mut().0,
            );
            (min, max)
        }
    }

    #[doc(alias = "graphene_box2d_get_size")]
    #[doc(alias = "get_size")]
    pub fn size(&self) -> Vec2 {
        unsafe {
            let mut size = Vec2::uninitialized();
            ffi::graphene_box2d_get_size(self.to_glib_none().0, size.to_glib_none_mut().0);
            size
        }
    }

    #[doc(alias = "graphene_box2d_get_width")]
    #[doc(alias = "get_width")]
    pub fn width(&self) -> f32 {
        unsafe { ffi::graphene_box2d_get_width(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_intersection")]
    pub fn intersection(&self, b: &Box2D) -> Option<Box2D> {
        unsafe {
            let mut res = Box2D::uninitialized();
            let ret = ffi::graphene_box2d_intersection(
                self.to_glib_none().0,
                b.to_glib_none().0,
                res.to_glib_none_mut().0,
            );
            if ret { Some(res) } else { None }
        }
    }

    #[doc(alias = "graphene_box2d_intersects")]
    pub fn intersects(&self, b: &Box2D) -> bool {
        unsafe { ffi::graphene_box2d_intersects(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "graphene_box2d_scale_offset")]
    #[must_use]
    pub fn scale_offset(&self, scale: Option<&Vec2>, offset: Option<&Point>) -> Box2D {
        unsafe {
            let mut res = Box2D::uninitialized();
            ffi::graphene_box2d_scale_offset(
                self.to_glib_none().0,
                scale.to_glib_none().0,
                offset.to_glib_none().0,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_box2d_to_rect")]
    pub fn to_rect(&self) -> Rect {
        unsafe {
            let mut rect = Rect::uninitialized();
            ffi::graphene_box2d_to_rect(self.to_glib_none().0, rect.to_glib_none_mut().0);
            rect
        }
    }

    #[doc(alias = "graphene_box2d_union")]
    #[must_use]
    pub fn union(&self, b: &Box2D) -> Box2D {
        unsafe {
            let mut res = Box2D::uninitialized();
            ffi::graphene_box2d_union(
                self.to_glib_none().0,
                b.to_glib_none().0,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_box2d_empty")]
    pub fn empty() -> Box2D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_box2d_empty()) }
    }

    #[doc(alias = "graphene_box2d_infinite")]
    pub fn infinite() -> Box2D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_box2d_infinite()) }
    }

    #[doc(alias = "graphene_box2d_minus_one")]
    pub fn minus_one() -> Box2D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_box2d_minus_one()) }
    }

    #[doc(alias = "graphene_box2d_one")]
    pub fn one() -> Box2D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_box2d_one()) }
    }

    #[doc(alias = "graphene_box2d_one_minus_one")]
    pub fn one_minus_one() -> Box2D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_box2d_one_minus_one()) }
    }

    #[doc(alias = "graphene_box2d_zero")]
    pub fn zero() -> Box2D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_box2d_zero()) }
    }
}

impl PartialEq for Box2D {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        self.equal(other)
    }
}

impl Eq for Box2D {}
