"""
certifi.py
~~~~~~~~~~

This module returns the installation location of cacert.pem or its contents.
Patched by openSUSE: return the system bundle
"""
import io


def read_text(_module=None, _path=None, encoding="ascii"):
    with io.open(where(), "r", encoding=encoding) as data:
        return data.read()


def where():
    return "/etc/ssl/ca-bundle.pem"


def contents() -> str:
    return read_text(encoding="ascii")
