require '_h2ph_pre.ph';

no warnings qw(redefine misc);

if(defined(&__KERNEL__)) {
    die("=======================================================");
    die("You should not include /usr/include/{linux,asm}/ header");
    die("files directly for the compilation of kernel modules.");
    die("");
    die("glibc now uses kernel header files from a well-defined");
    die("working kernel version (as recommended by Linus Torvalds)");
    die("These files are glibc internal and may not match the");
    die("currently running kernel. They should only be");
    die("included via other system header files - user space");
    die("programs should not directly include <linux/*.h> or");
    die("<asm/*.h> as well.");
    die("");
    die("Since Linux 2.6, the kernel module build process has been");
    die("updated such that users building modules should not typically");
    die("need to specify additional include directories at all.");
    die("");
    die("To build kernel modules, ensure you have the build environment ");
    die("available either via the kernel-devel and kernel-<flavor>-devel ");
    die("packages or a properly configured kernel source tree.");
    die("");
    die("Then, modules can be built using:");
    die("make -C <path> M=$PWD");
    die("");
    die("For the currently running kernel there will be a symbolic ");
    die("link pointing to the build environment located at ");
    die("/lib/modules/$(uname -r)/build for use as <path>.");
    die("");
    die("If you are seeing this message, your environment is ");
    die("not configured properly. ");
    die("");
    die("Please adjust the Makefile accordingly.");
    die("=======================================================");
} else {
    eval 'sub LINUX_VERSION_CODE () {397568;}' unless defined(&LINUX_VERSION_CODE);
    eval 'sub KERNEL_VERSION {
        my($a,$b,$c) = @_;
	    eval q(((($a) << 16) + (($b) << 8) + (($c) > 255? 255: ($c))));
    }' unless defined(&KERNEL_VERSION);
    eval 'sub LINUX_VERSION_MAJOR () {6;}' unless defined(&LINUX_VERSION_MAJOR);
    eval 'sub LINUX_VERSION_PATCHLEVEL () {17;}' unless defined(&LINUX_VERSION_PATCHLEVEL);
    eval 'sub LINUX_VERSION_SUBLEVEL () {0;}' unless defined(&LINUX_VERSION_SUBLEVEL);
}
1;
