# Design Overview

```
┌─────────────┐   ┌────────────┐                             ┌────────────┐   ┌─────────────────────┐
│             ├───►            │                             │            ├───►                     │
│ host thread │   │            │                             │            │   │ compilation isolate │
│             ◄───┤            │         write stdin         │            ◄───┤                     │
└─────────────┘   │    ruby    ├─────────────────────────────►    dart    │   └─────────────────────┘
                  │            │      from host threads      │            │
┌─────────────┐   │    sass    │                             │    sass    │   ┌─────────────────────┐
│             ├───►            │                             │            ├───►                     │
│     ...     │   │  embedded  │                             │  embedded  │   │         ...         │
│             ◄───┤            │                             │            ◄───┤                     │
└─────────────┘   │    host    │                             │  compiler  │   └─────────────────────┘
                  │            │         read stdout         │            │
┌─────────────┐   │ dispatcher ◄─────────────────────────────┤ dispatcher │   ┌─────────────────────┐
│             ├───►            │      on polling thread      │            ├───►                     │
│ host thread │   │            │                             │            │   │ compilation isolate │
│             ◄───┤            │                             │            ◄───┤                     │
└─────────────┘   └────────────┘                             │            │   └─────────────────────┘
                                                             │            │
┌─────────────┐                                              │            │
│             │                          read stderr         │            │
│ ruby stderr ◄──────────────────────────────────────────────┤            │
│             │                       on polling thread      │            │
└─────────────┘                                              └────────────┘
```

## Host Dispatcher State Diagram

```
┌───────────────────┐                                                            ┌─────────┐
│                   │                                                            │         │
│   Initialize...   │                                        ┌───────────────────►  Close  │
│                   │                                        │                   │         │
└─────────┬─────────┘                                        │                   └─────────┘
          │                                              Yes │
          │                                      ┌───────────┴──────────┐        ┌─────────┐
┌─────────▼─────────┐                         No │                      │    Yes │         │
│                   ◄────────────────────────────┤  id == 0xFFFFFFFF ?  ◄────────┤  Idle?  ◄──────────┐
│  id = 0x00000001  │                            │                      │        │         │          │
│                   ├───────────────┐            └──────────────────────┘        └─────────┘          │
└───────────────────┘               │                                                                 │
                       ┌────────────▼────────────┐   ┌──────────────┐   ┌──────────────────────────┐  │
                       │                         │   │              │   │                          │  │
                       │  CompileRequest(id: 1)  ├───►              ├───►  CompileResponse(id: 1)  │  │
                       │                         │   │              │   │                          │  │
                       └────────────┬────────────┘   │              │   └─────────────┬────────────┘  │
┌───────────────────┐               │                │              │                 │               │
│                   ◄───────────────┘                │              │                 └───────────────┤
│  id = 0x00000002  │                                │              │                                 │
│                   ├───────────────┐                │              │                                 │
└───────────────────┘               │                │              │                                 │
                       ┌────────────▼────────────┐   │              │   ┌──────────────────────────┐  │
                       │                         │   │     dart     │   │                          │  │
                       │  CompileRequest(id: 2)  ├───►              ├───►  CompileResponse(id: 2)  │  │
                       │                         │   │     sass     │   │                          │  │
                       └────────────┬────────────┘   │              │   └────────────┬─────────────┘  │
┌───────────────────┐               │                │   embedded   │                │                │
│                   ◄───────────────┘                │              │                └────────────────┤
│        ...        │                                │   compiler   │                                 │
│                   ├───────────────┐                │              │                                 │
└───────────────────┘               │                │  dispatcher  │                                 │
                       ┌────────────▼────────────┐   │              │   ┌──────────────────────────┐  │
                       │                         │   │              │   │                          │  │
                       │  CompileRequest(.....)  ├───►              ├───►  CompileResponse(.....)  │  │
                       │                         │   │              │   │                          │  │
                       └────────────┬────────────┘   │              │   └────────────┬─────────────┘  │
┌───────────────────┐               │                │              │                │                │
│                   ◄───────────────┘  ┌─────────┐   │              │                └────────────────┤
│  id = 0xFFFFFFFF  │                  │         │   │              │                                 │
│                   ◄──────────────────┤  Error  ◄───┤              │                                 │
└─────────┬─────────┘                  │         │   │              │                                 │
          │                            └─────────┘   └──────────────┘                                 │
          │                                                                                           │
          └───────────────────────────────────────────────────────────────────────────────────────────┘
```
