/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.channel.ChannelHandler;
import java.util.function.Function;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogHandlerH1;
import reactor.netty.http.server.logging.AccessLogHandlerH2;
import reactor.netty.http.server.logging.AccessLogHandlerH3;
import reactor.util.annotation.Nullable;

public enum AccessLogHandlerFactory {
    H1,
    H2,
    H3;


    public ChannelHandler create(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        switch (this) {
            case H3: {
                return new AccessLogHandlerH3(accessLog);
            }
            case H2: {
                return new AccessLogHandlerH2(accessLog);
            }
        }
        return new AccessLogHandlerH1(accessLog);
    }
}

