/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export.handlers;

import io.quarkus.micrometer.runtime.registry.json.JsonMeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

public class JsonHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(JsonHandler.class);
    private JsonMeterRegistry registry;
    private boolean setup = false;

    public void handle(RoutingContext routingContext) {
        if (!this.setup) {
            this.setup();
        }
        HttpServerResponse response = routingContext.response();
        if (this.registry == null) {
            response.setStatusCode(500).setStatusMessage("Unable to resolve JSON registry instance");
        } else {
            response.putHeader("Content-Type", "application/json").end(Buffer.buffer((String)this.registry.scrape()));
        }
    }

    private void setup() {
        Instance registries = CDI.current().select(JsonMeterRegistry.class, new Annotation[]{Default.Literal.INSTANCE});
        if (registries.isUnsatisfied()) {
            this.registry = null;
        } else if (registries.isAmbiguous()) {
            this.registry = (JsonMeterRegistry)((Object)registries.iterator().next());
            log.warnf("Multiple JSON registries present. Using %s with the built in scrape endpoint", (Object)this.registry);
        } else {
            this.registry = (JsonMeterRegistry)((Object)registries.get());
        }
        this.setup = true;
    }
}

