/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MemoryUtil {
    @Nullable
    public static Long getUnusedMemory() {
        if (!SystemInfo.isMac) {
            return null;
        }
        IntByReference pageSizeRef = new IntByReference();
        if (LibC.INSTANCE.host_page_size(LibC.INSTANCE.mach_host_self(), pageSizeRef) == -1) {
            return null;
        }
        long pageSize = pageSizeRef.getValue();
        VmStatistics64 stats = new VmStatistics64();
        IntByReference count2 = new IntByReference(stats.size() / 4);
        if (LibC.INSTANCE.host_statistics64(LibC.INSTANCE.mach_host_self(), 2, stats, count2) == -1) {
            return null;
        }
        return (long)(stats.free_count + stats.inactive_count) * pageSize;
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = Native.load(LibC.class);
        public static final int HOST_VM_INFO64 = 2;

        public int host_statistics64(int var1, int var2, Structure var3, IntByReference var4);

        public int host_page_size(int var1, IntByReference var2);

        public int mach_host_self();
    }

    public static class VmStatistics64
    extends Structure {
        public int free_count;
        public int active_count;
        public int inactive_count;
        public int wire_count;
        public int zero_fill_count;
        public int reactivations;
        public int pageins;
        public int pageouts;
        public int faults;
        public int cow_faults;
        public int lookups;
        public int hits;
        public int purges;
        public int speculative_count;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("free_count", "active_count", "inactive_count", "wire_count", "zero_fill_count", "reactivations", "pageins", "pageouts", "faults", "cow_faults", "lookups", "hits", "purges", "speculative_count");
        }
    }
}

