/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.plugins.ide.internal.tooling.IsolatedGradleProjectParameter;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.IsolatedGradleProjectInternal;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class IsolatedGradleProjectInternalBuilder
implements ParameterizedToolingModelBuilder<IsolatedGradleProjectParameter> {
    public Class<IsolatedGradleProjectParameter> getParameterType() {
        return IsolatedGradleProjectParameter.class;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(IsolatedGradleProjectInternal.class.getName());
    }

    public IsolatedGradleProjectInternal buildAll(String modelName, IsolatedGradleProjectParameter parameter, Project project) {
        return IsolatedGradleProjectInternalBuilder.build(project, parameter.getRealizeTasks());
    }

    public IsolatedGradleProjectInternal buildAll(String modelName, Project project) {
        return IsolatedGradleProjectInternalBuilder.build(project, true);
    }

    private static IsolatedGradleProjectInternal build(Project project, boolean realizeTasks) {
        IsolatedGradleProjectInternal gradleProject = new IsolatedGradleProjectInternal().setProjectIdentifier(new DefaultProjectIdentifier(project.getRootDir(), project.getPath())).setName(project.getName()).setDescription(project.getDescription()).setBuildDirectory((File)project.getLayout().getBuildDirectory().getAsFile().get()).setProjectDirectory(project.getProjectDir());
        gradleProject.getBuildScript().setSourceFile(project.getBuildFile());
        if (realizeTasks) {
            List<LaunchableGradleTask> tasks = IsolatedGradleProjectInternalBuilder.buildTasks(gradleProject, project.getTasks());
            gradleProject.setTasks(tasks);
        }
        return gradleProject;
    }

    private static List<LaunchableGradleTask> buildTasks(IsolatedGradleProjectInternal owner, TaskContainer tasks) {
        return tasks.getNames().stream().map(arg_0 -> ((TaskContainer)tasks).findByName(arg_0)).filter(Objects::nonNull).map(task -> IsolatedGradleProjectInternalBuilder.buildTask(owner, task)).collect(Collectors.toList());
    }

    private static LaunchableGradleTask buildTask(IsolatedGradleProjectInternal owner, Task task) {
        return ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleTask(), owner.getProjectIdentifier(), task).setBuildTreePath(IsolatedGradleProjectInternalBuilder.getBuildTreePath(task));
    }

    private static String getBuildTreePath(Task task) {
        return ((TaskInternal)task).getIdentityPath().asString();
    }
}

