/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressPreviewTableModel;
import ghidra.util.task.TaskMonitor;

public class AddressArrayTableModel
extends AddressPreviewTableModel {
    private Address[] addrs;

    public AddressArrayTableModel(String title, ServiceProvider serviceProvider, Program prog, Address[] addrs, TaskMonitor monitor) {
        super(title, serviceProvider, prog, monitor);
        this.addrs = addrs;
    }

    public AddressArrayTableModel(String title, ServiceProvider serviceProvider, Program prog, Address[] addrs) {
        this(title, serviceProvider, prog, addrs, null);
    }

    protected void doLoad(Accumulator<Address> accumulator, TaskMonitor monitor) throws CancelledException {
        for (Address element : this.addrs) {
            accumulator.add((Object)element);
        }
    }

    public void setAddresses(Address[] addresses) {
        this.addrs = addresses;
        this.reload();
        this.fireTableDataChanged();
    }
}

