/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.RefType;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.state.ContextState;
import ghidra.util.state.FunctionAnalyzer;
import ghidra.util.state.SequenceRange;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ResultsState {
    private static boolean DEBUG = true;
    private static final long[] VALUE_MASK = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    private static final long[] SIGN_BIT = new long[]{0L, 128L, 32768L, 0x800000L, 0x80000000L, 0x8000000000L, 0x800000000000L, 0x80000000000000L};
    private static final Iterator<ContextState> emptyContextStateIterator = new Iterator<ContextState>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ContextState next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    private boolean busy = true;
    private final FunctionAnalyzer analyzer;
    private final Program program;
    private final Listing listing;
    private final AddressFactory addrFactory;
    private final boolean maintainInstructionResults;
    private SequenceNumber entryPt;
    private LinkedList<SequenceNumber> flowList;
    private Varnode stackVarnode;
    private ContextState entryState;
    private Function currentFunction;
    private PrototypeModel currentPrototype;
    private Long paramBaseStackOffset;
    private boolean stackGrowsNegative;
    private AddressSet examinedSet;
    private LinkedList<BranchDestination> todoList = new LinkedList();
    private HashMap<SequenceNumber, List<ContextState>> endStateMap = new HashMap();
    private HashMap<Long, Address> externalThunkMap = new HashMap();
    private ArrayList<Register> inputRegs = new ArrayList();
    private ArrayList<Register> registersModified = new ArrayList();
    private ArrayList<Register> registersPreserved;
    private HashMap<Register, FramePointerCandidate> framePointerCandidates = new HashMap();
    private HashSet<Register> framePointerCandidatesDismissed = new HashSet();
    private LinkedList<ContextStateSet> savedStates = new LinkedList();
    private static Comparator<Object> CONTEXT_STATE_SET_SEQUENCE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            ContextStateSet set = (ContextStateSet)o1;
            SequenceNumber seq = (SequenceNumber)o2;
            if (set.seqRange.contains(seq)) {
                return 0;
            }
            return set.seqRange.getStart().compareTo(seq);
        }
    };
    private static long nextPrivateUnique = -1L;

    public ResultsState(Address entryPt, FunctionAnalyzer analyzer, Program program, boolean maintainInstructionResults, TaskMonitor monitor) throws CancelledException {
        this(new SequenceNumber(entryPt, 0), analyzer, new ContextState(entryPt, program), maintainInstructionResults);
        this.processFunction(monitor);
    }

    public ResultsState(LinkedList<SequenceNumber> flowList, FunctionAnalyzer analyzer, ContextState entryState, boolean maintainInstructionResults, TaskMonitor monitor) throws CancelledException {
        this(flowList.getFirst(), analyzer, entryState, maintainInstructionResults);
        this.flowList = new LinkedList<SequenceNumber>(flowList);
        this.flowList.removeFirst();
        this.processFunction(monitor);
    }

    private ResultsState(SequenceNumber entryPt, FunctionAnalyzer analyzer, ContextState entryState, boolean maintainInstructionResults) {
        this.entryPt = entryPt;
        this.analyzer = analyzer;
        this.entryState = entryState;
        this.maintainInstructionResults = maintainInstructionResults;
        this.program = entryState.getProgram();
        this.listing = this.program.getListing();
        this.addrFactory = this.program.getAddressFactory();
        this.currentFunction = this.listing.getFunctionContaining(entryPt.getTarget());
        if (this.currentFunction != null) {
            this.currentPrototype = this.currentFunction.getCallingConvention();
        }
        if (this.currentPrototype == null) {
            this.currentPrototype = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        this.stackGrowsNegative = this.program.getCompilerSpec().stackGrowsNegative();
        Long stackOffset = this.currentPrototype.getStackParameterOffset();
        this.paramBaseStackOffset = stackOffset != null ? Long.valueOf(stackOffset - (long)this.currentPrototype.getStackshift()) : null;
        this.todoList.add(new BranchDestination(null, entryPt, entryState));
    }

    public SequenceNumber getEntryPoint() {
        return this.entryPt;
    }

    public AddressSetView getExaminedSet() {
        return this.examinedSet;
    }

    public void assume(Register register, long value) {
        if (register.isProcessorContext()) {
            throw new IllegalArgumentException("Context register not permitted");
        }
        this.entryState.store(new Varnode(register.getAddress(), register.getMinimumByteSize()), new Varnode(this.addrFactory.getConstantAddress(value), register.getMinimumByteSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFunction(TaskMonitor monitor) throws CancelledException {
        ContextState currentState = null;
        ContextState previousState = null;
        SequenceNumber nextSeq = null;
        SequenceNumber flowFrom = null;
        this.examinedSet = new AddressSet();
        try {
            while (nextSeq != null || !this.todoList.isEmpty()) {
                Instruction instr;
                monitor.checkCancelled();
                if (nextSeq == null) {
                    assert (currentState == null);
                    BranchDestination dest = this.todoList.removeFirst();
                    nextSeq = dest.destination;
                    previousState = dest.initialState;
                    flowFrom = dest.source;
                }
                if ((instr = this.listing.getInstructionAt(nextSeq.getTarget())) == null) {
                    this.program.getBookmarkManager().setBookmark(nextSeq.getTarget(), "Error", "Missing Instruction", "Expected instruction as result of flow from: " + String.valueOf(flowFrom));
                    nextSeq = null;
                    continue;
                }
                this.examinedSet.addRange(instr.getMinAddress(), instr.getMaxAddress());
                if (nextSeq.getTime() == 0 && currentState != null && this.program.getReferenceManager().getReferencesTo(nextSeq.getTarget()).hasNext()) {
                    this.addState(flowFrom, currentState);
                    previousState = currentState;
                    currentState = null;
                }
                if (DEBUG) {
                    Msg.debug((Object)this, (Object)(">>> At " + String.valueOf(nextSeq.getTarget()) + "/" + nextSeq.getTime() + " " + String.valueOf(instr)));
                }
                SequenceNumber lastSeq = flowFrom;
                for (PcodeOp pcodeOp : instr.getPcode(true)) {
                    monitor.checkCancelled();
                    if (pcodeOp.getSeqnum().getTime() < nextSeq.getTime()) continue;
                    lastSeq = pcodeOp.getSeqnum();
                    if (currentState == null) {
                        ContextStateSet existingStates = this.getContextStateSet(pcodeOp.getSeqnum());
                        if (existingStates != null) {
                            if (existingStates.containsKey(flowFrom)) {
                                if (DEBUG) {
                                    Msg.debug((Object)this, (Object)("Flow ignored - already processed: " + String.valueOf(flowFrom) + " -> " + String.valueOf(pcodeOp.getSeqnum())));
                                }
                                instr = null;
                                break;
                            }
                            for (ContextState otherEntryState : existingStates.values()) {
                                if (otherEntryState.hasDifferingRegisters(previousState)) continue;
                                this.addState(flowFrom, otherEntryState);
                                instr = null;
                                if (!DEBUG) break;
                                Msg.debug((Object)this, (Object)("Flow combined - similar state: " + String.valueOf(flowFrom) + " -> " + String.valueOf(pcodeOp.getSeqnum())));
                                break;
                            }
                        }
                        currentState = previousState.branchState(pcodeOp.getSeqnum());
                        currentState.addFlowFrom(flowFrom);
                        previousState.lock();
                        previousState = null;
                    }
                    try {
                        if (this.processAndEmulatePCode(pcodeOp, currentState, monitor)) continue;
                        this.addState(flowFrom, currentState);
                        previousState = currentState;
                        currentState = null;
                    }
                    catch (InlineCallException inlineExc) {
                        this.addState(flowFrom, currentState);
                        previousState = this.performInlineCall(inlineExc.getInlineCallAddress(), currentState, monitor);
                        if (previousState == null) continue;
                        currentState = null;
                    }
                }
                if (currentState != null) {
                    currentState.clearUniqueState();
                    if (this.maintainInstructionResults) {
                        this.addState(flowFrom, currentState);
                        previousState = currentState;
                        currentState = null;
                    }
                }
                nextSeq = null;
                if (instr == null) continue;
                Address fallthroughAddr = instr.getFallThrough();
                if (fallthroughAddr == null) {
                    if (currentState != null) {
                        currentState.lock();
                        this.addState(flowFrom, currentState);
                    }
                    currentState = null;
                    previousState = null;
                    continue;
                }
                nextSeq = new SequenceNumber(fallthroughAddr, 0);
                if (!this.maintainInstructionResults) continue;
                flowFrom = lastSeq;
            }
        }
        finally {
            this.busy = false;
        }
    }

    private void addState(SequenceNumber flowFrom, ContextState state) {
        SequenceRange seqRange = state.getSequenceRange();
        SystemUtilities.assertTrue((seqRange != null ? 1 : 0) != 0, (String)"ContextState does not have sequence range set");
        ContextStateSet existingStates = this.getContextStateSet(seqRange.getStart());
        if (existingStates == null) {
            existingStates = this.createContextStateSet(seqRange);
        }
        state.addFlowFrom(flowFrom);
        existingStates.put(flowFrom, state);
    }

    private void addEndState(SequenceNumber returnPcodeSeq, ContextState state) {
        List<ContextState> returnStates = this.endStateMap.get(returnPcodeSeq);
        if (returnStates == null) {
            returnStates = new ArrayList<ContextState>();
            this.endStateMap.put(returnPcodeSeq, returnStates);
        } else {
            for (ContextState otherEntryState : returnStates) {
                if (otherEntryState.hasDifferingRegisters(state)) continue;
                return;
            }
        }
        returnStates.add(state);
    }

    public Iterator<ContextState> getContextStates(SequenceNumber seq) {
        ContextStateSet set = this.getContextStateSet(seq);
        if (set != null) {
            return set.values().iterator();
        }
        return emptyContextStateIterator;
    }

    private ContextStateSet getContextStateSet(SequenceNumber seq) {
        int index = Collections.binarySearch(this.savedStates, seq, CONTEXT_STATE_SET_SEQUENCE_COMPARATOR);
        if (index >= 0) {
            return this.savedStates.get(index);
        }
        return null;
    }

    private ContextStateSet createContextStateSet(SequenceRange seqRange) {
        int index = Collections.binarySearch(this.savedStates, seqRange.getStart(), CONTEXT_STATE_SET_SEQUENCE_COMPARATOR);
        if (index >= 0) {
            throw new AssertException();
        }
        index = -index - 1;
        ContextStateSet set = new ContextStateSet(seqRange);
        this.savedStates.add(index, set);
        return set;
    }

    private ContextState performInlineCall(Address inlineCallAddress, ContextState currentState, TaskMonitor monitor) throws CancelledException {
        Iterator<List<ContextState>> iterator;
        if (DEBUG) {
            Msg.debug((Object)this, (Object)("*** Start Inline Call to " + String.valueOf(inlineCallAddress) + " ***"));
        }
        ResultsState inlineState = new ResultsState(new SequenceNumber(inlineCallAddress, 0), null, currentState, this.maintainInstructionResults);
        inlineState.processFunction(monitor);
        if (DEBUG) {
            Msg.debug((Object)this, (Object)("*** End Inline Call to " + String.valueOf(inlineCallAddress) + " ***"));
        }
        if ((iterator = inlineState.endStateMap.values().iterator()).hasNext()) {
            return iterator.next().get(0);
        }
        return null;
    }

    boolean processAndEmulatePCode(PcodeOp pcodeOp, ContextState currentState, TaskMonitor monitor) throws CancelledException, InlineCallException {
        SequenceNumber seq = pcodeOp.getSeqnum();
        currentState.setExitPoint(seq);
        Varnode[] inputs = pcodeOp.getInputs();
        Varnode output = pcodeOp.getOutput();
        Varnode[] values = new Varnode[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            values[i] = this.simplify(currentState.get(inputs[i], monitor), monitor);
            if (values[i] == null) {
                values[i] = inputs[i];
                this.checkInput(inputs[i]);
                continue;
            }
            if (output == null || !inputs[i].isAddress() || !values[i].isConstant() || this.listing.getFunctionAt(inputs[i].getAddress()) == null) continue;
            this.externalThunkMap.put(values[i].getOffset(), inputs[i].getAddress());
        }
        if (this.analyzer != null) {
            for (Varnode input : inputs) {
                if (!input.isAddress()) continue;
                int opIndex = this.findOpIndex(pcodeOp, input);
                this.analyzer.dataReference(pcodeOp, opIndex, input, RefType.READ, monitor);
            }
            if (output != null && output.isAddress()) {
                int opIndex = this.findOpIndex(pcodeOp, output);
                this.analyzer.dataReference(pcodeOp, opIndex, output, RefType.WRITE, monitor);
            }
        }
        if (output != null && output.getSize() > 8) {
            VarnodeOperation result = new VarnodeOperation(pcodeOp, values);
            this.checkAssignment(output, result, pcodeOp, monitor);
            currentState.store(output, result);
            return true;
        }
        Varnode result = null;
        result = pcodeOp.getOpcode() == 2 ? this.simplifyLoad(pcodeOp, values, currentState, monitor) : ResultsState.simplify(pcodeOp, values, this.addrFactory, monitor);
        if (result instanceof VarnodeOperation && !this.emulateOperation((VarnodeOperation)result, currentState, monitor)) {
            return false;
        }
        if (output != null) {
            if (result == null) {
                throw new AssertException("Result should not be null");
            }
            this.checkAssignment(output, result, pcodeOp, monitor);
            currentState.store(output, result);
        }
        return true;
    }

    private Varnode simplify(Varnode varnode, TaskMonitor monitor) throws CancelledException {
        if (varnode == null || !(varnode instanceof VarnodeOperation)) {
            return varnode;
        }
        VarnodeOperation op = (VarnodeOperation)varnode;
        if (op.isSimplified()) {
            return op;
        }
        Varnode result = ResultsState.simplify(op.getPCodeOp(), op.getInputValues(), this.addrFactory, monitor);
        if (result instanceof VarnodeOperation) {
            ((VarnodeOperation)result).setSimplified(true);
        }
        return result;
    }

    private Varnode simplifyLoad(PcodeOp pcodeOp, Varnode[] values, ContextState currentState, TaskMonitor monitor) throws CancelledException {
        Varnode result;
        Varnode output = pcodeOp.getOutput();
        if (!values[0].isConstant()) {
            throw new AssertException("Expected constatnt address space ID");
        }
        int spaceId = (int)values[0].getOffset();
        AddressSpace addressSpace = this.addrFactory.getAddressSpace(spaceId);
        if (addressSpace == null) {
            throw new IllegalArgumentException("Unknown spaceID: " + spaceId);
        }
        int size = output.getSize();
        Varnode storageOffset = values[1];
        Varnode stackOffset = this.getStackOffset(pcodeOp, storageOffset, monitor);
        if (stackOffset != null) {
            if (stackOffset.isConstant()) {
                long offset = ResultsState.getSignedOffset(stackOffset);
                AddressSpace stackSpace = this.addrFactory.getStackSpace();
                Varnode stackVarnode = new Varnode(stackSpace.getAddress(offset, true), size);
                result = currentState.get(stackVarnode, monitor);
                if (result == null) {
                    result = stackVarnode;
                }
                if (this.analyzer != null) {
                    int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                    this.analyzer.stackReference(pcodeOp, opIndex, (int)offset, size, spaceId, RefType.READ, monitor);
                }
            } else if (stackOffset instanceof VarnodeOperation) {
                result = currentState.get(spaceId, storageOffset, size, monitor);
                if (this.analyzer != null) {
                    int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                    this.analyzer.stackReference(pcodeOp, opIndex, (VarnodeOperation)stackOffset, size, spaceId, RefType.READ, monitor);
                }
            } else {
                result = null;
            }
        } else if (storageOffset.isConstant()) {
            Varnode v = new Varnode(addressSpace.getAddress(storageOffset.getOffset(), true), size);
            result = currentState.get(v, monitor);
            if (result != null && result.isConstant() && this.listing.getFunctionAt(v.getAddress()) != null) {
                this.externalThunkMap.put(result.getOffset(), v.getAddress());
            }
            if (this.analyzer != null) {
                int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                this.analyzer.dataReference(pcodeOp, opIndex, v, RefType.READ, monitor);
            }
        } else {
            result = currentState.get(spaceId, storageOffset, size, monitor);
            if (this.analyzer != null) {
                int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                this.analyzer.indirectDataReference(pcodeOp, opIndex, storageOffset, size, spaceId, RefType.READ, monitor);
            }
        }
        if (result == null) {
            result = new VarnodeOperation(pcodeOp, values);
        }
        return result;
    }

    private static synchronized Varnode getNewUnique(AddressFactory addrFactory, int size) {
        AddressSpace uniqueSpace = addrFactory.getAddressSpace("unique");
        return new Varnode(uniqueSpace.getAddress(nextPrivateUnique--), size);
    }

    private boolean emulateOperation(VarnodeOperation op, ContextState currentState, TaskMonitor monitor) throws CancelledException, InlineCallException {
        PcodeOp pcodeOp = op.getPCodeOp();
        SequenceNumber seq = pcodeOp.getSeqnum();
        Varnode[] inputs = pcodeOp.getInputs();
        Varnode[] values = op.getInputValues();
        switch (pcodeOp.getOpcode()) {
            case 3: {
                if (!values[0].isConstant()) {
                    throw new AssertException("Expected constatnt address space ID");
                }
                int spaceId = (int)values[0].getOffset();
                AddressSpace addressSpace = this.addrFactory.getAddressSpace(spaceId);
                if (addressSpace == null) {
                    throw new IllegalArgumentException("Unknown spaceID: " + spaceId);
                }
                Varnode storedValue = values[2];
                int size = values[2].getSize();
                Varnode storageOffset = values[1];
                Varnode stackOffset = this.getStackOffset(pcodeOp, storageOffset, monitor);
                if (stackOffset != null) {
                    if (stackOffset.isConstant()) {
                        long offset = ResultsState.getSignedOffset(stackOffset);
                        AddressSpace stackSpace = this.addrFactory.getStackSpace();
                        Varnode stackVarnode = new Varnode(stackSpace.getAddress(offset, true), size);
                        currentState.store(stackVarnode, storedValue);
                        if (this.analyzer == null) break;
                        int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                        this.analyzer.stackReference(pcodeOp, opIndex, (int)offset, size, spaceId, RefType.WRITE, monitor);
                        break;
                    }
                    if (!(stackOffset instanceof VarnodeOperation)) break;
                    currentState.store(spaceId, storageOffset, storedValue, size);
                    if (this.analyzer == null) break;
                    int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                    this.analyzer.stackReference(pcodeOp, opIndex, (VarnodeOperation)stackOffset, size, spaceId, RefType.WRITE, monitor);
                    break;
                }
                if (storageOffset.isConstant()) {
                    Varnode v = new Varnode(addressSpace.getAddress(storageOffset.getOffset() * (long)addressSpace.getAddressableUnitSize()), size);
                    currentState.store(v, storedValue);
                    if (this.analyzer == null) break;
                    int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                    this.analyzer.dataReference(pcodeOp, opIndex, v, RefType.WRITE, monitor);
                    break;
                }
                currentState.store(spaceId, storageOffset, storedValue, size);
                if (this.analyzer == null) break;
                int opIndex = this.findOpIndex(pcodeOp, pcodeOp.getInput(1));
                this.analyzer.indirectDataReference(pcodeOp, opIndex, storageOffset, size, spaceId, RefType.WRITE, monitor);
                break;
            }
            case 5: {
                if (values[1].isConstant() && values[1].getOffset() == 0L) {
                    if (!DEBUG) break;
                    Msg.debug((Object)this, (Object)("Conditional Branch to " + String.valueOf(inputs[0].getAddress()) + " - Not taken due to false condition value"));
                    break;
                }
            }
            case 4: {
                if (inputs[0].isConstant()) {
                    SequenceNumber dest = new SequenceNumber(seq.getTarget(), seq.getTime() + (int)inputs[0].getOffset());
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)("Internal " + (pcodeOp.getOpcode() == 5 ? "Conditional " : "") + "Branch to " + String.valueOf(dest)));
                    }
                    this.todoList.add(new BranchDestination(pcodeOp.getSeqnum(), dest, currentState));
                } else if (inputs[0].isAddress()) {
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)((pcodeOp.getOpcode() == 5 ? "Conditional " : "") + "Branch to " + String.valueOf(inputs[0].getAddress())));
                    }
                    this.handleDirectFlow(pcodeOp, inputs[0].getAddress(), currentState, monitor);
                } else {
                    throw new AssertException();
                }
                return false;
            }
            case 6: {
                if (values[0].isConstant()) {
                    AddressSpace space = currentState.getEntryPoint().getTarget().getAddressSpace();
                    Address destAddr = space.getAddress(ResultsState.getUnsignedOffset(values[0], space.getPointerSize()));
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)("Branch to " + String.valueOf(destAddr)));
                    }
                    this.handleDirectFlow(pcodeOp, destAddr, currentState, monitor);
                } else if (values[0].isAddress()) {
                    Varnode brOffset = currentState.get(values[0], monitor);
                    if (brOffset != null && brOffset.isConstant() && brOffset.getOffset() != 0L) {
                        AddressSpace space = currentState.getEntryPoint().getTarget().getAddressSpace();
                        Address destAddr = space.getAddress(ResultsState.getUnsignedOffset(brOffset, space.getPointerSize()));
                        if (DEBUG) {
                            Msg.debug((Object)this, (Object)("Indirect Branch to [" + String.valueOf(values[0].getAddress()) + "] -> " + String.valueOf(destAddr)));
                        }
                        this.handleDirectFlow(pcodeOp, destAddr, currentState, monitor);
                    } else {
                        if (DEBUG) {
                            Msg.debug((Object)this, (Object)("Indirect Branch to [" + values[0].toString(this.program.getLanguage()) + "]"));
                        }
                        this.handleIndirectFlow(pcodeOp, values[0], currentState, monitor);
                    }
                } else {
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)("Indirect Branch to [" + values[0].toString(this.program.getLanguage()) + "]"));
                    }
                    this.handleIndirectFlow(pcodeOp, values[0], currentState, monitor);
                }
                return false;
            }
            case 7: {
                if (inputs[0].isAddress()) {
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)("Call to " + String.valueOf(inputs[0].getAddress())));
                    }
                } else {
                    throw new AssertException();
                }
                this.handleCall(pcodeOp, null, inputs[0].getAddress(), currentState, monitor);
                return false;
            }
            case 8: {
                Address indirectPtr;
                Address address = indirectPtr = inputs[0].isAddress() ? inputs[0].getAddress() : null;
                if (values[0].isConstant()) {
                    AddressSpace space = currentState.getEntryPoint().getTarget().getAddressSpace();
                    Address destAddr = space.getAddress(ResultsState.getUnsignedOffset(values[0], space.getPointerSize()));
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)("Call to " + String.valueOf(destAddr)));
                    }
                    this.handleCall(pcodeOp, indirectPtr, destAddr, currentState, monitor);
                } else if (values[0].isAddress()) {
                    Varnode callOffset = currentState.get(values[0], monitor);
                    if (callOffset != null && callOffset.isConstant() && callOffset.getOffset() != 0L) {
                        AddressSpace space = currentState.getEntryPoint().getTarget().getAddressSpace();
                        Address destAddr = space.getAddress(ResultsState.getUnsignedOffset(callOffset, space.getPointerSize()));
                        if (DEBUG) {
                            Msg.debug((Object)this, (Object)("Indirect Call to [" + String.valueOf(values[0].getAddress()) + "] -> " + String.valueOf(destAddr)));
                        }
                        this.handleCall(pcodeOp, indirectPtr, destAddr, currentState, monitor);
                    } else {
                        if (DEBUG) {
                            Msg.debug((Object)this, (Object)("Indirect Call to [" + values[0].toString(this.program.getLanguage()) + "]"));
                        }
                        this.handleIndirectCall(pcodeOp, indirectPtr, values[0], currentState, monitor);
                    }
                } else {
                    if (DEBUG) {
                        Msg.debug((Object)this, (Object)("Indirect Call to [" + values[0].toString(this.program.getLanguage()) + "]"));
                    }
                    this.handleIndirectCall(pcodeOp, indirectPtr, values[0], currentState, monitor);
                }
                return false;
            }
            case 9: {
                break;
            }
            case 10: {
                this.addEndState(pcodeOp.getSeqnum(), currentState);
                return false;
            }
        }
        return true;
    }

    private Varnode getStackOffset(PcodeOp loadStoreOp, Varnode offsetValue, TaskMonitor monitor) {
        Varnode stackPtr = this.getStackPointerVarnode();
        if (offsetValue instanceof VarnodeOperation) {
            VarnodeOperation op = (VarnodeOperation)offsetValue;
            int opcode = op.getPCodeOp().getOpcode();
            Varnode[] inputs = op.getInputValues();
            if (opcode == 19) {
                if (inputs[0].isConstant() && inputs[1].equals((Object)stackPtr)) {
                    return inputs[0];
                }
                if (inputs[1].isConstant() && inputs[0].equals((Object)stackPtr)) {
                    return inputs[1];
                }
            } else if (opcode == 20 && inputs[1].isConstant() && inputs[0].equals((Object)stackPtr)) {
                return new Varnode(this.addrFactory.getConstantAddress(-ResultsState.getSignedOffset(inputs[1])), inputs[1].getSize());
            }
        } else if (offsetValue.equals((Object)stackPtr)) {
            return new Varnode(this.addrFactory.getConstantAddress(0L), stackPtr.getSize());
        }
        return null;
    }

    public static Varnode simplify(PcodeOp pcodeOp, Varnode[] values, AddressFactory addrFactory, TaskMonitor monitor) throws CancelledException {
        SequenceNumber seq = pcodeOp.getSeqnum();
        Varnode output = pcodeOp.getOutput();
        Varnode result = null;
        switch (pcodeOp.getOpcode()) {
            case 1: {
                result = values[0];
                break;
            }
            case 11: {
                if (values[0].equals((Object)values[1])) {
                    result = new Varnode(addrFactory.getConstantAddress(1L), 1);
                    break;
                }
                if (!values[0].isConstant() || !values[1].isConstant()) break;
                int b = ResultsState.getUnsignedOffset(values[0], values[0].getSize()) == ResultsState.getUnsignedOffset(values[1], values[1].getSize()) ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 12: {
                if (values[0].equals((Object)values[1])) {
                    result = new Varnode(addrFactory.getConstantAddress(0L), 1);
                    break;
                }
                if (!values[0].isConstant() || !values[1].isConstant()) break;
                int b = ResultsState.getUnsignedOffset(values[0], values[0].getSize()) != ResultsState.getUnsignedOffset(values[1], values[1].getSize()) ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 13: {
                if (!values[0].isConstant() || !values[1].isConstant()) break;
                int b = ResultsState.getSignedOffset(values[0]) < ResultsState.getSignedOffset(values[1]) ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 14: {
                if (!values[0].isConstant() || !values[1].isConstant()) break;
                int b = ResultsState.getSignedOffset(values[0]) <= ResultsState.getSignedOffset(values[1]) ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 15: {
                if (!values[0].isConstant() || !values[1].isConstant()) break;
                int b = ResultsState.getUnsignedOffset(values[0], values[0].getSize()) < ResultsState.getUnsignedOffset(values[1], values[1].getSize()) ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 16: {
                if (!values[0].isConstant() || !values[1].isConstant()) break;
                int b = ResultsState.getUnsignedOffset(values[0], values[0].getSize()) <= ResultsState.getUnsignedOffset(values[1], values[1].getSize()) ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 17: {
                if (!values[0].isConstant()) break;
                result = new Varnode(addrFactory.getConstantAddress(ResultsState.getUnsignedOffset(values[0], values[0].getSize())), output.getSize());
                break;
            }
            case 18: {
                if (!values[0].isConstant()) break;
                long signedOffset = ResultsState.getSignedOffset(values[0]) & VALUE_MASK[output.getSize()];
                result = new Varnode(addrFactory.getConstantAddress(signedOffset), output.getSize());
                break;
            }
            case 19: {
                if (values[0].isConstant()) {
                    VarnodeOperation op = ResultsState.flipInputs(pcodeOp, values);
                    pcodeOp = op.getPCodeOp();
                }
                if (!values[1].isConstant()) break;
                if (values[0].isConstant()) {
                    long signedOffset = ResultsState.getSignedOffset(values[1]) + ResultsState.getSignedOffset(values[0]) & VALUE_MASK[output.getSize()];
                    result = new Varnode(addrFactory.getConstantAddress(signedOffset), output.getSize());
                    break;
                }
                if (values[1].getOffset() == 0L) {
                    result = values[0];
                    break;
                }
                if (!(values[0] instanceof VarnodeOperation)) break;
                result = ResultsState.pushDownIntAddOffset((VarnodeOperation)values[0], ResultsState.getSignedOffset(values[1]), addrFactory, monitor);
                break;
            }
            case 20: {
                if (values[0].equals((Object)values[1])) {
                    result = new Varnode(addrFactory.getConstantAddress(0L), output.getSize());
                    break;
                }
                if (!values[1].isConstant()) break;
                if (values[0].isConstant()) {
                    long signedOffset = ResultsState.getSignedOffset(values[0]) - ResultsState.getSignedOffset(values[1]) & VALUE_MASK[output.getSize()];
                    result = new Varnode(addrFactory.getConstantAddress(signedOffset), output.getSize());
                    break;
                }
                if (values[1].getOffset() == 0L) {
                    result = values[0];
                    break;
                }
                if (!(values[0] instanceof VarnodeOperation)) break;
                result = ResultsState.pushDownIntAddOffset((VarnodeOperation)values[0], -ResultsState.getSignedOffset(values[1]), addrFactory, monitor);
                break;
            }
            case 21: {
                return ResultsState.eillimnateCarryOp(pcodeOp, values, addrFactory, monitor);
            }
            case 22: 
            case 23: {
                if ((!values[1].isConstant() || values[1].getOffset() != 0L) && (!values[0].isConstant() || values[0].getOffset() != 0L)) break;
                result = new Varnode(addrFactory.getConstantAddress(0L), 1);
                break;
            }
            case 24: {
                if (!values[0].isConstant()) break;
                result = new Varnode(addrFactory.getConstantAddress(-values[0].getOffset()), output.getSize());
                break;
            }
            case 25: {
                if (!values[0].isConstant()) break;
                result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() ^ 0xFFFFFFFFFFFFFFFFL), output.getSize());
                break;
            }
            case 26: {
                if (values[0].equals((Object)values[1])) {
                    result = new Varnode(addrFactory.getConstantAddress(0L), output.getSize());
                    break;
                }
                if (values[1].isConstant() && values[0].isConstant()) {
                    result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() ^ values[1].getOffset()), output.getSize());
                    break;
                }
                if (values[0].isConstant()) {
                    if (values[0].getOffset() == 0L) {
                        result = values[1];
                        break;
                    }
                    VarnodeOperation op = ResultsState.flipInputs(pcodeOp, values);
                    result = ResultsState.combineLogicOrOperation(op, addrFactory);
                    break;
                }
                if (!values[1].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    result = values[0];
                    break;
                }
                VarnodeOperation op = new VarnodeOperation(pcodeOp, values);
                result = ResultsState.combineLogicOrOperation(op, addrFactory);
                break;
            }
            case 27: {
                if (values[1].isConstant() && values[1].getOffset() == 0L || values[0].isConstant() && values[0].getOffset() == 0L) {
                    result = new Varnode(addrFactory.getConstantAddress(0L), output.getSize());
                    break;
                }
                if (values[1].isConstant() && values[0].isConstant()) {
                    result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() & values[1].getOffset()), output.getSize());
                    break;
                }
                if (values[0].isConstant()) {
                    result = ResultsState.simplifyWithIntAndMask(seq, values[1], ResultsState.getUnsignedOffset(values[0], output.getSize()), addrFactory, monitor);
                    break;
                }
                if (!values[1].isConstant()) break;
                result = ResultsState.simplifyWithIntAndMask(seq, values[0], ResultsState.getUnsignedOffset(values[1], output.getSize()), addrFactory, monitor);
                break;
            }
            case 28: {
                if (values[0].equals((Object)values[1])) {
                    result = values[0];
                    break;
                }
                if (values[1].isConstant() && values[0].isConstant()) {
                    result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() | values[1].getOffset()), output.getSize());
                    break;
                }
                if (values[0].isConstant()) {
                    if (values[0].getOffset() == 0L) {
                        result = values[1];
                        break;
                    }
                    VarnodeOperation op = ResultsState.flipInputs(pcodeOp, values);
                    result = ResultsState.combineLogicOrOperation(op, addrFactory);
                    break;
                }
                if (!values[1].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    result = values[0];
                    break;
                }
                VarnodeOperation op = new VarnodeOperation(pcodeOp, values);
                result = ResultsState.combineLogicOrOperation(op, addrFactory);
                break;
            }
            case 29: {
                if (!values[1].isConstant() || values[1].getOffset() >= 64L) break;
                if (values[0].isConstant()) {
                    result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() << (int)values[1].getOffset()), output.getSize());
                    break;
                }
                result = ResultsState.combineDoubleShiftOperation(pcodeOp, values, addrFactory);
                break;
            }
            case 30: {
                if (!values[1].isConstant() || values[1].getOffset() >= 64L) break;
                if (values[0].isConstant()) {
                    result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() >>> (int)values[1].getOffset()), output.getSize());
                    break;
                }
                result = ResultsState.combineDoubleShiftOperation(pcodeOp, values, addrFactory);
                break;
            }
            case 31: {
                if (!values[1].isConstant() || !values[0].isConstant() || values[1].getOffset() >= 64L) break;
                result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() >> (int)values[1].getOffset()), output.getSize());
                break;
            }
            case 32: {
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() * values[1].getOffset()), output.getSize());
                break;
            }
            case 33: {
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    Msg.warn(ResultsState.class, (Object)("Divide by zero encounteerd during emulation at " + String.valueOf(pcodeOp.getSeqnum().getTarget())));
                    break;
                }
                result = new Varnode(addrFactory.getConstantAddress(ResultsState.getUnsignedOffset(values[0], output.getSize()) / ResultsState.getUnsignedOffset(values[1], output.getSize())), output.getSize());
                break;
            }
            case 34: {
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    Msg.warn(ResultsState.class, (Object)("Divide by zero encounteerd during emulation at " + String.valueOf(pcodeOp.getSeqnum().getTarget())));
                    break;
                }
                result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() / values[1].getOffset()), output.getSize());
                break;
            }
            case 35: {
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    Msg.warn(ResultsState.class, (Object)("Divide by zero encounteerd during emulation at " + String.valueOf(pcodeOp.getSeqnum().getTarget())));
                    break;
                }
                result = new Varnode(addrFactory.getConstantAddress(ResultsState.getUnsignedOffset(values[0], output.getSize()) % ResultsState.getUnsignedOffset(values[1], output.getSize())), output.getSize());
                break;
            }
            case 36: {
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    Msg.warn(ResultsState.class, (Object)("Divide by zero encounteerd during emulation at " + String.valueOf(pcodeOp.getSeqnum().getTarget())));
                    break;
                }
                result = new Varnode(addrFactory.getConstantAddress(values[0].getOffset() % values[1].getOffset()), output.getSize());
                break;
            }
            case 37: {
                VarnodeOperation opVal;
                if (values[0].isConstant()) {
                    int b = values[0].getOffset() != 0L ? 0 : 1;
                    result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                    break;
                }
                if (!(values[0] instanceof VarnodeOperation) || (opVal = (VarnodeOperation)values[0]).getPCodeOp().getOpcode() != 37) break;
                result = opVal.getInputValues()[0];
                break;
            }
            case 38: {
                if (values[0].equals((Object)values[1])) {
                    result = new Varnode(addrFactory.getConstantAddress(0L), 1);
                    break;
                }
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                boolean v0 = values[0].getOffset() != 0L;
                boolean v1 = values[1].getOffset() != 0L;
                int b = v0 != v1 ? 1 : 0;
                result = new Varnode(addrFactory.getConstantAddress((long)b), 1);
                break;
            }
            case 39: {
                if (values[0].isConstant()) {
                    if (values[0].getOffset() == 0L) {
                        result = new Varnode(addrFactory.getConstantAddress(0L), 1);
                        break;
                    }
                    if (values[1].isConstant()) {
                        result = new Varnode(addrFactory.getConstantAddress(values[1].getOffset() == 0L ? 0L : 1L), 1);
                        break;
                    }
                    result = values[1];
                    break;
                }
                if (!values[1].isConstant()) break;
                if (values[1].getOffset() == 0L) {
                    result = new Varnode(addrFactory.getConstantAddress(0L), 1);
                    break;
                }
                result = values[0];
                break;
            }
            case 40: {
                if (values[0].isConstant() && values[0].getOffset() != 0L) {
                    result = new Varnode(addrFactory.getConstantAddress(1L), 1);
                    break;
                }
                if (values[1].isConstant() && values[1].getOffset() != 0L) {
                    result = new Varnode(addrFactory.getConstantAddress(1L), 1);
                    break;
                }
                if (!values[1].isConstant() || !values[0].isConstant()) break;
                result = new Varnode(addrFactory.getConstantAddress(0L), 1);
                break;
            }
            case 63: {
                if (values[0].isConstant()) {
                    long val = ResultsState.getUnsignedOffset(values[0], values[0].getSize());
                    val = val >> (int)(8L * values[1].getOffset()) & VALUE_MASK[output.getSize()];
                    result = new Varnode(addrFactory.getConstantAddress(val), output.getSize());
                    break;
                }
                if (values[1].getOffset() != 0L) break;
                if (values[0].getSize() == output.getSize()) {
                    result = values[0];
                    break;
                }
                if (!(values[0] instanceof VarnodeOperation)) break;
                VarnodeOperation inputOp = (VarnodeOperation)values[0];
                PcodeOp inputPcodeOp = inputOp.getPCodeOp();
                Varnode[] subInputValues = inputOp.getInputValues();
                if (inputPcodeOp.getOpcode() != 17 || subInputValues[0].getSize() != output.getSize()) break;
                result = subInputValues[0];
                break;
            }
        }
        if (result == null) {
            VarnodeOperation op = new VarnodeOperation(pcodeOp, values);
            op.setSimplified(true);
            result = op;
        }
        return result;
    }

    private static Varnode eillimnateCarryOp(PcodeOp pcodeOp, Varnode[] values, AddressFactory addrFactory, TaskMonitor monitor) throws CancelledException {
        if (values[0].isConstant()) {
            VarnodeOperation op = ResultsState.flipInputs(pcodeOp, values);
            pcodeOp = op.getPCodeOp();
        }
        PcodeOp twosCompOp = new PcodeOp(pcodeOp.getSeqnum(), 24, new Varnode[]{pcodeOp.getInput(1)}, ResultsState.getNewUnique(addrFactory, pcodeOp.getInput(1).getSize()));
        Varnode twosCompValue = ResultsState.simplify(twosCompOp, new Varnode[]{values[1]}, addrFactory, monitor);
        PcodeOp lessThanOp = new PcodeOp(pcodeOp.getSeqnum(), 16, new Varnode[]{twosCompOp.getOutput(), pcodeOp.getInput(0)}, pcodeOp.getOutput());
        return ResultsState.simplify(lessThanOp, new Varnode[]{twosCompValue, values[1]}, addrFactory, monitor);
    }

    private static Varnode combineLogicOrOperation(VarnodeOperation op, AddressFactory addrFactory) {
        Varnode[] outerInputValues = op.getInputValues();
        if (!outerInputValues[1].isConstant() || !(outerInputValues[0] instanceof VarnodeOperation)) {
            return null;
        }
        PcodeOp outerPcodeOp = op.getPCodeOp();
        VarnodeOperation innerOp = (VarnodeOperation)outerInputValues[0];
        PcodeOp innerPcodeOp = innerOp.getPCodeOp();
        Varnode[] innerInputValues = innerOp.getInputValues();
        if (outerPcodeOp.getOpcode() != innerPcodeOp.getOpcode() || !innerInputValues[1].isConstant()) {
            return null;
        }
        long outerConst = ResultsState.getUnsignedOffset(outerInputValues[1], outerInputValues[1].getSize());
        long innerConst = ResultsState.getUnsignedOffset(innerInputValues[1], innerInputValues[1].getSize());
        Varnode newConst = new Varnode(addrFactory.getConstantAddress(outerConst | innerConst), outerInputValues[1].getSize());
        return new VarnodeOperation(outerPcodeOp, new Varnode[]{innerInputValues[0], newConst});
    }

    private static Varnode combineDoubleShiftOperation(PcodeOp outerPcodeOp, Varnode[] outerInputValues, AddressFactory addrFactory) {
        if (!outerInputValues[1].isConstant() || !(outerInputValues[0] instanceof VarnodeOperation)) {
            return null;
        }
        VarnodeOperation innerOp = (VarnodeOperation)outerInputValues[0];
        PcodeOp innerPcodeOp = innerOp.getPCodeOp();
        Varnode[] innerInputValues = innerOp.getInputValues();
        if (innerInputValues.length != 2 || !innerInputValues[1].isConstant()) {
            return null;
        }
        int outerOpcode = outerPcodeOp.getOpcode();
        long shift = ResultsState.getUnsignedOffset(outerInputValues[1], outerInputValues[1].getSize());
        long combinedShift = 0L;
        if (outerOpcode == 30) {
            combinedShift = -shift;
        } else if (outerOpcode == 29) {
            combinedShift = shift;
        } else {
            return null;
        }
        int innerOpcode = innerPcodeOp.getOpcode();
        shift = ResultsState.getUnsignedOffset(outerInputValues[1], outerInputValues[1].getSize());
        if (innerOpcode == 30) {
            combinedShift -= shift;
        } else if (innerOpcode == 29) {
            combinedShift += shift;
        } else {
            return null;
        }
        if (combinedShift == 0L) {
            return innerInputValues[0];
        }
        int newOpcode = 29;
        if (combinedShift < 0L) {
            newOpcode = 30;
            combinedShift = -combinedShift;
        }
        Varnode newShift = new Varnode(addrFactory.getConstantAddress(combinedShift), outerInputValues[1].getSize());
        PcodeOp pcodeOp = new PcodeOp(outerPcodeOp.getSeqnum(), newOpcode, outerInputValues, outerPcodeOp.getOutput());
        return new VarnodeOperation(pcodeOp, new Varnode[]{innerInputValues[0], newShift});
    }

    private static VarnodeOperation flipInputs(PcodeOp pcodeOp, Varnode[] values) {
        Varnode[] inputs = pcodeOp.getInputs();
        if (inputs.length != 2 || values.length != 2) {
            throw new IllegalArgumentException("flipInputs handles two inputs only");
        }
        Varnode tmp = values[0];
        values[0] = values[1];
        values[1] = tmp;
        pcodeOp = new PcodeOp(pcodeOp.getSeqnum(), pcodeOp.getOpcode(), values, pcodeOp.getOutput());
        return new VarnodeOperation(pcodeOp, values);
    }

    private static boolean isBooleanOutputOperation(VarnodeOperation op) {
        PcodeOp pcodeOp = op.getPCodeOp();
        int opcode = pcodeOp.getOpcode();
        return opcode == 39 || opcode == 37 || opcode == 40 || opcode == 38 || opcode == 11 || opcode == 21 || opcode == 15 || opcode == 16 || opcode == 12 || opcode == 23 || opcode == 22 || opcode == 13 || opcode == 14;
    }

    private static Varnode simplifyWithIntAndMask(SequenceNumber seq, Varnode varnode, long andMask, AddressFactory addrFactory, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        if (!(varnode instanceof VarnodeOperation)) {
            if (varnode.isConstant()) {
                return new Varnode(addrFactory.getConstantAddress(andMask & varnode.getOffset()), varnode.getSize());
            }
            return null;
        }
        VarnodeOperation op = (VarnodeOperation)varnode;
        PcodeOp pcodeOp = op.getPCodeOp();
        int opcode = pcodeOp.getOpcode();
        if (ResultsState.isBooleanOutputOperation(op)) {
            if ((andMask & 1L) == 0L) {
                return new Varnode(addrFactory.getConstantAddress(0L), op.getSize());
            }
        } else {
            if (opcode == 27) {
                Varnode[] values = op.getInputValues();
                Varnode v0 = ResultsState.simplifyWithIntAndMask(seq, values[0], andMask, addrFactory, monitor);
                Varnode v1 = ResultsState.simplifyWithIntAndMask(seq, values[1], andMask, addrFactory, monitor);
                if (v0 == null && v1 == null) {
                    op.setSimplified(true);
                    return null;
                }
                if (v0 != null) {
                    values[0] = v0;
                }
                if (v1 != null) {
                    values[1] = v1;
                }
                return ResultsState.simplify(pcodeOp, values, addrFactory, monitor);
            }
            if (opcode == 28 || opcode == 26) {
                Varnode[] values = op.getInputValues();
                Varnode v0 = ResultsState.simplifyWithIntAndMask(seq, values[0], andMask, addrFactory, monitor);
                Varnode v1 = ResultsState.simplifyWithIntAndMask(seq, values[1], andMask, addrFactory, monitor);
                if (v0 == null && v1 == null) {
                    op.setSimplified(true);
                    return null;
                }
                if (v0 != null) {
                    values[0] = v0;
                }
                if (v1 != null) {
                    values[1] = v1;
                }
                return ResultsState.simplify(pcodeOp, values, addrFactory, monitor);
            }
            if (opcode == 29) {
                Varnode[] leftValues = op.getInputValues();
                if (leftValues[1].isConstant() && leftValues[0] instanceof VarnodeOperation) {
                    int leftShift = (int)leftValues[1].getOffset();
                    VarnodeOperation shiftedOp = (VarnodeOperation)leftValues[0];
                    long shiftedMask = VALUE_MASK[shiftedOp.getSize()] & andMask >>> leftShift;
                    if (shiftedMask == 0L) {
                        return new Varnode(addrFactory.getConstantAddress(0L), op.getSize());
                    }
                    Varnode modifiedOp = ResultsState.simplifyWithIntAndMask(seq, shiftedOp, shiftedMask, addrFactory, monitor);
                    if (modifiedOp != null) {
                        leftValues[0] = modifiedOp;
                        return ResultsState.simplify(pcodeOp, leftValues, addrFactory, monitor);
                    }
                }
            } else if (opcode == 30) {
                Varnode[] rightValues = op.getInputValues();
                if (rightValues[1].isConstant() && rightValues[0] instanceof VarnodeOperation) {
                    int rightShift = (int)rightValues[1].getOffset();
                    VarnodeOperation shiftedOp = (VarnodeOperation)rightValues[0];
                    long shiftedMask = VALUE_MASK[shiftedOp.getSize()] & andMask << rightShift;
                    if (shiftedMask == 0L) {
                        return new Varnode(addrFactory.getConstantAddress(0L), op.getSize());
                    }
                    Varnode modifiedOp = ResultsState.simplifyWithIntAndMask(seq, shiftedOp, shiftedMask, addrFactory, monitor);
                    if (modifiedOp != null) {
                        rightValues[0] = modifiedOp;
                        return ResultsState.simplify(pcodeOp, rightValues, addrFactory, monitor);
                    }
                }
            } else if (opcode == 63) {
                Varnode[] spValues = op.getInputValues();
                int shift = (int)spValues[1].getOffset() * 8;
                long modifiedMask = VALUE_MASK[spValues[0].getSize()] & andMask >> shift << shift;
                if (modifiedMask == 0L) {
                    return new Varnode(addrFactory.getConstantAddress(0L), op.getSize());
                }
                Varnode shiftedOp = ResultsState.simplifyWithIntAndMask(seq, spValues[0], modifiedMask, addrFactory, monitor);
                if (shiftedOp != null) {
                    spValues[0] = shiftedOp;
                    return ResultsState.simplify(pcodeOp, spValues, addrFactory, monitor);
                }
            } else if (opcode == 17) {
                Varnode[] inValues = op.getInputValues();
                long modifiedMask = VALUE_MASK[inValues[0].getSize()] & andMask;
                if (modifiedMask == 0L) {
                    return new Varnode(addrFactory.getConstantAddress(0L), op.getSize());
                }
                Varnode extendedOp = ResultsState.simplifyWithIntAndMask(seq, inValues[0], modifiedMask, addrFactory, monitor);
                if (extendedOp != null) {
                    inValues[0] = extendedOp;
                    return ResultsState.simplify(pcodeOp, inValues, addrFactory, monitor);
                }
            } else if (opcode == 19) {
                Varnode[] values = op.getInputValues();
                Varnode v0 = values[0];
                Varnode v1 = values[1];
                if (v1.isConstant() && v0 instanceof VarnodeOperation) {
                    if ((v1.getOffset() & (andMask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                        Varnode checkVn = ResultsState.simplifyWithIntAndMask(seq, v0, andMask, addrFactory, monitor);
                        if (checkVn != null && checkVn.isConstant() && checkVn.getOffset() == 0L) {
                            return v1;
                        }
                    } else if ((v1.getOffset() & andMask) == 0L) {
                        VarnodeOperation vop = (VarnodeOperation)v0;
                        return ResultsState.simplify(vop.getPCodeOp(), vop.getInputValues(), addrFactory, monitor);
                    }
                }
            }
        }
        op.setSimplified(true);
        return null;
    }

    private List<Address> handleIndirectFlow(PcodeOp pcodeOp, Varnode destValue, ContextState currentState, TaskMonitor monitor) throws CancelledException {
        List<Address> destinations = null;
        if (this.analyzer != null && (destinations = this.analyzer.unresolvedIndirectFlow(pcodeOp, this.findOpIndex(pcodeOp, pcodeOp.getInput(0)), destValue, currentState, this, monitor)) != null) {
            for (Address dest : destinations) {
                if (pcodeOp.getOpcode() == 6) {
                    this.todoList.add(new BranchDestination(pcodeOp.getSeqnum(), dest, currentState));
                }
                this.disassemble(dest, monitor);
            }
        }
        return destinations;
    }

    private void handleDirectFlow(PcodeOp pcodeOp, Address address, ContextState currentState, TaskMonitor monitor) throws CancelledException {
        int opcode = pcodeOp.getOpcode();
        if (opcode == 4 || opcode == 5) {
            this.todoList.add(new BranchDestination(pcodeOp.getSeqnum(), address, currentState));
        }
        if (this.analyzer != null && this.analyzer.resolvedFlow(pcodeOp, this.findOpIndex(pcodeOp, pcodeOp.getInput(0)), address, currentState, this, monitor)) {
            this.disassemble(address, monitor);
        }
    }

    private void disassemble(Address address, TaskMonitor monitor) throws CancelledException {
        CodeUnit cu = this.listing.getCodeUnitAt(address);
        if (cu instanceof Instruction) {
            return;
        }
        if (cu == null) {
            cu = this.listing.getCodeUnitContaining(address);
        }
        if (cu == null || !(cu instanceof Data) || ((Data)cu).isDefined()) {
            this.program.getBookmarkManager().setBookmark(cu == null ? address : cu.getMinAddress(), "Error", "Instruction Expected", "Expected instruction at " + String.valueOf(address));
            return;
        }
        if (DEBUG) {
            Msg.debug((Object)this, (Object)("Disassemble at " + String.valueOf(address)));
        }
        DisassembleCommand cmd = new DisassembleCommand(address, null, true);
        cmd.applyTo(this.program, monitor);
        monitor.checkCancelled();
    }

    private void checkAssignment(Varnode output, Varnode value, PcodeOp op, TaskMonitor monitor) throws CancelledException {
        Register reg;
        Varnode[] inputs = op.getInputs();
        int opcode = op.getOpcode();
        if (output != null && !output.isUnique() && opcode != 2 && opcode != 3 && opcode != 1) {
            this.checkStackOffsetAssignment(op, value, monitor);
        }
        if ((reg = this.program.getRegister(output.getAddress(), output.getSize())) == null || reg.isProgramCounter() || reg.isProcessorContext() || this.framePointerCandidatesDismissed.contains(reg.getBaseRegister())) {
            Msg.debug((Object)this, (Object)("SET: " + String.valueOf(output) + " = " + String.valueOf(value)));
            return;
        }
        if (this.addRegister(reg, this.registersModified)) {
            if (DEBUG) {
                Msg.debug((Object)this, (Object)("MODIFIED: " + String.valueOf(reg) + " = " + String.valueOf(value)));
            }
        } else {
            Msg.debug((Object)this, (Object)("SET: " + String.valueOf(output) + " = " + String.valueOf(value)));
        }
        if (this.framePointerCandidates.containsKey(reg)) {
            if (value.getAddress().equals((Object)reg.getAddress())) {
                return;
            }
            this.framePointerCandidatesDismissed.add(reg);
            this.framePointerCandidates.remove(reg);
            return;
        }
        if (opcode != 2 && (value.equals((Object)this.getStackPointerVarnode()) || inputs.length == 1 && inputs[0].equals((Object)this.getStackPointerVarnode()) || inputs.length == 2 && (inputs[0].equals((Object)this.getStackPointerVarnode()) || inputs[1].equals((Object)this.getStackPointerVarnode())))) {
            this.framePointerCandidates.put(reg, new FramePointerCandidate(reg, op.getSeqnum(), value));
            return;
        }
        this.framePointerCandidatesDismissed.add(reg);
    }

    private void checkStackOffsetAssignment(PcodeOp op, Varnode value, TaskMonitor monitor) throws CancelledException {
        Varnode[] inputs;
        if (this.analyzer == null || !(value instanceof VarnodeOperation)) {
            return;
        }
        Varnode output = op.getOutput();
        if (output == null || output.isUnique()) {
            return;
        }
        ContextState.FrameNode frameNode = ContextState.getFrameNode(value, this.program.getLanguage());
        if (frameNode == null || !this.getStackPointerVarnode().equals((Object)frameNode.getFramePointer())) {
            return;
        }
        for (Varnode input : inputs = op.getInputs()) {
            int opIndex;
            if (input.isConstant() || input.isUnique() && inputs.length != 1 || (opIndex = this.findOpIndex(op, input)) < 0) continue;
            this.analyzer.stackReference(op, opIndex, (int)frameNode.getFrameOffset(), -1, -1, RefType.DATA, monitor);
            return;
        }
    }

    public Collection<FramePointerCandidate> getFramePointerCandidates() {
        return this.framePointerCandidates.values();
    }

    public List<Register> getPreservedRegisters() {
        if (this.registersPreserved == null) {
            this.reconcileModifiedRegisters();
        }
        return this.registersPreserved;
    }

    public List<Register> getModifiedRegisters() {
        if (this.registersPreserved == null) {
            this.reconcileModifiedRegisters();
        }
        return this.registersModified;
    }

    private void reconcileModifiedRegisters() {
        if (this.busy) {
            throw new IllegalStateException("ResultsState.getPreservedRegisters and ResultsState.getModifiedRegisters may not be invoked during instantiation");
        }
        this.registersPreserved = new ArrayList();
        for (Register reg : this.registersModified) {
            if (!this.isPreserved(reg)) continue;
            this.registersPreserved.add(reg);
        }
        this.registersModified.removeAll(this.registersPreserved);
    }

    private boolean isPreserved(Register reg) {
        Varnode v = new Varnode(reg.getAddress(), reg.getMinimumByteSize());
        Set<Varnode> returnValues = this.getReturnValues(v);
        if (returnValues.isEmpty()) {
            return false;
        }
        for (Varnode val : returnValues) {
            if (v.equals((Object)val)) continue;
            return false;
        }
        return true;
    }

    private int findOpIndex(PcodeOp op, Varnode loc) {
        if (loc instanceof VarnodeOperation) {
            return -1;
        }
        Instruction instr = this.listing.getInstructionAt(op.getSeqnum().getTarget());
        int numOperands = instr.getNumOperands();
        for (int i = 0; i < numOperands; ++i) {
            PcodeOp[] operandPcode = instr.getPcode(i);
            if (operandPcode == null || operandPcode.length == 0 || !this.matchOpPcodeObjectAssignment(operandPcode, loc)) continue;
            return i;
        }
        int opMatchCnt = 0;
        int lastOpMatch = -1;
        for (int i = 0; i < numOperands; ++i) {
            if (!this.matchOpObject(instr, i, loc)) continue;
            ++opMatchCnt;
            lastOpMatch = i;
        }
        if (opMatchCnt == 1) {
            return lastOpMatch;
        }
        return -1;
    }

    private boolean matchOpPcodeObjectAssignment(PcodeOp[] operandPcode, Varnode loc) {
        for (PcodeOp op : operandPcode) {
            if (!loc.equals((Object)op.getOutput())) continue;
            return true;
        }
        return false;
    }

    private boolean matchOpObject(Instruction instr, int opIndex, Varnode loc) {
        Address addr = loc.getAddress();
        for (Object obj : instr.getDefaultOperandRepresentationList(opIndex)) {
            Register reg;
            if (!(obj instanceof Address ? addr.equals(obj) : obj instanceof Register && addr.equals((Object)(reg = (Register)obj).getAddress()))) continue;
            return true;
        }
        return false;
    }

    boolean isStackParameterOffset(long offset) {
        if (this.paramBaseStackOffset == null) {
            return false;
        }
        return this.stackGrowsNegative && offset >= this.paramBaseStackOffset || !this.stackGrowsNegative && offset <= this.paramBaseStackOffset;
    }

    private void checkInput(Varnode addressVarnode) {
        Address addr = addressVarnode.getAddress();
        Register reg = this.program.getRegister(addr, addressVarnode.getSize());
        if (reg == null || reg.isProcessorContext() || reg.isProgramCounter() || this.containsRegister(reg, this.registersModified)) {
            return;
        }
        this.addRegister(reg, this.inputRegs);
    }

    private boolean addRegister(Register reg, List<Register> regList) {
        for (int i = 0; i < regList.size(); ++i) {
            Register existingReg = regList.get(i);
            Register parentReg = reg.getParentRegister();
            if (existingReg == reg || existingReg == parentReg || existingReg == reg.getBaseRegister()) {
                return false;
            }
            if (parentReg == null || existingReg.getParentRegister() != parentReg) continue;
            regList.set(i, parentReg);
            return true;
        }
        regList.add(reg);
        return true;
    }

    private boolean containsRegister(Register reg, List<Register> regList) {
        for (Register existingReg : regList) {
            Register parentReg = reg.getParentRegister();
            if (existingReg == reg || existingReg == parentReg || existingReg == reg.getBaseRegister()) {
                return true;
            }
            if (parentReg == null || existingReg.getParentRegister() != parentReg) continue;
            return false;
        }
        return false;
    }

    public List<Register> getInputRegisters() {
        return this.inputRegs;
    }

    private void handleIndirectCall(PcodeOp pcodeOp, Address indirectPtr, Varnode destValue, ContextState currentState, TaskMonitor monitor) throws InlineCallException, CancelledException {
        Function func = null;
        Address destAddr = null;
        List<Address> destinations = this.handleIndirectFlow(pcodeOp, destValue, currentState, monitor);
        if (destinations != null && !destinations.isEmpty()) {
            destAddr = destinations.get(0);
        } else if (destValue.isConstant()) {
            destAddr = pcodeOp.getSeqnum().getTarget().getNewAddress(destValue.getOffset());
        }
        if (destAddr != null) {
            func = this.program.getListing().getFunctionAt(destAddr);
        }
        if (func == null) {
            Address thunkAddr;
            if (indirectPtr != null) {
                func = this.program.getListing().getFunctionAt(indirectPtr);
            } else if (destValue.isConstant() && (thunkAddr = this.externalThunkMap.get(destAddr.getOffset())) != null) {
                func = this.program.getListing().getFunctionAt(thunkAddr);
            }
        } else if (func.isInline()) {
            throw new InlineCallException(func.getEntryPoint());
        }
        if (func == null) {
            if (DEBUG) {
                Msg.debug((Object)this, (Object)("Function not found at " + String.valueOf(indirectPtr) + " indirectly called from " + String.valueOf(pcodeOp.getSeqnum().getTarget()) + " - call affects unknown"));
            }
            return;
        }
        this.applyFunctionAffects(pcodeOp.getSeqnum(), destAddr, func, currentState, monitor);
        this.applyFunctionPurge(pcodeOp.getSeqnum(), destAddr, func, currentState, monitor);
    }

    private void handleCall(PcodeOp pcodeOp, Address indirectPtr, Address destAddr, ContextState currentState, TaskMonitor monitor) throws InlineCallException, CancelledException {
        this.handleDirectFlow(pcodeOp, destAddr, currentState, monitor);
        Function func = this.program.getListing().getFunctionAt(destAddr);
        if (func == null) {
            if (indirectPtr != null) {
                func = this.program.getListing().getFunctionAt(indirectPtr);
            } else {
                Address thunkAddr = this.externalThunkMap.get(destAddr.getOffset());
                if (thunkAddr != null) {
                    func = this.program.getListing().getFunctionAt(thunkAddr);
                }
            }
        } else if (func.isInline()) {
            throw new InlineCallException(func.getEntryPoint());
        }
        if (func == null) {
            if (DEBUG) {
                Msg.debug((Object)this, (Object)("Function not found at " + String.valueOf(destAddr) + " called from " + String.valueOf(pcodeOp.getSeqnum().getTarget()) + " - call affects unknown"));
            }
            return;
        }
        this.applyFunctionAffects(pcodeOp.getSeqnum(), destAddr, func, currentState, monitor);
        this.applyFunctionPurge(pcodeOp.getSeqnum(), destAddr, func, currentState, monitor);
    }

    private void applyFunctionAffects(SequenceNumber calledFrom, Address destAddr, Function func, ContextState currentState, TaskMonitor monitor) {
        PrototypeModel callingConvention = null;
        if (func != null) {
            callingConvention = func.getCallingConvention();
        }
        if (callingConvention == null) {
            callingConvention = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        DataType returnType = null;
        if (func == null) {
            if (DEBUG) {
                Msg.debug((Object)this, (Object)("No function at " + String.valueOf(destAddr) + " called from " + String.valueOf(calledFrom.getTarget()) + " - default return/affects assumed"));
            }
        } else {
            returnType = func.getReturnType();
            if (VoidDataType.isVoidDataType((DataType)returnType)) {
                return;
            }
        }
        VariableStorage retStorage = callingConvention.getReturnLocation(returnType, this.program);
        Varnode varnode = null;
        if (retStorage.isValid() && retStorage.getVarnodeCount() == 1) {
            varnode = retStorage.getFirstVarnode();
        }
        if (varnode != null) {
            currentState.store(varnode, this.getInvalidatedVarnode(calledFrom, varnode));
        }
    }

    private VarnodeOperation getInvalidatedVarnode(SequenceNumber seq, Varnode affectVarnode) {
        PcodeOp op = new PcodeOp(seq, 61, 0, affectVarnode);
        return new VarnodeOperation(op, op.getInputs());
    }

    private void applyFunctionPurge(SequenceNumber calledFrom, Address destAddr, Function func, ContextState currentState, TaskMonitor monitor) throws CancelledException {
        PrototypeModel callingConvention = null;
        if (func != null) {
            callingConvention = func.getCallingConvention();
        }
        if (callingConvention == null) {
            callingConvention = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        int stackShift = callingConvention.getStackshift();
        int purge = ResultsState.getFunctionPurge(this.program, func);
        if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
            Object name;
            Object object = name = func != null ? func.getName() : "at " + String.valueOf(destAddr);
            if (DEBUG) {
                Msg.debug((Object)this, (Object)("Stack purge unknown for function " + (String)name + " called from " + String.valueOf(calledFrom.getTarget()) + " - stack pointer invalidated"));
            }
            currentState.store(this.getStackPointerVarnode(), this.getInvalidatedVarnode(calledFrom, this.getStackPointerVarnode()));
            return;
        }
        if ((purge += stackShift) == 0) {
            return;
        }
        Varnode stackVarnode = this.getStackPointerVarnode();
        Varnode purgeVal = new Varnode(this.program.getAddressFactory().getConstantAddress((long)purge), stackVarnode.getSize());
        Varnode stackVal = currentState.get(stackVarnode, monitor);
        if (stackVal == null) {
            stackVal = stackVarnode;
        }
        Varnode purgeResult = null;
        if (stackVal instanceof VarnodeOperation) {
            purgeResult = ResultsState.pushDownIntAddOffset((VarnodeOperation)stackVal, purge, this.addrFactory, monitor);
        }
        if (purgeResult == null) {
            PcodeOp purgePcodeOp = new PcodeOp(calledFrom, 19, new Varnode[]{stackVarnode, purgeVal}, stackVarnode);
            purgeResult = new VarnodeOperation(purgePcodeOp, new Varnode[]{stackVal, purgeVal});
        }
        currentState.store(stackVarnode, purgeResult);
    }

    private static int getFunctionPurge(Program functionProgram, Function func) {
        if (func == null) {
            return ResultsState.getDefaultStackDepthChange(functionProgram, Integer.MAX_VALUE);
        }
        int depth = func.getStackPurgeSize();
        if (func.isStackPurgeSizeValid()) {
            return depth;
        }
        PrototypeModel proto = func.getCallingConvention();
        if (proto == null) {
            return ResultsState.getDefaultStackDepthChange(functionProgram, depth);
        }
        int callStackMod = proto.getExtrapop();
        int callStackShift = proto.getStackshift();
        if (callStackMod != 32768 && callStackShift >= 0) {
            return callStackShift - callStackMod;
        }
        return depth;
    }

    private static int getDefaultStackDepthChange(Program depthProgram, int depth) {
        PrototypeModel defaultModel = depthProgram.getCompilerSpec().getDefaultCallingConvention();
        int callStackMod = defaultModel.getExtrapop();
        int callStackShift = defaultModel.getStackshift();
        if (callStackMod != 32768 && callStackShift >= 0) {
            return callStackShift - callStackMod;
        }
        return depth;
    }

    public Varnode getStackPointerVarnode() {
        if (this.stackVarnode != null) {
            return this.stackVarnode;
        }
        Register stackReg = this.program.getCompilerSpec().getStackPointer();
        if (stackReg == null) {
            return null;
        }
        this.stackVarnode = new Varnode(stackReg.getAddress(), stackReg.getMinimumByteSize());
        return this.stackVarnode;
    }

    private static Varnode pushDownIntAddOffset(VarnodeOperation op, long offset, AddressFactory addrFactory, TaskMonitor monitor) {
        PcodeOp pcodeOp = op.getPCodeOp();
        if (pcodeOp.getOpcode() == 19 || pcodeOp.getOpcode() == 20) {
            Varnode newOpValue0;
            Varnode[] opValues = op.getInputValues();
            if (opValues[1].isConstant()) {
                long newOffset;
                if (pcodeOp.getOpcode() == 20) {
                    offset = -offset;
                }
                if ((newOffset = ResultsState.getSignedOffset(opValues[1]) + offset) == 0L) {
                    return opValues[0];
                }
                Varnode[] simplifiedInputValues = new Varnode[]{opValues[0], new Varnode(addrFactory.getConstantAddress(newOffset & VALUE_MASK[op.getSize()]), op.getSize())};
                return new VarnodeOperation(pcodeOp, simplifiedInputValues);
            }
            if (opValues[0] instanceof VarnodeOperation && (newOpValue0 = ResultsState.pushDownIntAddOffset((VarnodeOperation)opValues[0], offset, addrFactory, monitor)) != null) {
                Varnode[] simplifiedInputValues = new Varnode[]{newOpValue0, opValues[1]};
                return new VarnodeOperation(pcodeOp, simplifiedInputValues);
            }
        }
        return null;
    }

    public Set<SequenceNumber> getReturnAddresses() {
        return this.endStateMap.keySet();
    }

    public Set<Varnode> getReturnValues(Varnode varnode) {
        HashSet<Varnode> valueSet = new HashSet<Varnode>();
        for (List<ContextState> endStateList : this.endStateMap.values()) {
            for (ContextState state : endStateList) {
                Varnode val = state.get(varnode);
                if (val == null) continue;
                valueSet.add(val);
            }
        }
        return valueSet;
    }

    public static long getUnsignedOffset(Varnode v, int size) {
        if (size == 0 || size >= 8) {
            return v.getOffset();
        }
        return VALUE_MASK[size] & v.getOffset();
    }

    public static long getSignedOffset(Varnode v) {
        int size = v.getSize();
        if (size == 0 || size >= 8) {
            return v.getOffset();
        }
        long offset = v.getOffset();
        if (offset > 0L && (offset & SIGN_BIT[size]) != 0L) {
            offset |= VALUE_MASK[size] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return offset;
    }

    private static class BranchDestination {
        private final SequenceNumber source;
        private final SequenceNumber destination;
        private final ContextState initialState;

        BranchDestination(SequenceNumber source, Address destinationAddress, ContextState initialState) {
            this(source, new SequenceNumber(destinationAddress, 0), initialState);
        }

        BranchDestination(SequenceNumber source, SequenceNumber destination, ContextState initialState) {
            this.source = source;
            this.destination = destination;
            this.initialState = initialState;
        }
    }

    private static class ContextStateSet
    extends HashMap<SequenceNumber, ContextState> {
        private final SequenceRange seqRange;

        ContextStateSet(SequenceRange seqRange) {
            this.seqRange = seqRange;
        }
    }

    private static class InlineCallException
    extends Exception {
        private final Address destAddr;

        public InlineCallException(Address destAddr) {
            this.destAddr = destAddr;
        }

        public Address getInlineCallAddress() {
            return this.destAddr;
        }
    }

    public class FramePointerCandidate {
        public final Register register;
        public final SequenceNumber assignedAt;
        public final Varnode value;

        FramePointerCandidate(Register register, SequenceNumber assignedAt, Varnode value) {
            this.register = register;
            this.assignedAt = assignedAt;
            this.value = value;
        }

        public String toString() {
            return "(" + String.valueOf(this.assignedAt.getTarget()) + ", " + this.register.getName() + "=" + this.value.toString(ResultsState.this.program.getLanguage()) + ")";
        }
    }
}

